/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBindingComparator;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;

public class DefaultFragmentBindingComparator
implements IIndexFragmentBindingComparator {
    public int compare(IIndexFragmentBinding a, IIndexFragmentBinding b) {
        int cmp = this.compareQualifiedNames(a.getQualifiedName(), b.getQualifiedName());
        if (cmp == 0) {
            int bc;
            int ac = a.getBindingConstant();
            int n = ac < (bc = b.getBindingConstant()) ? -1 : (cmp = ac > bc ? 1 : 0);
            if (cmp == 0) {
                cmp = IndexCPPSignatureUtil.compareSignatures(a, b);
            }
        }
        return cmp;
    }

    private int compareQualifiedNames(String[] afqn, String[] bfqn) {
        if (afqn.length < bfqn.length) {
            return -1;
        }
        if (afqn.length > bfqn.length) {
            return 1;
        }
        int i = 0;
        while (i < afqn.length) {
            int cmp = afqn[i].compareTo(bfqn[i]);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }
}

