/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticUtil {
    private static final char[] OPERATOR_CHARS = "operator".toCharArray();
    private static final CharArraySet cas = new CharArraySet(OverloadableOperator.values().length);
    public static final int TDEF = 1;
    public static final int REF = 2;
    public static final int CVQ = 4;
    public static final int PTR_CVQ = 8;
    public static final int PTR = 16;
    public static final int MPTR = 32;
    public static final int ARRAY = 64;

    static {
        int OPERATOR_SPC = OPERATOR_CHARS.length + 1;
        OverloadableOperator[] overloadableOperatorArray = OverloadableOperator.values();
        int n = overloadableOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            OverloadableOperator op = overloadableOperatorArray[n2];
            char[] name = op.toCharArray();
            cas.put(CharArrayUtils.subarray(name, OPERATOR_SPC, name.length));
            ++n2;
        }
    }

    public static final ICPPMethod[] getDeclaredConversionOperators(ICPPClassType clazz) throws DOMException {
        ICPPMethod[] decs;
        Object[] methods = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        if (clazz instanceof ICPPDeferredClassInstance) {
            clazz = (ICPPClassType)((Object)((ICPPDeferredClassInstance)clazz).getTemplateDefinition());
        }
        if ((decs = clazz.getDeclaredMethods()) != null) {
            ICPPMethod[] iCPPMethodArray = decs;
            int n = decs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                if (SemanticUtil.isConversionOperator(method)) {
                    methods = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, methods, method);
                }
                ++n2;
            }
        }
        return methods;
    }

    public static ICPPMethod[] getConversionOperators(ICPPClassType clazz) throws DOMException {
        Object[] methods = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        ObjectSet<ICPPClassType> ancestry = SemanticUtil.inheritanceClosure(clazz);
        int i = 0;
        while (i < ancestry.size()) {
            methods = (ICPPMethod[])ArrayUtil.addAll(ICPPMethod.class, methods, SemanticUtil.getDeclaredConversionOperators((ICPPClassType)ancestry.keyAt(i)));
            ++i;
        }
        return methods;
    }

    public static ObjectSet<ICPPClassType> inheritanceClosure(ICPPClassType root) throws DOMException {
        ObjectSet<ICPPClassType> done = new ObjectSet<ICPPClassType>(2);
        ObjectSet<ICPPClassType> current = new ObjectSet<ICPPClassType>(2);
        current.put(root);
        int count = 0;
        while (count < 10 && !current.isEmpty()) {
            ObjectSet<ICPPClassType> next = new ObjectSet<ICPPClassType>(2);
            int i = 0;
            while (i < current.size()) {
                ICPPClassType clazz = (ICPPClassType)current.keyAt(i);
                done.put(clazz);
                ICPPBase[] iCPPBaseArray = clazz.getBases();
                int n = iCPPBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPClassType ct;
                    ICPPBase base = iCPPBaseArray[n2];
                    IBinding binding = base.getBaseClass();
                    if (binding instanceof ICPPClassType && !(binding instanceof IProblemBinding) && !done.containsKey(ct = (ICPPClassType)binding)) {
                        next.put(ct);
                    }
                    ++n2;
                }
                ++i;
            }
            current = next;
            ++count;
        }
        return done;
    }

    public static final boolean isConversionOperator(ICPPMethod method) {
        char[] name;
        boolean result = false;
        if (!method.isImplicit() && (name = method.getNameCharArray()).length > OPERATOR_CHARS.length + 1 && CharArrayUtils.equals(name, 0, OPERATOR_CHARS.length, OPERATOR_CHARS) && name[OPERATOR_CHARS.length] == ' ') {
            result = !cas.containsKey(name, OPERATOR_CHARS.length + 1, name.length - (OPERATOR_CHARS.length + 1));
        }
        return result;
    }

    public static IType getUltimateType(IType type, boolean stopAtPointerToMember) {
        return SemanticUtil.getNestedType(type, stopAtPointerToMember ? 87 : 119);
    }

    public static IType getUltimateTypeUptoPointers(IType type) {
        return SemanticUtil.getNestedType(type, 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IType getNestedType(IType type, int options) {
        boolean mptr;
        boolean tdef = (options & 1) != 0;
        boolean ptrcvq = (options & 8) != 0;
        boolean ptr = (options & 0x10) != 0;
        boolean bl = mptr = (options & 0x20) != 0;
        assert (!ptrcvq || !ptr && !mptr);
        try {
            while (true) {
                IType t = null;
                if (type instanceof IPointerType) {
                    boolean isMbrPtr = type instanceof ICPPPointerToMemberType;
                    if (ptr && !isMbrPtr || mptr && isMbrPtr) {
                        t = ((IPointerType)type).getType();
                    } else if (ptrcvq) {
                        if (type instanceof CPPPointerType) {
                            return ((CPPPointerType)type).stripQualifiers();
                        }
                        IPointerType p = (IPointerType)type;
                        if (p.isConst() || p.isVolatile()) {
                            if (!(p instanceof ICPPPointerToMemberType)) return new CPPPointerType(p.getType(), false, false);
                            IType memberOfClass = ((ICPPPointerToMemberType)p).getMemberOfClass();
                            if (memberOfClass instanceof ICPPClassType) {
                                return new CPPPointerToMemberType(p.getType(), memberOfClass, false, false);
                            }
                        }
                    }
                } else if (tdef && type instanceof ITypedef) {
                    t = ((ITypedef)type).getType();
                } else if (type instanceof IQualifierType) {
                    IType temp;
                    IQualifierType qt = (IQualifierType)type;
                    if ((options & 4) != 0) {
                        t = qt.getType();
                    } else if (tdef && (temp = qt.getType()) instanceof ITypedef) {
                        temp = SemanticUtil.getNestedType(temp, 1);
                        return SemanticUtil.addQualifiers(temp, qt.isConst(), qt.isVolatile());
                    }
                } else if ((options & 0x40) != 0 && type instanceof IArrayType) {
                    t = ((IArrayType)type).getType();
                } else if ((options & 2) != 0 && type instanceof ICPPReferenceType) {
                    t = ((ICPPReferenceType)type).getType();
                }
                if (t == null) {
                    return type;
                }
                type = t;
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    static IType getSimplifiedType(IType type) {
        try {
            if (type instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)type;
                IType ret = null;
                IType[] params = null;
                IType r = ft.getReturnType();
                ret = SemanticUtil.getSimplifiedType(r);
                IType[] ps = ft.getParameterTypes();
                params = SemanticUtil.getSimplifiedTypes(ps);
                if (ret == r && params == ps) {
                    return type;
                }
                return new CPPFunctionType(ret, params, ft.isConst(), ft.isVolatile());
            }
            if (type instanceof ITypedef) {
                IType t = ((ITypedef)type).getType();
                if (t != null) {
                    return SemanticUtil.getSimplifiedType(t);
                }
                return type;
            }
            if (type instanceof ITypeContainer) {
                ITypeContainer tc = (ITypeContainer)type;
                IType nestedType = tc.getType();
                if (nestedType == null) {
                    return type;
                }
                IType newType = SemanticUtil.getSimplifiedType(nestedType);
                if (newType != nestedType) {
                    return SemanticUtil.replaceNestedType(tc, newType);
                }
                return type;
            }
        }
        catch (DOMException dOMException) {}
        return type;
    }

    public static IType replaceNestedType(ITypeContainer type, IType newNestedType) throws DOMException {
        if (type instanceof IQualifierType) {
            IQualifierType qt = (IQualifierType)((Object)type);
            return SemanticUtil.addQualifiers(newNestedType, qt.isConst(), qt.isVolatile());
        }
        type = (ITypeContainer)type.clone();
        type.setType(newNestedType);
        return type;
    }

    public static IType[] getSimplifiedTypes(IType[] types) {
        IType[] result = types;
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            IType newType = SemanticUtil.getSimplifiedType(type);
            if (result != types) {
                result[i] = newType;
            } else if (type != newType) {
                result = new IType[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = newType;
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument[] getSimplifiedArguments(ICPPTemplateArgument[] args) {
        ICPPTemplateArgument[] result = args;
        int i = 0;
        while (i < args.length) {
            ICPPTemplateArgument arg;
            ICPPTemplateArgument newArg = arg = args[i];
            if (arg != null) {
                newArg = SemanticUtil.getSimplifiedArgument(arg);
                if (result != args) {
                    result[i] = newArg;
                } else if (arg != newArg) {
                    result = new ICPPTemplateArgument[args.length];
                    if (i > 0) {
                        System.arraycopy(args, 0, result, 0, i);
                    }
                    result[i] = newArg;
                }
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument getSimplifiedArgument(ICPPTemplateArgument arg) {
        IType type;
        IType newType;
        if (arg.isTypeValue() && (newType = SemanticUtil.getSimplifiedType(type = arg.getTypeValue())) != type) {
            return new CPPTemplateArgument(newType);
        }
        return arg;
    }

    public static IType adjustParameterType(IType pt, boolean forFunctionType) {
        IType t = SemanticUtil.getNestedType(pt, 1);
        try {
            if (t instanceof IArrayType) {
                IArrayType at = (IArrayType)t;
                return new CPPPointerType(at.getType());
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        if (t instanceof IFunctionType) {
            return new CPPPointerType(pt);
        }
        if (forFunctionType && (t instanceof IQualifierType || t instanceof IPointerType)) {
            return SemanticUtil.getNestedType(t, 13);
        }
        return pt;
    }

    public static IType addQualifiers(IType baseType, boolean cnst, boolean vol) {
        if (cnst || vol) {
            try {
                if (baseType instanceof IQualifierType) {
                    IQualifierType qt = (IQualifierType)baseType;
                    if (cnst && !qt.isConst() || vol && !qt.isVolatile()) {
                        return new CPPQualifierType(qt.getType(), cnst || qt.isConst(), vol || qt.isVolatile());
                    }
                    return baseType;
                }
                if (baseType instanceof ICPPPointerToMemberType) {
                    ICPPPointerToMemberType pt = (ICPPPointerToMemberType)baseType;
                    if (cnst && !pt.isConst() || vol && !pt.isVolatile()) {
                        return new CPPPointerToMemberType(pt.getType(), pt.getMemberOfClass(), cnst || pt.isConst(), vol || pt.isVolatile());
                    }
                    return baseType;
                }
                if (baseType instanceof IPointerType) {
                    IPointerType pt = (IPointerType)baseType;
                    if (cnst && !pt.isConst() || vol && !pt.isVolatile()) {
                        return new CPPPointerType(pt.getType(), cnst || pt.isConst(), vol || pt.isVolatile());
                    }
                    return baseType;
                }
            }
            catch (DOMException dOMException) {}
            return new CPPQualifierType(baseType, cnst, vol);
        }
        return baseType;
    }
}

