/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPSpecialization
extends PlatformObject
implements ICPPSpecialization,
ICPPInternalBinding {
    private IBinding owner;
    private IBinding specialized;
    private ICPPTemplateParameterMap argumentMap;
    protected IASTNode definition;
    private IASTNode[] declarations;

    public CPPSpecialization(IBinding specialized, IBinding owner, ICPPTemplateParameterMap argumentMap) {
        this.specialized = specialized;
        this.owner = owner;
        this.argumentMap = argumentMap;
    }

    public IType specializeType(IType type) throws DOMException {
        if (this.owner instanceof ICPPClassSpecialization) {
            return CPPTemplates.instantiateType(type, this.getTemplateParameterMap(), (ICPPClassSpecialization)this.owner);
        }
        return CPPTemplates.instantiateType(type, this.getTemplateParameterMap(), null);
    }

    public IValue specializeValue(IValue value, int maxdepth) {
        if (this.owner instanceof ICPPClassSpecialization) {
            return CPPTemplates.instantiateValue(value, this.getTemplateParameterMap(), (ICPPClassSpecialization)this.owner, maxdepth);
        }
        return CPPTemplates.instantiateValue(value, this.getTemplateParameterMap(), null, maxdepth);
    }

    public IBinding getSpecializedBinding() {
        return this.specialized;
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public void addDefinition(IASTNode node) {
        this.definition = node;
    }

    public void addDeclaration(IASTNode node) {
        this.declarations = this.declarations == null ? new IASTNode[]{node} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)this.declarations[0]).getOffset() ? (IASTNode[])ArrayUtil.prepend(IASTNode.class, this.declarations, node) : (IASTNode[])ArrayUtil.append(IASTNode.class, this.declarations, node));
    }

    public String getName() {
        return this.specialized.getName();
    }

    public char[] getNameCharArray() {
        return this.specialized.getNameCharArray();
    }

    public IBinding getOwner() {
        return this.owner;
    }

    public IScope getScope() throws DOMException {
        if (this.owner instanceof ICPPClassType) {
            return ((ICPPClassType)this.owner).getCompositeScope();
        }
        if (this.owner instanceof ICPPNamespace) {
            return ((ICPPNamespace)this.owner).getNamespaceScope();
        }
        if (this.owner instanceof ICPPFunction) {
            return ((ICPPFunction)this.owner).getFunctionScope();
        }
        if (this.definition != null) {
            return CPPVisitor.getContainingScope(this.definition);
        }
        if (this.declarations != null && this.declarations.length > 0) {
            return CPPVisitor.getContainingScope(this.declarations[0]);
        }
        return this.specialized.getScope();
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        if (this.specialized instanceof ICPPBinding) {
            return ((ICPPBinding)this.specialized).isGloballyQualified();
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Deprecated
    public ObjectMap getArgumentMap() {
        return CPPTemplates.getArgumentMap(this, this.getTemplateParameterMap());
    }

    public ICPPTemplateParameterMap getTemplateParameterMap() {
        return this.argumentMap;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getName());
        if (this.argumentMap != null) {
            result.append(" ");
            result.append(this.argumentMap.toString());
        }
        return result.toString();
    }
}

