/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;

public class CPPPointerToMemberType
extends CPPPointerType
implements ICPPPointerToMemberType {
    private ICPPASTPointerToMember operator;
    private IType classType;

    public CPPPointerToMemberType(IType type, ICPPASTPointerToMember operator) {
        super(type, operator);
        this.operator = operator;
    }

    public CPPPointerToMemberType(IType type, IType thisType, boolean isConst, boolean isVolatile) {
        super(type, isConst, isVolatile);
        this.classType = thisType;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof ICPPPointerToMemberType)) {
            return false;
        }
        if (!super.isSameType(o)) {
            return false;
        }
        ICPPPointerToMemberType pt = (ICPPPointerToMemberType)o;
        IType cls = pt.getMemberOfClass();
        if (cls != null) {
            return cls.isSameType(this.getMemberOfClass());
        }
        return false;
    }

    public IType getMemberOfClass() {
        if (this.classType == null) {
            IBinding binding;
            ICPPASTPointerToMember pm = this.operator;
            IASTName name = pm.getName();
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                name = ns.length > 1 ? ns[ns.length - 2] : ns[ns.length - 1];
            }
            this.classType = (binding = name.resolvePreBinding()) instanceof IType ? (IType)((Object)binding) : new CPPClassType.CPPClassTypeProblem((IASTNode)name, 5, name.toCharArray());
        }
        return this.classType;
    }
}

