/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;

public class CPPASTImplicitName
extends CPPASTName
implements IASTImplicitName {
    private boolean alternate = false;
    private boolean isOperator = false;

    public CPPASTImplicitName(char[] name, IASTNode parent) {
        super(name);
        this.setParent(parent);
        this.setPropertyInParent(IASTImplicitNameOwner.IMPLICIT_NAME);
    }

    public CPPASTImplicitName(OverloadableOperator op, IASTNode parent) {
        this(op.toCharArray(), parent);
        this.isOperator = true;
    }

    public CPPASTImplicitName copy() {
        throw new UnsupportedOperationException();
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public void setAlternate(boolean alternate) {
        this.alternate = alternate;
    }

    public boolean accept(ASTVisitor action) {
        if (!this.alternate && action.shouldVisitImplicitNames || this.alternate && action.shouldVisitImplicitNameAlternates) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isDeclaration() {
        return false;
    }

    public boolean isDefinition() {
        return false;
    }

    public boolean isReference() {
        return true;
    }

    public void computeOperatorOffsets(IASTNode relativeNode, boolean trailing) {
        if (relativeNode == null) {
            return;
        }
        try {
            IToken first = trailing ? relativeNode.getTrailingSyntax() : relativeNode.getLeadingSyntax();
            int offset = ((ASTNode)relativeNode).getOffset() + first.getOffset();
            if (trailing) {
                offset += ((ASTNode)relativeNode).getLength();
            }
            OverloadableOperator oo = OverloadableOperator.valueOf(first);
            if (first.getNext() == null && oo != null || Arrays.equals(first.getCharImage(), "delete".toCharArray()) || Arrays.equals(first.getCharImage(), "new".toCharArray())) {
                int length = first.getLength();
                this.setOffsetAndLength(offset, length);
            } else {
                this.setOffsetAndLength(offset, 0);
            }
        }
        catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
            ASTNode parent = (ASTNode)this.getParent();
            this.setOffsetAndLength(parent.getOffset() + parent.getLength(), 0);
        }
    }

    public void setOperator(boolean isOperator) {
        this.isOperator = isOperator;
    }

    public boolean isOperator() {
        return this.isOperator;
    }
}

