/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;

public class CPPASTCompoundStatement
extends ASTNode
implements IASTCompoundStatement,
IASTAmbiguityParent {
    private IASTStatement[] statements = new IASTStatement[2];
    private ICPPScope scope = null;

    public CPPASTCompoundStatement copy() {
        CPPASTCompoundStatement copy = new CPPASTCompoundStatement();
        IASTStatement[] iASTStatementArray = this.getStatements();
        int n = iASTStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement statement = iASTStatementArray[n2];
            copy.addStatement(statement == null ? null : statement.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTStatement[] getStatements() {
        if (this.statements == null) {
            return IASTStatement.EMPTY_STATEMENT_ARRAY;
        }
        return (IASTStatement[])ArrayUtil.trim(IASTStatement.class, this.statements);
    }

    public void addStatement(IASTStatement statement) {
        this.assertNotFrozen();
        this.statements = (IASTStatement[])ArrayUtil.append(IASTStatement.class, this.statements, statement);
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(NESTED_STATEMENT);
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTStatement[] s = this.getStatements();
        int i = 0;
        while (i < s.length) {
            if (!s[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.statements == null) {
            return;
        }
        int i = 0;
        while (i < this.statements.length) {
            if (this.statements[i] == child) {
                other.setParent(this.statements[i].getParent());
                other.setPropertyInParent(this.statements[i].getPropertyInParent());
                this.statements[i] = (IASTStatement)other;
            }
            ++i;
        }
    }
}

