/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.eclipse.cdt.internal.core.index.IIndexType;

public class CBasicType
implements ICBasicType {
    public static final int IS_LONG = 1;
    public static final int IS_LONGLONG = 2;
    public static final int IS_SHORT = 4;
    public static final int IS_SIGNED = 8;
    public static final int IS_UNSIGNED = 16;
    public static final int IS_COMPLEX = 32;
    public static final int IS_IMAGINARY = 64;
    private int type = 0;
    private int qualifiers = 0;
    private IASTExpression value = null;

    public CBasicType(ICASTSimpleDeclSpecifier sds) {
        this.type = sds.getType();
        this.qualifiers = (sds.isLong() ? 1 : 0) | (sds.isShort() ? 4 : 0) | (sds.isSigned() ? 8 : 0) | (sds.isUnsigned() ? 16 : 0) | (sds.isLongLong() ? 2 : 0) | (sds.isComplex() ? 32 : 0) | (sds.isImaginary() ? 64 : 0);
        if (this.type == 0) {
            this.type = (this.qualifiers & 0x60) != 0 ? 4 : 3;
        }
    }

    public CBasicType(int type, int qualifiers) {
        this.type = type;
        this.qualifiers = qualifiers;
        if (type == 0) {
            type = (qualifiers & 0x60) != 0 ? 4 : 3;
        }
    }

    public CBasicType(int type, int qualifiers, IASTExpression value) {
        this.type = type;
        this.qualifiers = qualifiers;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public boolean isSigned() {
        return (this.qualifiers & 8) != 0;
    }

    public boolean isUnsigned() {
        return (this.qualifiers & 0x10) != 0;
    }

    public boolean isShort() {
        return (this.qualifiers & 4) != 0;
    }

    public boolean isLong() {
        return (this.qualifiers & 1) != 0;
    }

    public boolean isLongLong() {
        return (this.qualifiers & 2) != 0;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef || obj instanceof IIndexType) {
            return obj.isSameType(this);
        }
        if (!(obj instanceof CBasicType)) {
            return false;
        }
        CBasicType cObj = (CBasicType)obj;
        if (this.type != cObj.type) {
            return false;
        }
        if (this.type == 3) {
            return (this.qualifiers & 0xFFFFFFF7) == (cObj.qualifiers & 0xFFFFFFF7);
        }
        return this.qualifiers == cObj.qualifiers;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Deprecated
    public IASTExpression getValue() {
        return this.value;
    }

    public void setValue(IASTExpression expression) {
        this.value = expression;
    }

    public boolean isComplex() {
        return (this.qualifiers & 0x20) != 0;
    }

    public boolean isImaginary() {
        return (this.qualifiers & 0x40) != 0;
    }
}

