/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;

public class CASTFunctionCallExpression
extends ASTNode
implements IASTFunctionCallExpression,
IASTAmbiguityParent {
    private IASTExpression functionName;
    private IASTExpression parameter;

    public CASTFunctionCallExpression() {
    }

    public CASTFunctionCallExpression(IASTExpression functionName, IASTExpression parameter) {
        this.setFunctionNameExpression(functionName);
        this.setParameterExpression(parameter);
    }

    public CASTFunctionCallExpression copy() {
        CASTFunctionCallExpression copy = new CASTFunctionCallExpression();
        copy.setFunctionNameExpression(this.functionName == null ? null : this.functionName.copy());
        copy.setParameterExpression(this.parameter == null ? null : this.parameter.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public void setFunctionNameExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.functionName = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FUNCTION_NAME);
        }
    }

    public IASTExpression getFunctionNameExpression() {
        return this.functionName;
    }

    public void setParameterExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.parameter = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(PARAMETERS);
        }
    }

    public IASTExpression getParameterExpression() {
        return this.parameter;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.functionName != null && !this.functionName.accept(action)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.functionName) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.functionName = (IASTExpression)other;
        }
        if (child == this.parameter) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.parameter = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        IType type = this.getFunctionNameExpression().getExpressionType();
        try {
            while (type instanceof ITypeContainer) {
                type = ((ITypeContainer)type).getType();
            }
            if (type instanceof IFunctionType) {
                return ((IFunctionType)type).getReturnType();
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }
}

