/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICDescriptorManager;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.internal.core.CConfigBasedDescriptor;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.COwnerConfiguration;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.PathEntryConfigurationDataProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public final class CConfigBasedDescriptorManager
implements ICDescriptorManager {
    private static volatile CConfigBasedDescriptorManager fInstance;
    public static final String NULL_OWNER_ID = "";
    private static volatile Map<String, COwnerConfiguration> fOwnerConfigMap;
    private static volatile ICProjectDescriptionListener fDescriptionListener;
    private Collection<ICDescriptorListener> fListeners = new CopyOnWriteArraySet<ICDescriptorListener>();
    final ConcurrentHashMap<IProject, Reference<CConfigBasedDescriptor>> fProjectDescriptorMap = new ConcurrentHashMap();
    private static final COwnerConfiguration NULLCOwner;

    static {
        NULLCOwner = new COwnerConfiguration(NULL_OWNER_ID, CCorePlugin.getResourceString("CDescriptorManager.internal_owner"));
    }

    private CConfigBasedDescriptorManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CConfigBasedDescriptorManager getInstance() {
        if (fInstance != null) return fInstance;
        Class<CConfigBasedDescriptor> clazz = CConfigBasedDescriptor.class;
        synchronized (CConfigBasedDescriptor.class) {
            if (fInstance != null) return fInstance;
            fInstance = new CConfigBasedDescriptorManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fInstance;
        }
    }

    public void projectMove(IProject fromProject, IProject toProject) {
        Reference<CConfigBasedDescriptor> ref = this.fProjectDescriptorMap.get(fromProject);
        if (ref != null) {
            this.fProjectDescriptorMap.putIfAbsent(toProject, ref);
        }
        this.fProjectDescriptorMap.remove(fromProject);
    }

    public void projectClosedRemove(IProject project) {
        this.fProjectDescriptorMap.remove(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(IProject project, String id) throws CoreException {
        if (id.equals(NULLCOwner.getOwnerID())) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.invalid_ownerID"), null);
            throw new CoreException((IStatus)status);
        }
        CConfigBasedDescriptor dr = null;
        CConfigBasedDescriptorManager cConfigBasedDescriptorManager = this;
        synchronized (cConfigBasedDescriptorManager) {
            try {
                dr = this.findDescriptor(project, false);
                if (dr != null) {
                    dr.fLock.acquire();
                    if (!dr.getProjectOwner().getID().equals(NULLCOwner.getOwnerID())) {
                        if (dr.getProjectOwner().getID().equals(id)) return;
                        Status status = new Status(4, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptorManager.exception.alreadyConfigured"), null);
                        throw new CoreException((IStatus)status);
                    }
                    dr = this.updateDescriptor(project, dr, id);
                } else {
                    dr = this.findDescriptor(project, true);
                    dr.fLock.acquire();
                    dr = this.updateDescriptor(project, dr, id);
                }
                dr.apply(true);
                if (!dr.isOperationStarted()) return;
                dr.setOpEvent(new CDescriptorEvent(dr, 2, 0));
            }
            finally {
                if (dr != null) {
                    dr.fLock.release();
                }
            }
            return;
        }
    }

    private CConfigBasedDescriptor updateDescriptor(IProject project, CConfigBasedDescriptor dr, String ownerId) throws CoreException {
        try {
            dr.fLock.acquire();
            ICConfigurationDescription cfgDes = dr.getConfigurationDescription();
            CConfigurationSpecSettings settings = ((IInternalCCfgInfo)((Object)cfgDes)).getSpecSettings();
            settings.setCOwner(ownerId);
            COwner owner = settings.getCOwner();
            dr = this.findDescriptor(project, true);
            owner.configure(project, dr);
            CConfigBasedDescriptor cConfigBasedDescriptor = dr;
            return cConfigBasedDescriptor;
        }
        finally {
            dr.fLock.release();
        }
    }

    public void convert(IProject project, String id) throws CoreException {
        CConfigBasedDescriptor dr = this.findDescriptor(project, false);
        if (dr == null) {
            throw ExceptionFactory.createCoreException(CCorePlugin.getResourceString("CConfigBasedDescriptorManager.0"));
        }
        try {
            dr.fLock.acquire();
            dr = this.updateDescriptor(project, dr, id);
            dr.apply(true);
            if (dr.isOperationStarted()) {
                dr.setOpEvent(new CDescriptorEvent(dr, 1, 16));
            }
        }
        finally {
            dr.fLock.release();
        }
    }

    public ICDescriptor getDescriptor(IProject project) throws CoreException {
        return this.getDescriptor(project, true);
    }

    public ICDescriptor getDescriptor(IProject project, boolean create) throws CoreException {
        return this.findDescriptor(project, create);
    }

    public void addDescriptorListener(ICDescriptorListener listener) {
        this.fListeners.add(listener);
    }

    public void removeDescriptorListener(ICDescriptorListener listener) {
        this.fListeners.remove(listener);
    }

    public void runDescriptorOperation(IProject project, ICDescriptorOperation op, IProgressMonitor monitor) throws CoreException {
        CConfigBasedDescriptor dr = this.findDescriptor(project, true);
        if (dr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, "Failed to create descriptor", null));
        }
        try {
            dr.fLock.acquire();
            CDescriptorEvent event = null;
            try {
                dr.operationStart();
                op.execute(dr, monitor);
            }
            finally {
                event = dr.operationStop();
            }
            dr.apply(false);
            if (event != null) {
                CConfigBasedDescriptorManager.getInstance().notifyListeners(event);
            }
        }
        finally {
            dr.fLock.release();
        }
    }

    public void runDescriptorOperation(IProject project, ICProjectDescription des, ICDescriptorOperation op, IProgressMonitor monitor) throws CoreException {
        if (des.isReadOnly()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CConfigBasedDescriptorManager.2"), null));
        }
        CConfigBasedDescriptor dr = CConfigBasedDescriptorManager.loadDescriptor((CProjectDescription)des);
        if (dr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CConfigBasedDescriptorManager.3"), null));
        }
        op.execute(dr, monitor);
        CConfigBasedDescriptor.reconcile(dr, des);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CConfigBasedDescriptor findDescriptor(IProject project, boolean create) throws CoreException {
        CConfigBasedDescriptor dr = null;
        Reference ref = this.fProjectDescriptorMap.get(project);
        if (ref != null) {
            dr = ref.get();
        }
        if (dr != null) {
            return dr;
        }
        CProjectDescription des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(project, false);
        if (des == null && create) {
            des = CConfigBasedDescriptorManager.createProjDescriptionForDescriptor(project);
        }
        if (des != null) {
            dr = CConfigBasedDescriptorManager.loadDescriptor(des);
        }
        if ((ref = (Reference)this.fProjectDescriptorMap.putIfAbsent(project, new SoftReference<CConfigBasedDescriptor>(dr))) != null) {
            CConfigBasedDescriptor dr1 = (CConfigBasedDescriptor)ref.get();
            if (dr1 != null) {
                return dr1;
            }
            CConfigBasedDescriptorManager cConfigBasedDescriptorManager = this;
            synchronized (cConfigBasedDescriptorManager) {
                ref = this.fProjectDescriptorMap.putIfAbsent(project, new SoftReference<CConfigBasedDescriptor>(dr));
                if (ref != null && (dr1 = (CConfigBasedDescriptor)ref.get()) != null) {
                    return dr1;
                }
                this.fProjectDescriptorMap.put(project, new SoftReference<CConfigBasedDescriptor>(dr));
            }
        }
        return dr;
    }

    private static CProjectDescription createProjDescriptionForDescriptor(IProject project) throws CoreException {
        CProjectDescriptionManager mngr = CProjectDescriptionManager.getInstance();
        CProjectDescription des = (CProjectDescription)mngr.createProjectDescription(project, false, true);
        CConfigurationData data = mngr.createDefaultConfigData(project, PathEntryConfigurationDataProvider.getDataFactory());
        des.createConfiguration("org.eclipse.cdt.core.defaultConfigDataProvider", data);
        return des;
    }

    private static CConfigBasedDescriptor loadDescriptor(CProjectDescription des) throws CoreException {
        ICConfigurationDescription cfgDes;
        if (des == null) {
            throw ExceptionFactory.createCoreException("CProjectDescription des is null");
        }
        if (des.isReadOnly()) {
            des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(des.getProject(), true);
        }
        if ((cfgDes = des.getDefaultSettingConfiguration()) instanceof CConfigurationDescriptionCache) {
            des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(des.getProject(), true);
            cfgDes = des.getDefaultSettingConfiguration();
        }
        if (cfgDes != null) {
            if (cfgDes.isReadOnly()) {
                throw ExceptionFactory.createCoreException(CCorePlugin.getResourceString("CConfigBasedDescriptorManager.4"));
            }
            return new CConfigBasedDescriptor(cfgDes);
        }
        if (!des.isCdtProjectCreating()) {
            throw ExceptionFactory.createCoreException(CCorePlugin.getResourceString("CConfigBasedDescriptorManager.5"));
        }
        return null;
    }

    public static synchronized COwnerConfiguration getOwnerConfiguration(String id) {
        COwnerConfiguration config;
        if (id.equals(NULLCOwner.getOwnerID())) {
            return NULLCOwner;
        }
        if (fOwnerConfigMap == null) {
            CConfigBasedDescriptorManager.initializeOwnerConfiguration();
        }
        if ((config = fOwnerConfigMap.get(id)) == null) {
            config = new COwnerConfiguration(id, CCorePlugin.getResourceString("CDescriptorManager.owner_not_Installed"));
            fOwnerConfigMap.put(id, config);
        }
        return config;
    }

    private static void initializeOwnerConfiguration() {
        IExtensionPoint extpoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "CProject");
        IExtension[] extension = extpoint.getExtensions();
        fOwnerConfigMap = new HashMap<String, COwnerConfiguration>(extension.length);
        int i = 0;
        while (i < extension.length) {
            IConfigurationElement[] element = extension[i].getConfigurationElements();
            int j = 0;
            while (j < element.length) {
                if (element[j].getName().equalsIgnoreCase("cproject")) {
                    fOwnerConfigMap.put(extension[i].getUniqueIdentifier(), new COwnerConfiguration(element[j]));
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void startup() {
        if (fDescriptionListener != null) {
            return;
        }
        fDescriptionListener = new ICProjectDescriptionListener(){

            public void handleEvent(CProjectDescriptionEvent event) {
                CConfigBasedDescriptorManager.this.doHandleEvent(event);
            }
        };
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(fDescriptionListener, 23);
    }

    public void shutdown() {
        if (fDescriptionListener != null) {
            CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(fDescriptionListener);
        }
        fDescriptionListener = null;
    }

    private void doHandleEvent(CProjectDescriptionEvent event) {
        CConfigBasedDescriptor dr = null;
        Reference<CConfigBasedDescriptor> ref = this.fProjectDescriptorMap.get(event.getProject());
        if (ref != null) {
            dr = ref.get();
        }
        if (dr == null) {
            return;
        }
        try {
            dr.fLock.acquire();
            try {
                switch (event.getEventType()) {
                    case 1: {
                        ICConfigurationDescription cfgDescription;
                        CProjectDescription des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(event.getProject(), true);
                        if (des != null && (cfgDescription = des.getDefaultSettingConfiguration()) != null) {
                            dr.updateConfiguration(cfgDescription);
                            dr.setDirty(false);
                        }
                        break;
                    }
                    case 2: {
                        CProjectDescription des = (CProjectDescription)event.getNewCProjectDescription();
                        if (des != null && dr.getConfigurationDescription().getProjectDescription() != des) {
                            CConfigBasedDescriptor.reconcile(dr, des);
                        }
                        break;
                    }
                    case 16: {
                        CProjectDescription des = (CProjectDescription)event.getNewCProjectDescription();
                        if (des != null) {
                            CConfigBasedDescriptor.reconcile(dr, des);
                        }
                        break;
                    }
                    case 4: {
                        CProjectDescription newDes = (CProjectDescription)event.getNewCProjectDescription();
                        CProjectDescription oldDes = (CProjectDescription)event.getOldCProjectDescription();
                        CDescriptorEvent desEvent = null;
                        ICConfigurationDescription updatedCfg = null;
                        if (oldDes == null) {
                            updatedCfg = newDes.getDefaultSettingConfiguration();
                            desEvent = new CDescriptorEvent(dr, 2, 0);
                        } else if (newDes == null) {
                            desEvent = new CDescriptorEvent(dr, 3, 0);
                        } else {
                            updatedCfg = newDes.getDefaultSettingConfiguration();
                            ICConfigurationDescription newCfg = newDes.getDefaultSettingConfiguration();
                            ICConfigurationDescription oldCfg = oldDes.getDefaultSettingConfiguration();
                            int flags = 0;
                            if (oldCfg != null && newCfg != null) {
                                if (newCfg.getId().equals(oldCfg.getId())) {
                                    ICDescriptionDelta cfgDelta = this.findCfgDelta(event.getProjectDelta(), newCfg.getId());
                                    if (cfgDelta != null) {
                                        flags = cfgDelta.getChangeFlags() & 0x180000;
                                    }
                                } else {
                                    flags = CProjectDescriptionManager.getInstance().calculateDescriptorFlags(newCfg, oldCfg);
                                }
                            }
                            int drEventFlags = this.descriptionFlagsToDescriptorFlags(flags);
                            desEvent = new CDescriptorEvent(dr, 1, drEventFlags);
                        }
                        if (updatedCfg != null) {
                            CProjectDescription writableDes = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(event.getProject(), true);
                            ICConfigurationDescription indexCfg = writableDes.getDefaultSettingConfiguration();
                            dr.updateConfiguration(indexCfg);
                            dr.setDirty(false);
                        }
                        this.notifyListeners(desEvent);
                    }
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        finally {
            dr.fLock.release();
        }
    }

    private int descriptionFlagsToDescriptorFlags(int flags) {
        int result = 0;
        if ((flags & 0x80000) != 0) {
            result |= 0x20;
        }
        if ((flags & 0x100000) != 0) {
            result |= 0x10;
        }
        return result;
    }

    private ICDescriptionDelta findCfgDelta(ICDescriptionDelta delta, String id) {
        if (delta == null) {
            return null;
        }
        ICDescriptionDelta[] children = delta.getChildren();
        int i = 0;
        while (i < children.length) {
            ICSettingObject s = children[i].getNewSetting();
            if (s != null && id.equals(s.getId())) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    protected void notifyListeners(final CDescriptorEvent event) {
        for (final ICDescriptorListener listener : this.fListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.listenerError"), exception);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    listener.descriptorChanged(event);
                }
            });
        }
    }
}

