/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import java.io.File;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class AddLink
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        String fileSourcePath = args[1].getSimpleValue();
        String targetPath = args[2].getSimpleValue();
        File sourceFile = new File(fileSourcePath);
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            IFile file = projectHandle.getFile(targetPath);
            if (!file.getParent().exists()) {
                ProcessHelper.mkdirs(projectHandle, projectHandle.getFolder(file.getParent().getProjectRelativePath()));
            }
            file.createLink(Path.fromOSString((String)sourceFile.getAbsolutePath()), 144, null);
            file.refreshLocal(1, null);
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString("AddLink.0")) + e.getMessage(), e);
        }
    }
}

