/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.util.CharTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArraySet
extends CharTable {
    public static final CharArraySet EMPTY_SET = new CharArraySet(0){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public List<char[]> toList() {
            return Collections.emptyList();
        }

        @Override
        public void put(char[] key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(List<char[]> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(CharArraySet set) {
            throw new UnsupportedOperationException();
        }
    };

    public CharArraySet(int initialSize) {
        super(initialSize);
    }

    public void put(char[] key) {
        this.addIndex(key);
    }

    public void addAll(List<char[]> list) {
        if (list == null) {
            return;
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            this.addIndex(list.get(i));
            ++i;
        }
    }

    public void addAll(CharArraySet set) {
        if (set == null) {
            return;
        }
        int size = set.size();
        int i = 0;
        while (i < size) {
            this.addIndex(set.keyAt(i));
            ++i;
        }
    }

    public final boolean remove(char[] key) {
        int i = this.lookup(key);
        if (i < 0) {
            return false;
        }
        this.removeEntry(i);
        return true;
    }

    @Override
    public final void clear() {
        int i = 0;
        while (i < this.keyTable.length) {
            this.keyTable[i] = null;
            this.hashTable[2 * i] = 0;
            this.hashTable[2 * i + 1] = 0;
            this.nextTable[i] = 0;
            ++i;
        }
        this.currEntry = -1;
    }
}

