/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

public class CodeReader {
    public static final String SYSTEM_DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final int MB = 0x100000;
    private static final String NF = "<text>";
    private static final char[] NOFILE = "<text>".toCharArray();
    private static final int MAX_FILE_SIZE = (int)Math.min(Integer.MAX_VALUE, Runtime.getRuntime().maxMemory() / 4L);
    public final char[] buffer;
    public final char[] filename;

    public CodeReader(String filename, char[] buffer) {
        this.filename = filename.toCharArray();
        this.buffer = buffer;
    }

    public CodeReader(char[] buffer) {
        this(NF, buffer);
    }

    public CodeReader(String filename) throws IOException {
        this.filename = filename.toCharArray();
        FileInputStream stream = new FileInputStream(filename);
        try {
            this.buffer = this.load(SYSTEM_DEFAULT_ENCODING, stream);
        }
        finally {
            stream.close();
        }
    }

    public CodeReader(String filename, String charSet) throws IOException {
        this.filename = filename.toCharArray();
        FileInputStream stream = new FileInputStream(filename);
        try {
            this.buffer = this.load(charSet, stream);
        }
        finally {
            stream.close();
        }
    }

    public CodeReader(String filename, InputStream stream) throws IOException {
        this(filename, SYSTEM_DEFAULT_ENCODING, stream);
    }

    public CodeReader(String fileName, String charSet, InputStream stream) throws IOException {
        this.filename = fileName.toCharArray();
        FileInputStream fstream = stream instanceof FileInputStream ? (FileInputStream)stream : new FileInputStream(fileName);
        try {
            this.buffer = this.load(charSet, fstream);
        }
        finally {
            if (!(stream instanceof FileInputStream)) {
                fstream.close();
            }
        }
    }

    private char[] load(String charSet, FileInputStream stream) throws IOException {
        char[] buff;
        String encoding = Charset.isSupported(charSet) ? charSet : SYSTEM_DEFAULT_ENCODING;
        FileChannel channel = stream.getChannel();
        long lsize = channel.size();
        int isize = (int)lsize;
        if (lsize > (long)MAX_FILE_SIZE) {
            throw new IOException("File '" + this.getPath() + "' is larger than " + MAX_FILE_SIZE / 1024 / 1024 + "mb");
        }
        CharBuffer charBuffer = isize < 0x100000 ? this.decodeSmallFile(channel, isize, encoding) : this.decodeLargeFile(channel, isize, encoding);
        if (charBuffer.hasArray() && charBuffer.arrayOffset() == 0 && (buff = charBuffer.array()).length == charBuffer.remaining()) {
            return buff;
        }
        buff = new char[charBuffer.remaining()];
        charBuffer.get(buff);
        return buff;
    }

    private CharBuffer decodeSmallFile(FileChannel channel, int isize, String encoding) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(isize);
        channel.read(byteBuffer);
        byteBuffer.flip();
        return Charset.forName(encoding).decode(byteBuffer);
    }

    private CharBuffer decodeLargeFile(FileChannel channel, int isize, String encoding) throws IOException {
        int chunk = Math.min(isize, 0x100000);
        ByteBuffer in = ByteBuffer.allocate(chunk);
        Charset charset = Charset.forName(encoding);
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int n = (int)((double)isize * (double)decoder.averageCharsPerByte());
        CharBuffer out = CharBuffer.allocate(n);
        int offset = 0;
        while (offset < isize) {
            channel.read(in);
            in.flip();
            CoderResult cr = decoder.decode(in, out, (offset += in.limit()) >= isize);
            int remainingBytes = in.remaining();
            if (cr.isOverflow()) {
                int totalRemainingBytes = isize - offset + remainingBytes;
                if (totalRemainingBytes > 0) {
                    CharBuffer o = CharBuffer.allocate(n += (int)((double)totalRemainingBytes * (double)decoder.maxCharsPerByte()));
                    out.flip();
                    o.put(out);
                    out = o;
                }
            } else if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (remainingBytes == 0) {
                in.clear();
                continue;
            }
            byte[] rest = new byte[remainingBytes];
            in.get(rest);
            in.clear();
            in.put(rest);
            offset -= remainingBytes;
        }
        out.flip();
        return out;
    }

    public boolean isFile() {
        return !CharArrayUtils.equals(this.filename, NOFILE);
    }

    public String toString() {
        return this.getPath();
    }

    public String getPath() {
        return new String(this.filename);
    }
}

