/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.settings.model.MultiItemsHolder;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiResourceInfo;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractToolSettingUI;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.StringFieldEditorM;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class BuildOptionSettingsUI
extends AbstractToolSettingUI {
    private Map<String, FieldEditor> fieldsMap = new HashMap<String, FieldEditor>();
    private IOptionCategory category;
    private IHoldsOptions optionHolder;
    private IHoldsOptions[] ohs;
    private int curr = -1;
    private Map<FieldEditor, Composite> fieldEditorsToParentMap = new HashMap<FieldEditor, Composite>();

    public BuildOptionSettingsUI(AbstractCBuildPropertyTab page, IResourceInfo info, IHoldsOptions optionHolder, IOptionCategory _category) {
        super(info);
        this.category = _category;
        this.optionHolder = optionHolder;
        this.buildPropPage = page;
        if (info instanceof MultiItemsHolder) {
            MultiResourceInfo mri = (MultiResourceInfo)info;
            IResourceInfo[] ris = (IResourceInfo[])mri.getItems();
            String id = this.category.getId();
            ArrayList<Object> lst = new ArrayList<Object>();
            if (optionHolder instanceof ITool) {
                String ext = ((ITool)optionHolder).getDefaultInputExtension();
                int i = 0;
                while (i < ris.length) {
                    ITool[] ts = ris[i].getTools();
                    int j = 0;
                    while (j < ts.length) {
                        IOptionCategory op = ts[j].getOptionCategory(id);
                        if (op != null && ext.equals(ts[j].getDefaultInputExtension())) {
                            lst.add(ts[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (optionHolder instanceof IToolChain) {
                int i = 0;
                while (i < ris.length) {
                    IToolChain tc = ris[i].getParent().getToolChain();
                    IOptionCategory op = tc.getOptionCategory(id);
                    if (op != null) {
                        lst.add(tc);
                    }
                    ++i;
                }
            }
            this.ohs = lst.toArray(new IHoldsOptions[lst.size()]);
            int i = 0;
            while (i < this.ohs.length) {
                if (this.ohs[i].equals(optionHolder)) {
                    this.curr = i;
                    break;
                }
                ++i;
            }
        } else {
            this.ohs = null;
            this.curr = 0;
        }
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String optId = this.getToolSettingsPrefStore().getOptionId(opt);
            IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
            IResourceInfo config = this.fInfo;
            if (applicabilityCalculator == null || applicabilityCalculator.isOptionVisible((IBuildObject)config, holder, opt)) {
                try {
                    Object fieldEditor;
                    Composite fieldEditorParent = this.getFieldEditorParent();
                    switch (opt.getValueType()) {
                        case 2: {
                            Object stringField;
                            switch (opt.getBrowseType()) {
                                case 2: {
                                    stringField = new DirectoryFieldEditor(optId, TextProcessor.process((String)opt.getName()), fieldEditorParent);
                                    break;
                                }
                                case 1: {
                                    stringField = new FileFieldEditor(optId, TextProcessor.process((String)opt.getName()), fieldEditorParent);
                                    break;
                                }
                                case 0: {
                                    final StringFieldEditorM local = new StringFieldEditorM(optId, TextProcessor.process((String)opt.getName()), fieldEditorParent);
                                    stringField = local;
                                    local.getTextControl().addModifyListener(new ModifyListener(){

                                        public void modifyText(ModifyEvent e) {
                                            local.valueChanged();
                                        }
                                    });
                                    break;
                                }
                                default: {
                                    throw new BuildException(null);
                                }
                            }
                            stringField.getTextControl(fieldEditorParent).setToolTipText(TextProcessor.process((String)opt.getToolTip()));
                            stringField.getLabelControl(fieldEditorParent).setToolTipText(TextProcessor.process((String)opt.getToolTip()));
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)stringField.getTextControl(fieldEditorParent), opt.getContextId());
                            fieldEditor = stringField;
                            break;
                        }
                        case 0: {
                            fieldEditor = new TriStateBooleanFieldEditor(optId, TextProcessor.process((String)opt.getName()), opt.getToolTip(), fieldEditorParent, opt.getContextId(), this.ohs, this.curr);
                            break;
                        }
                        case 1: {
                            String selId = opt.getSelectedEnum();
                            String sel = opt.getEnumName(selId);
                            String[] enumNames = opt.getApplicableValues();
                            Vector<String> enumValidList = new Vector<String>();
                            int i = 0;
                            while (i < enumNames.length) {
                                if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                                    enumValidList.add(enumNames[i]);
                                }
                                ++i;
                            }
                            Object[] enumValidNames = new String[enumValidList.size()];
                            enumValidList.copyInto(enumValidNames);
                            fieldEditor = new BuildOptionComboFieldEditor(optId, TextProcessor.process((String)opt.getName()), TextProcessor.process((String)opt.getToolTip()), opt.getContextId(), (String[])enumValidNames, sel, fieldEditorParent);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            fieldEditor = new FileListControlFieldEditor(optId, TextProcessor.process((String)opt.getName()), TextProcessor.process((String)opt.getToolTip()), opt.getContextId(), fieldEditorParent, opt.getBrowseType());
                            break;
                        }
                        default: {
                            throw new BuildException(null);
                        }
                    }
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)fieldEditor, fieldEditorParent);
                    this.addField((FieldEditor)fieldEditor);
                    this.fieldsMap.put(optId, (FieldEditor)fieldEditor);
                    this.fieldEditorsToParentMap.put((FieldEditor)fieldEditor, fieldEditorParent);
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
    }

    public boolean isFor(Object holder, Object cat) {
        return holder instanceof IHoldsOptions && cat != null && cat instanceof IOptionCategory && this.optionHolder == this.optionHolder && cat.equals(this.category);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IConfiguration realCfg = null;
        IConfiguration handler = null;
        realCfg = this.buildPropPage.getCfg();
        if (realCfg == null) {
            return false;
        }
        handler = realCfg;
        Object[][] clonedOptions = this.category.getOptions(this.fInfo, this.optionHolder);
        int i = 0;
        while (i < clonedOptions.length) {
            IOption realOption;
            IHoldsOptions clonedHolder = (IHoldsOptions)clonedOptions[i][0];
            if (clonedHolder == null) break;
            IOption clonedOption = (IOption)clonedOptions[i][1];
            IHoldsOptions realHolder = clonedHolder;
            if (realHolder != null && (realOption = clonedOption) != null) {
                try {
                    IOption setOption = null;
                    switch (clonedOption.getValueType()) {
                        case 0: {
                            boolean boolVal = clonedOption.getBooleanValue();
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                            break;
                        }
                        case 1: {
                            String enumVal = clonedOption.getStringValue();
                            String enumId = clonedOption.getEnumeratedId(enumVal);
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                            break;
                        }
                        case 2: {
                            String strVal = clonedOption.getStringValue();
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            String[] listVal = ((List)clonedOption.getValue()).toArray(new String[0]);
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                            break;
                        }
                    }
                    if (setOption == null) {
                        setOption = realOption;
                    }
                    setOption.getValueHandler().handleValue((IBuildObject)handler, setOption.getOptionHolder(), setOption, setOption.getValueHandlerExtraArgument(), 4);
                }
                catch (BuildException buildException) {
                }
                catch (ClassCastException classCastException) {}
            }
            ++i;
        }
        return ok;
    }

    public void updateFields() {
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPrefStore().getOptionId(opt);
            if (this.fieldsMap.containsKey(prefName)) {
                IOptionApplicability applicabilityCalculator;
                FieldEditor fieldEditor = this.fieldsMap.get(prefName);
                try {
                    if (opt.getValueType() == 1) {
                        this.updateEnumList(fieldEditor, opt, holder, this.fInfo);
                    }
                }
                catch (BuildException buildException) {}
                if ((applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                    Composite parent = this.fieldEditorsToParentMap.get(fieldEditor);
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
                }
            }
            ++index;
        }
        Collection<FieldEditor> fieldsList = this.fieldsMap.values();
        for (FieldEditor editor : fieldsList) {
            if (editor instanceof TriStateBooleanFieldEditor) {
                ((TriStateBooleanFieldEditor)editor).set3(true);
            }
            editor.load();
        }
    }

    private void setFieldEditorEnablement(IHoldsOptions holder, IOption option, IOptionApplicability optionApplicability, FieldEditor fieldEditor, Composite parent) {
        if (optionApplicability == null) {
            return;
        }
        IResourceInfo config = this.fInfo;
        if (!optionApplicability.isOptionEnabled((IBuildObject)config, holder, option)) {
            fieldEditor.setEnabled(false, parent);
        } else {
            fieldEditor.setEnabled(true, parent);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        IOption changedOption = null;
        IHoldsOptions changedHolder = null;
        String id = null;
        if (source instanceof FieldEditor) {
            int n;
            FieldEditor fe = (FieldEditor)source;
            if (fe instanceof TriStateBooleanFieldEditor) {
                ((TriStateBooleanFieldEditor)fe).set3(false);
            }
            id = fe.getPreferenceName();
            Object[] option = this.getToolSettingsPrefStore().getOption(id);
            if (option == null && (n = id.lastIndexOf(46)) > 0) {
                id = id.substring(0, n);
                option = this.getToolSettingsPrefStore().getOption(id);
            }
            if (option != null) {
                changedOption = (IOption)option[1];
                changedHolder = (IHoldsOptions)option[0];
                try {
                    switch (changedOption.getValueType()) {
                        case 2: {
                            if (fe instanceof StringFieldEditor) {
                                String val = ((StringFieldEditor)fe).getStringValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)val);
                            }
                            break;
                        }
                        case 0: {
                            if (fe instanceof BooleanFieldEditor) {
                                boolean val = ((BooleanFieldEditor)fe).getBooleanValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (boolean)val);
                            }
                            break;
                        }
                        case 1: {
                            if (fe instanceof BuildOptionComboFieldEditor) {
                                String name = ((BuildOptionComboFieldEditor)fe).getSelection();
                                String enumId = changedOption.getEnumeratedId(name);
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)(enumId != null && enumId.length() > 0 ? enumId : name));
                            }
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            if (fe instanceof FileListControlFieldEditor) {
                                String[] val = ((FileListControlFieldEditor)fe).getStringListValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String[])val);
                            }
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String optId = this.getToolSettingsPrefStore().getOptionId(opt);
            if (this.fieldsMap.containsKey(optId)) {
                IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
                FieldEditor fieldEditor = this.fieldsMap.get(optId);
                try {
                    if (opt.getValueType() == 1) {
                        this.updateEnumList(fieldEditor, opt, holder, this.fInfo);
                    }
                }
                catch (BuildException buildException) {}
                if (applicabilityCalculator != null) {
                    Composite parent = this.fieldEditorsToParentMap.get(fieldEditor);
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
                }
            }
            ++index;
        }
        for (FieldEditor editor : this.fieldsMap.values()) {
            if (id != null && id.equals(editor.getPreferenceName())) continue;
            editor.load();
        }
    }

    public void setValues() {
        this.updateFields();
    }

    protected void updateEnumList(FieldEditor fieldEditor, IOption opt, IHoldsOptions holder, IResourceInfo config) throws BuildException {
        String[] enumNames = opt.getApplicableValues();
        String selectedEnum = opt.getSelectedEnum();
        String selectedEnumName = opt.getEnumName(selectedEnum);
        String defaultEnumId = (String)opt.getDefaultValue();
        String defaultEnumName = opt.getEnumName(defaultEnumId);
        boolean selectNewEnum = true;
        boolean selectDefault = false;
        Vector<String> enumValidList = new Vector<String>();
        int i = 0;
        while (i < enumNames.length) {
            if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                if (selectedEnumName.equals(enumNames[i])) {
                    selectNewEnum = false;
                }
                if (defaultEnumName.equals(enumNames[i])) {
                    selectDefault = true;
                }
                enumValidList.add(enumNames[i]);
            }
            ++i;
        }
        Object[] enumValidNames = new String[enumValidList.size()];
        enumValidList.copyInto(enumValidNames);
        if (selectNewEnum) {
            String selection = null;
            if (selectDefault) {
                selection = (String)opt.getDefaultValue();
            } else if (enumValidNames.length > 0) {
                selection = opt.getEnumeratedId((String)enumValidNames[0]);
            }
            ManagedBuildManager.setOption((IResourceInfo)config, (IHoldsOptions)holder, (IOption)opt, (String)selection);
        }
        ((BuildOptionComboFieldEditor)fieldEditor).setOptions((String[])enumValidNames);
        fieldEditor.load();
    }

    class TriStateBooleanFieldEditor
    extends BooleanFieldEditor {
        protected Button button;
        protected IHoldsOptions[] holders;
        private boolean enable3;
        protected int current;

        public TriStateBooleanFieldEditor(String name, String labelText, String tooltip, Composite parent, String contextId, IHoldsOptions[] ho, int curr) {
            super(name, labelText, parent);
            this.button = null;
            this.holders = null;
            this.enable3 = true;
            this.current = 0;
            this.holders = ho;
            this.current = curr;
            this.button = this.getChangeControl(parent);
            this.button.setToolTipText(tooltip);
            if (!contextId.equals("")) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.button, contextId);
            }
        }

        protected void valueChanged(boolean oldValue, boolean newValue) {
            AbstractCPropertyTab.setGrayed((Button)this.button, (boolean)false);
            super.valueChanged(!newValue, newValue);
        }

        protected void doLoad() {
            String id;
            IOption op;
            if (this.enable3 && this.holders != null && this.button != null && (op = this.holders[this.current].getOptionById(id = this.getPreferenceName())) != null) {
                if (op.getSuperClass() != null) {
                    id = op.getSuperClass().getId();
                }
                int[] vals = new int[2];
                int i = 0;
                while (i < this.holders.length) {
                    op = this.holders[i].getOptionBySuperClassId(id);
                    try {
                        if (op != null) {
                            int n = op.getBooleanValue() ? 1 : 0;
                            vals[n] = vals[n] + 1;
                        }
                    }
                    catch (BuildException buildException) {}
                    ++i;
                }
                boolean value = false;
                boolean gray = false;
                if (vals[1] > 0) {
                    value = true;
                    if (vals[0] > 0) {
                        gray = true;
                    }
                }
                AbstractCPropertyTab.setGrayed((Button)this.button, (boolean)gray);
                this.button.setSelection(value);
                return;
            }
            super.doLoad();
        }

        void set3(boolean state) {
            this.enable3 = state;
        }
    }
}

