/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.WikiTextContextStructureBridge;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.WikiTextTasksUiPlugin;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTextContextUiBridge
extends AbstractContextUiBridge {
    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart.getAdapter(OutlineItem.class) != null;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editorPart) {
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        if (this.acceptsEditor(editorPart)) {
            try {
                IContentOutlinePage outlinePage = (IContentOutlinePage)editorPart.getAdapter(IContentOutlinePage.class);
                if (outlinePage != null) {
                    Method method = ContentOutlinePage.class.getDeclaredMethod("getTreeViewer", new Class[0]);
                    method.setAccessible(true);
                    viewers.add((TreeViewer)method.invoke((Object)outlinePage, new Object[0]));
                }
            }
            catch (Exception exception) {}
        }
        return viewers;
    }

    public String getContentType() {
        return "org.eclipse.mylyn.wikitext";
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        OutlineItem outline = (OutlineItem)editor.getAdapter(OutlineItem.class);
        if (outline != null && selection != null) {
            return outline.findNearestMatchingOffset(selection.getOffset());
        }
        return outline;
    }

    public IInteractionElement getElement(IEditorInput input) {
        Object adapter = input.getAdapter(OutlineItem.class);
        if (adapter != null) {
            String handle = ContextCore.getStructureBridge((Object)adapter).getHandleIdentifier(adapter);
            return ContextCore.getContextManager().getElement(handle);
        }
        return null;
    }

    public void open(IInteractionElement element) {
        AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge((String)"org.eclipse.mylyn.wikitext");
        if (structureBridge instanceof WikiTextContextStructureBridge) {
            Object object = structureBridge.getObjectForHandle(element.getHandleIdentifier());
            OutlineItem item = null;
            if (object instanceof OutlineItem) {
                item = (OutlineItem)object;
                object = ((WikiTextContextStructureBridge)structureBridge).getFile(item);
            }
            if (object instanceof IFile) {
                FileEditorInput editorInput = new FileEditorInput((IFile)object);
                try {
                    IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.eclipse.mylyn.wikitext.ui.editor.markupEditor");
                    if (item != null && editor instanceof IShowInTarget) {
                        ((IShowInTarget)editor).show(new ShowInContext((Object)editorInput, (ISelection)new StructuredSelection((Object)item)));
                    }
                }
                catch (PartInitException e) {
                    WikiTextTasksUiPlugin.getDefault().log(e);
                }
            }
        }
    }

    public void close(IInteractionElement element) {
        block7: {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) break block7;
                ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>(4);
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    try {
                        IFileEditorInput input;
                        if (reference.getEditorInput() instanceof IFileEditorInput && (input = (IFileEditorInput)reference.getEditorInput()).getFile().getFullPath().toString().equals(element.getHandleIdentifier())) {
                            editors.add(reference);
                        }
                    }
                    catch (PartInitException partInitException) {}
                    ++n2;
                }
                if (!editors.isEmpty()) {
                    page.closeEditors(editors.toArray(new IEditorReference[editors.size()]), true);
                }
            }
            catch (Throwable t) {
                WikiTextTasksUiPlugin.getDefault().log(t);
            }
        }
    }
}

