/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.commands;

import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.actions.MessagesForVMActions;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RetargetDebugContextCommand
extends AbstractHandler
implements IDebugContextListener {
    private ISelection fDebugContext;
    private Object fTargetAdapter = null;
    private IDebugContextService fContextService = null;
    private String fCommandId = null;

    protected Object getTargetAdapter() {
        return this.fTargetAdapter;
    }

    protected ISelection getDebugContext() {
        return this.fDebugContext;
    }

    public RetargetDebugContextCommand() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.fContextService = DebugUITools.getDebugContextManager().getContextService(window);
        this.fContextService.addPostDebugContextListener((IDebugContextListener)this);
        this.fDebugContext = this.fContextService.getActiveContext();
        this.update();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fCommandId = event.getCommand().getId();
        if (this.fTargetAdapter != null) {
            try {
                this.performCommand(this.fTargetAdapter, this.fDebugContext);
            }
            catch (ExecutionException executionException) {
                Shell shell = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getShell();
                ErrorDialog.openError((Shell)shell, (String)MessagesForVMActions.RetargetDebugContextAction_ErrorDialog_title, (String)MessagesForVMActions.RetargetDebugContextAction_ErrorDialog_message, null);
            }
        }
        this.update();
        return null;
    }

    protected abstract boolean canPerformCommand(Object var1, ISelection var2);

    protected abstract void performCommand(Object var1, ISelection var2) throws ExecutionException;

    protected abstract Class<?> getAdapterClass();

    public void update() {
        ICommandService commandService;
        Object object;
        IStructuredSelection ss;
        boolean enabled = false;
        this.fTargetAdapter = null;
        if (this.fDebugContext instanceof IStructuredSelection && !(ss = (IStructuredSelection)this.fDebugContext).isEmpty() && (object = ss.getFirstElement()) instanceof IAdaptable) {
            this.fTargetAdapter = this.getAdapter((IAdaptable)object);
            if (this.fTargetAdapter != null) {
                enabled = this.canPerformCommand(this.fTargetAdapter, this.fDebugContext);
            }
        }
        this.setBaseEnabled(enabled);
        if (this.fCommandId != null && (commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)) != null) {
            commandService.refreshElements(this.fCommandId, null);
        }
    }

    public void dispose() {
        this.fContextService.removePostDebugContextListener((IDebugContextListener)this);
        this.fTargetAdapter = null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.fDebugContext = event.getContext();
        this.update();
    }

    protected Object getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        Object adapter = adaptable.getAdapter(this.getAdapterClass());
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, this.getAdapterClass().getName())) {
            adapter = adapterManager.loadAdapter((Object)adaptable, this.getAdapterClass().getName());
        }
        return adapter;
    }
}

