/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class GdbRunToLine
implements IRunToLine {
    private final IRunControl.IExecutionDMContext fContext;

    public GdbRunToLine(IRunControl.IExecutionDMContext context) {
        this.fContext = context;
    }

    public boolean canRunToLine(IFile file, int lineNumber) {
        return this.canRunToLine();
    }

    public boolean canRunToLine(String fileName, int lineNumber) {
        return this.canRunToLine();
    }

    private boolean canRunToLine() {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            try {
                Query<Boolean> query = new Query<Boolean>(){

                    protected void execute(DataRequestMonitor<Boolean> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), GdbRunToLine.this.fContext.getSessionId());
                        IRunControl runControl = (IRunControl)tracker.getService(IRunControl.class);
                        if (runControl != null) {
                            runControl.canResume(GdbRunToLine.this.fContext, rm);
                        } else {
                            rm.setData((Object)false);
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                return (Boolean)query.get();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {}
        }
        return false;
    }

    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        this.runToLine(file.getLocation().makeAbsolute().toOSString(), lineNumber, skipBreakpoints);
    }

    public void runToLine(final String fileName, final int lineNumber, final boolean skipBreakpoints) throws DebugException {
        DsfSession session = DsfSession.getSession((String)this.fContext.getSessionId());
        if (session != null && session.isActive()) {
            Exception exception = null;
            try {
                Query<Object> query = new Query<Object>(){

                    protected void execute(final DataRequestMonitor<Object> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), GdbRunToLine.this.fContext.getSessionId());
                        IMIRunControl miRunControl = (IMIRunControl)tracker.getService(IMIRunControl.class);
                        if (miRunControl != null) {
                            miRunControl.runToLine(GdbRunToLine.this.fContext, fileName, Integer.toString(lineNumber), skipBreakpoints, (DataRequestMonitor)new DataRequestMonitor<MIInfo>(ImmediateExecutor.getInstance(), rm){

                                protected void handleSuccess() {
                                    rm.setData(new Object());
                                    rm.done();
                                }
                            });
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10003, "MIRunControl service not available", null));
                            rm.done();
                        }
                        tracker.dispose();
                    }
                };
                session.getExecutor().execute((Runnable)query);
                query.get();
            }
            catch (RejectedExecutionException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e;
            }
            if (exception != null) {
                new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 5012, "Faild executing run to line", (Throwable)exception));
            }
        } else {
            new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 5012, "Debug session is not active", null));
        }
    }
}

