/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder;

import com.atmel.avr32.managedbuilder.WindowsBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;

public class WindowsConfigurationEnvironmentSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static final String GCC_EXEC_PREFIX = "GCC_EXEC_PREFIX";
    private static final String WINDOWS = "windows ";
    static final String PATH_VARNAME = "PATH";
    static final String DELIMITER_UNIX = ":";
    static final String PROPERTY_DELIMITER = "path.separator";
    static final String PROPERTY_OSNAME = "os.name";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        String p;
        if (!System.getProperty(PROPERTY_OSNAME).toLowerCase().startsWith(WINDOWS)) {
            return null;
        }
        if (variableName == null) {
            return null;
        }
        if (variableName.equalsIgnoreCase(GCC_EXEC_PREFIX)) {
            return new BuildEnvVar(GCC_EXEC_PREFIX, null, 2, null);
        }
        if (variableName.equalsIgnoreCase(PATH_VARNAME) && (p = WindowsBuildPathResolver.getBinPath()) != null) {
            return new BuildEnvVar(PATH_VARNAME, p.replace('/', '\\'), 3, System.getProperty(PROPERTY_DELIMITER, DELIMITER_UNIX));
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] tmp = new IBuildEnvironmentVariable[]{this.getVariable(PATH_VARNAME, configuration, provider), this.getVariable(GCC_EXEC_PREFIX, configuration, provider)};
        if (tmp[0] != null) {
            return tmp;
        }
        return null;
    }
}

