/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;

public class WindowsBuildPathResolver
implements IBuildPathResolver {
    static final String AVR32_HOME = "AVR32_HOME";
    private static final String USR_LOCAL_BIN = "/usr/local/bin";
    private static final String PATH = "PATH";
    static final String TOOL = "/cygpath -w -p ";
    static final char BS = '\\';
    static final char SLASH = '/';
    static final String PROPERTY_OS_NAME = "os.name";
    static final String PROPERTY_OS_VALUE = "windows";
    static final String ARG0 = "regedit";
    static final String ARG1 = "/ea";
    static final String OUTFILE = "result.txt";
    static final String SP = " ";
    static final String QUOT = "\"";
    static final String REGISTRY_KEY = "\\SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2";
    static final String[] REGISTRY_ROOTS = new String[]{"\"HKEY_CURRENT_USER", "\"HKEY_LOCAL_MACHINE"};
    static final String[] REGISTRY_BINS = new String[]{"/usr/bin", "/usr/local/bin"};
    static final String CYGPREF_NAME = "cygdrive prefix";
    static final String PATH_NAME = "native";
    static final String REG_SZ = "REG_SZ";
    static final String BINPATTERN = "/usr/bin";
    static final String ETCPATTERN = "/etc";
    static final String ROOTPATTERN = "/";
    static final String DELIMITER_UNIX = ":";
    static final String DELIMITER_WIN = ";";
    static final String GCC_VERSION_CMD = "avr32-gcc --version";
    static final String MINGW_SPECIAL = "mingw";
    static final String CYGWIN_SPECIAL = "cygwin ";
    static boolean hasCheckedRegistry = false;
    static String binCygwin = null;
    static String rootCygwin = null;
    static String etcCygwin = null;
    private static ToolchainEnvironment detectedEnvironment = ToolchainEnvironment.UNDEFINED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ToolchainEnvironment getEnvironment() {
        ToolchainEnvironment toolchainEnvironment = detectedEnvironment;
        synchronized (toolchainEnvironment) {
            if (detectedEnvironment.equals((Object)ToolchainEnvironment.UNDEFINED)) {
                detectedEnvironment = WindowsBuildPathResolver.isWindows() ? (WindowsBuildPathResolver.testIsMinGW() ? ToolchainEnvironment.MINGW : ToolchainEnvironment.CYGWIN) : ToolchainEnvironment.LINUX;
            }
            return detectedEnvironment;
        }
    }

    public String[] resolveBuildPaths(int pathType, String variableName, String variableValue, IConfiguration configuration) {
        switch (WindowsBuildPathResolver.getEnvironment()) {
            case LINUX: {
                return variableValue.split(DELIMITER_UNIX);
            }
            case MINGW: {
                return variableValue.split(DELIMITER_WIN);
            }
            case CYGWIN: {
                String[] result = variableValue.split(DELIMITER_UNIX);
                String exePath = WindowsBuildPathResolver.getBinPath();
                if (exePath == null) {
                    return result;
                }
                File file = new File(exePath);
                if (!file.exists() || !file.isDirectory()) {
                    return result;
                }
                String s = String.valueOf(exePath) + TOOL + variableValue;
                String[] lines = WindowsBuildPathResolver.exec(s, configuration);
                if (lines != null && lines.length > 0) {
                    result = lines[0].replace('\\', '/').split(DELIMITER_WIN);
                }
                return result;
            }
        }
        return new String[0];
    }

    public static String getEtcPath() {
        if (!hasCheckedRegistry) {
            WindowsBuildPathResolver.checkRegistry();
        }
        return etcCygwin;
    }

    public static String getBinPath() {
        switch (WindowsBuildPathResolver.getEnvironment()) {
            case LINUX: {
                return System.getenv(PATH);
            }
            case MINGW: {
                return String.valueOf(System.getenv(AVR32_HOME)) + "\\bin" + DELIMITER_WIN + System.getenv(PATH);
            }
            case CYGWIN: {
                if (!hasCheckedRegistry) {
                    WindowsBuildPathResolver.checkRegistry();
                }
                if (binCygwin == null) break;
                return String.valueOf(binCygwin) + DELIMITER_WIN + rootCygwin + USR_LOCAL_BIN;
            }
        }
        return null;
    }

    public static String getPath(String executable) {
        String path = WindowsBuildPathResolver.getBinPath();
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            File f = new File(String.valueOf(segment) + File.separator + executable + (WindowsBuildPathResolver.isWindows() ? ".exe" : ""));
            if (f.exists()) {
                return f.getAbsolutePath().toString();
            }
            ++n2;
        }
        return executable;
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE);
    }

    private static synchronized void checkRegistry() {
        try {
            etcCygwin = null;
            binCygwin = null;
            rootCygwin = null;
            if (!WindowsBuildPathResolver.isWindows()) {
                return;
            }
            int i = 0;
            while (i < REGISTRY_ROOTS.length) {
                IPath toSave = ManagedbuildPlugin.getDefault().getStateLocation();
                toSave = toSave.addTrailingSeparator().append(OUTFILE);
                String[] args = new String[]{ARG0, ARG1, toSave.toOSString(), String.valueOf(REGISTRY_ROOTS[i]) + REGISTRY_KEY + QUOT};
                try {
                    File f = new File(toSave.toOSString());
                    f.delete();
                    if (ProcessFactory.getFactory().exec(args).waitFor() == 0 && f.exists() && f.canRead()) {
                        String s;
                        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                        ArrayList<String> ls = new ArrayList<String>(1);
                        while ((s = r.readLine()) != null) {
                            ls.add(s);
                        }
                        r.close();
                        f.delete();
                        String[] aus = ls.toArray(new String[0]);
                        if (etcCygwin == null) {
                            etcCygwin = WindowsBuildPathResolver.getDir(aus, ETCPATTERN);
                        }
                        if (binCygwin == null) {
                            binCygwin = WindowsBuildPathResolver.getDir(aus, BINPATTERN);
                        }
                        if (rootCygwin == null) {
                            rootCygwin = WindowsBuildPathResolver.getDir(aus, ROOTPATTERN);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (SecurityException securityException) {}
                ++i;
            }
        }
        finally {
            hasCheckedRegistry = true;
        }
    }

    private static String getDir(String[] ls, String pattern) {
        String tail = "";
        while (pattern.length() > 0) {
            int pos;
            boolean search = false;
            int i = 0;
            while (i < ls.length) {
                int pos2 = 0;
                if (ls[i].lastIndexOf(REGISTRY_KEY) > 0) {
                    search = ls[i].endsWith(String.valueOf(pattern) + "]");
                } else if (search && (pos2 = ls[i].lastIndexOf(PATH_NAME)) > 0) {
                    String s = ls[i].substring(pos2 + PATH_NAME.length() + 3).trim();
                    s = String.valueOf(s.substring(0, s.length() - 1)) + tail;
                    return s.replaceAll("\\\\+", ROOTPATTERN);
                }
                ++i;
            }
            if (pattern.equals(ROOTPATTERN) || (pos = pattern.lastIndexOf(47)) < 0) break;
            tail = String.valueOf(pattern.substring(pos, pattern.length())) + tail;
            pattern = pos == 0 ? ROOTPATTERN : pattern.substring(0, pos);
        }
        return null;
    }

    private static String[] exec(String cmd, IConfiguration cfg) {
        try {
            IEnvironmentVariable[] vars = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
            String[] env = new String[vars.length];
            int i = 0;
            while (i < env.length) {
                env[i] = String.valueOf(vars[i].getName()) + "=";
                String value = vars[i].getValue();
                if (value != null) {
                    int n = i;
                    env[n] = String.valueOf(env[n]) + value;
                }
                ++i;
            }
            Process proc = ProcessFactory.getFactory().exec(cmd.split(SP), env);
            if (proc != null) {
                String s;
                InputStream ein = proc.getInputStream();
                BufferedReader d1 = new BufferedReader(new InputStreamReader(ein));
                ArrayList<String> ls = new ArrayList<String>(10);
                while ((s = d1.readLine()) != null) {
                    ls.add(s);
                }
                ein.close();
                return ls.toArray(new String[0]);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static boolean testIsMinGW() {
        String path = System.getenv(PATH);
        if (System.getenv(AVR32_HOME) != null) {
            path = String.valueOf(System.getenv(AVR32_HOME)) + "\\bin;" + System.getenv(AVR32_HOME) + "\\usr\\local\\bin";
        } else {
            if (!hasCheckedRegistry) {
                WindowsBuildPathResolver.checkRegistry();
            }
            path = String.valueOf(binCygwin) + DELIMITER_WIN + rootCygwin + USR_LOCAL_BIN;
        }
        ArrayList<String> envp = new ArrayList<String>();
        path = "PATH=" + path;
        envp.add(path);
        Map<String, String> vars = System.getenv();
        for (String string : vars.keySet()) {
            if (!string.equals(PATH)) {
                envp.add(String.valueOf(string) + "=" + vars.get(string));
                continue;
            }
            envp.add("PATH=" + path);
        }
        try {
            Process proc = ProcessFactory.getFactory().exec(GCC_VERSION_CMD.split(SP), envp.toArray(new String[envp.size()]));
            if (proc != null) {
                String s;
                InputStream ein = proc.getInputStream();
                BufferedReader d1 = new BufferedReader(new InputStreamReader(ein));
                ArrayList<String> ls = new ArrayList<String>(10);
                while ((s = d1.readLine()) != null) {
                    ls.add(s);
                }
                ein.close();
                return WindowsBuildPathResolver.testVersionInfo(ls.toArray(new String[0]));
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    private static boolean testVersionInfo(String[] versionInfo) {
        if (versionInfo != null) {
            int i = 0;
            while (i < versionInfo.length) {
                if (versionInfo[i].indexOf(MINGW_SPECIAL) != -1) {
                    return true;
                }
                if (versionInfo[i].indexOf(CYGWIN_SPECIAL) != -1) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    public static enum ToolchainEnvironment {
        UNDEFINED,
        LINUX,
        MINGW,
        CYGWIN;

    }
}

