/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.managedbuilder;

import com.atmel.avr32.CDTAdapter;
import com.atmel.avr32.managedbuilder.IProjectConverter;
import com.atmel.avr32.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConvertManagedBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class ManagedbuildPlugin
extends Plugin {
    private static final String AVR32_NATURE_ID = "com.atmel.avr32.core.nature";
    private static final String AVR32PROJECT = ".avr32project";
    private static final String AVR32_PROJECT_TARGET_CPU = "AVR32_PROJECT_TARGET_CPU";
    private static final String PROJECT_PART_ID = "project.part.id";
    private static final String PROJECT_FLASHVAULT = "project.secured";
    private static final String PROJECT_SECURED_RAM = "project.secured.ram";
    private static final String PROJECT_SECURED_FLASH = "project.secured.flash";
    private static final String OLD_PLUGIN_ID = "com.atmel.avr32.builder.core";
    public static final String PLUGIN_ID = "com.atmel.avr32.managedbuilder";
    private static ManagedbuildPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ManagedbuildPlugin getDefault() {
        return plugin;
    }

    public static void setProjectMCU(IProject project, String part) {
        Assert.isNotNull((Object)part, (String)"Project part cannot be set to null");
        Assert.isNotNull((Object)project, (String)"Cannot specify part on a null project");
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode(PLUGIN_ID);
        if (projectNode != null) {
            projectNode.put(PROJECT_PART_ID, part);
            try {
                projectNode.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setFlashVaultOptions(IProject project, boolean enable, int ram, int flash) {
        Assert.isNotNull((Object)project, (String)"Cannot specify part on a null project");
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode(PLUGIN_ID);
        if (projectNode != null) {
            projectNode.putBoolean(PROJECT_FLASHVAULT, enable);
            projectNode.putInt(PROJECT_SECURED_RAM, ram);
            projectNode.putInt(PROJECT_SECURED_FLASH, flash);
            try {
                projectNode.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getProjectMCU(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode(PLUGIN_ID);
        String part = projectNode.get(PROJECT_PART_ID, "");
        if (part == null || part.length() == 0) {
            projectNode = projectScope.getNode(OLD_PLUGIN_ID);
            part = projectNode.get(PROJECT_PART_ID, "");
            if (part == null || part.length() == 0) {
                part = ManagedbuildPlugin.getProjectProperty(project, AVR32_PROJECT_TARGET_CPU);
                if (part != null) {
                    ManagedbuildPlugin.setProjectMCU(project, part);
                }
            } else {
                ManagedbuildPlugin.setProjectMCU(project, part);
            }
        }
        return part;
    }

    public static boolean isSecured(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode(PLUGIN_ID);
        return projectNode.getBoolean(PROJECT_FLASHVAULT, false);
    }

    public static int getSecuredRAMLength(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode(PLUGIN_ID);
        return projectNode.getInt(PROJECT_SECURED_RAM, 0);
    }

    public static int getSecuredFlashLength(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode(PLUGIN_ID);
        return projectNode.getInt(PROJECT_SECURED_FLASH, 0);
    }

    public static String getProjectTypeId(IProject project) {
        IManagedProject improject;
        if (ManagedBuildManager.canGetBuildInfo((IResource)project) && (improject = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject()).getProjectType() != null) {
            return improject.getProjectType().getId();
        }
        return null;
    }

    public static boolean isAVR32Project(IProject project) {
        try {
            return project.hasNature(AVR32_NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean shouldConvertUC3ES(IProject project) {
        File f = project.getFile(AVR32PROJECT).getLocation().toFile();
        return f.exists();
    }

    private static String getProjectProperty(IProject project, String key) {
        File f;
        Properties p;
        block3: {
            try {
                Assert.isNotNull((Object)project);
                Assert.isNotNull((Object)key);
                p = new Properties();
                f = project.getFile(AVR32PROJECT).getLocation().toFile();
                if (f.exists()) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        FileInputStream fis = new FileInputStream(f);
        p.loadFromXML(fis);
        fis.close();
        return p.getProperty(key);
    }

    public static IStatus upgradeToolchain(IProject project) throws CoreException {
        MultiStatus ms = new MultiStatus(PLUGIN_ID, 0, "Upgrading project MBS settings for " + project.getName(), null);
        CoreModel.getDefault().getProjectDescriptionManager().updateProjectDescriptions(new IProject[]{project}, (IProgressMonitor)new NullProgressMonitor());
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project, (boolean)true);
        if (info != null) {
            IManagedProject obj = info.getManagedProject();
            obj.getConfigurations();
            IProjectType type = obj.getProjectType();
            if (type == null) {
                ms.add((IStatus)new Status(4, PLUGIN_ID, "Project type is unavailable for project " + project.getName()));
                return ms;
            }
            Map map = ManagedBuildManager.getConversionElements((IBuildObject)type);
            if (map.size() == 0) {
                ms.add((IStatus)new Status(8, PLUGIN_ID, "No converters for project type " + type + " (" + type.getId() + ") available"));
                return ms;
            }
            String base = obj.getProjectType().getBaseId();
            for (Object converter : map.values()) {
                if (!(converter instanceof IConfigurationElement)) continue;
                String fromId = ((IConfigurationElement)converter).getAttribute("fromId");
                String toId = ((IConfigurationElement)converter).getAttribute("toId");
                if (!ManagedBuildManager.getIdFromIdAndVersion((String)toId).equals(base)) continue;
                IConvertManagedBuildObject convertBuildObject = null;
                try {
                    convertBuildObject = (IConvertManagedBuildObject)((IConfigurationElement)converter).createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (convertBuildObject == null) continue;
                convertBuildObject.convert((IBuildObject)obj, fromId, toId, true);
                if (convertBuildObject instanceof IProjectConverter) {
                    ms.add(((IProjectConverter)convertBuildObject).getStatus());
                }
                ManagedbuildPlugin.upgradeToolchain(project);
            }
        }
        return ms;
    }

    public static IProject createProject(String name, String mcu, String type, boolean cpp, IProgressMonitor monitor) throws CoreException, BuildException {
        IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(handle.getName());
        IProject project = CCorePlugin.getDefault().createCProject(description, handle, monitor, ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
        ManagedbuildPlugin.setProjectMCU(project, mcu);
        ManagedCProjectNature.addManagedNature((IProject)project, (IProgressMonitor)monitor);
        ManagedCProjectNature.addManagedBuilder((IProject)project, (IProgressMonitor)monitor);
        if (cpp) {
            ManagedCProjectNature.addNature((IProject)project, (String)"org.eclipse.cdt.core.ccnature", (IProgressMonitor)monitor);
        }
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType parent = ManagedBuildManager.getProjectType((String)type);
        try {
            IManagedProject mp = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)parent);
            CDTAdapter.setConfigurations((IManagedProject)mp, (IConfiguration[])parent.getConfigurations());
            if (info != null) {
                info.setValid(true);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        Tools.insertNature((IProject)project, (String)AVR32_NATURE_ID, (IProgressMonitor)monitor);
        CDTAdapter.setMCUOption((IProject)project, (String)("-mpart=" + mcu.toLowerCase()));
        return project;
    }

    public static void setFlashVault(IProject project, boolean value) {
        IConfiguration[] configs;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configs = info.getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            ManagedbuildPlugin.setFlashVaultOption(configuration, value);
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    private static void setFlashVaultOption(IConfiguration configuration, boolean value) {
        ITool[] tools;
        ITool[] iToolArray = tools = configuration.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IOption[] options;
            ITool tool = iToolArray[n2];
            IOption[] iOptionArray = options = tool.getOptions();
            int n3 = options.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption option = iOptionArray[n4];
                if (option.getId().startsWith("avr32") && option.getId().indexOf(".option.flashvault") > -1) {
                    ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)tool, (IOption)option, (boolean)value);
                    ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static boolean isLinuxProject(IProject iProject) {
        return ManagedbuildPlugin.getProjectTypeId(iProject).startsWith("avr32linux");
    }
}

