/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.CopyToClipboardAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.navigator.INavigatorContentService;

public class RefactorActionGroup
extends ActionGroup {
    private CopyToClipboardAction copyAction;
    private MoveResourceAction moveAction;
    private RenameResourceAction renameAction;
    private ISynchronizePageSite site;
    private DeleteResourceAction deleteAction;
    private final INavigatorContentService navigatorContentService;
    static /* synthetic */ Class class$0;

    public RefactorActionGroup(ISynchronizePageSite site) {
        this(site, null);
    }

    public RefactorActionGroup(ISynchronizePageSite site, INavigatorContentService navigatorContentService) {
        this.site = site;
        this.navigatorContentService = navigatorContentService;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager parentMenu, String groupId) {
        parentMenu.appendToGroup(groupId, (IAction)this.copyAction);
        parentMenu.appendToGroup(groupId, (IAction)this.deleteAction);
        parentMenu.appendToGroup(groupId, (IAction)this.moveAction);
        parentMenu.appendToGroup(groupId, (IAction)this.renameAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
    }

    public void updateActionBars() {
        this.copyAction.selectionChanged(this.getObjectSelection());
        this.deleteAction.selectionChanged(this.getObjectSelection());
        this.moveAction.selectionChanged(this.getObjectSelection());
        this.renameAction.selectionChanged(this.getObjectSelection());
    }

    protected void makeActions() {
        Shell shell = this.site.getShell();
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.copyAction = new CopyToClipboardAction(shell, this.navigatorContentService);
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.deleteAction = new DeleteResourceAction(shell){

            protected List getSelectedResources() {
                return RefactorActionGroup.this.getSelection().toList();
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(selection) && RefactorActionGroup.this.allResourcesAreOfType(selection, 7);
            }
        };
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.moveAction = new MoveResourceAction(shell){

            protected boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(selection) && RefactorActionGroup.this.allResourcesAreOfType(selection, 7);
            }
        };
        this.moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
        this.renameAction = new RenameResourceAction(shell){

            protected boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(selection) && RefactorActionGroup.this.allResourcesAreOfType(selection, 7);
            }
        };
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    private IStructuredSelection getSelection() {
        ISelection selection = this.getContext().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object[])Utils.getResources(((IStructuredSelection)selection).toArray()));
    }

    private IStructuredSelection getObjectSelection() {
        ISelection selection = this.getContext().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return new StructuredSelection();
        }
        return (IStructuredSelection)selection;
    }

    private boolean allResourcesAreOfType(IStructuredSelection selection, int resourceMask) {
        Iterator resources = selection.iterator();
        while (resources.hasNext()) {
            IResource[] r;
            Object next = resources.next();
            IResource resource = null;
            if (next instanceof IResource) {
                resource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)adaptable.getAdapter((Class)clazz);
            }
            if (resource == null && (r = Utils.getResources(new Object[]{next})).length == 1) {
                resource = r[0];
            }
            if (resource != null && (resource.getType() & resourceMask) != 0) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        this.copyAction.dispose();
    }
}

