/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.ICache;
import org.eclipse.team.core.ICacheListener;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.mapping.ResourceDiffCompareInput;

public class ResourceCompareInputChangeNotifier
extends CompareInputChangeNotifier
implements IDiffChangeListener {
    static final String RESOURCE_CHANGE_NOTIFIER_PROPERTY = "org.eclipse.team.ui.ResourceChangeNotifier";
    private ISynchronizationContext context;
    private final CompareInputLabelProvider labelProvider = new CompareInputLabelProvider();

    public static ResourceCompareInputChangeNotifier getChangeNotifier(ISynchronizationContext context) {
        ResourceCompareInputChangeNotifier notifier = (ResourceCompareInputChangeNotifier)context.getCache().get(RESOURCE_CHANGE_NOTIFIER_PROPERTY);
        if (notifier == null) {
            notifier = new ResourceCompareInputChangeNotifier(context);
            context.getCache().put(RESOURCE_CHANGE_NOTIFIER_PROPERTY, (Object)notifier);
        }
        return notifier;
    }

    public ResourceCompareInputChangeNotifier(ISynchronizationContext context) {
        this.context = context;
        this.initialize();
    }

    public void initialize() {
        this.context.getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
        this.context.getCache().addCacheListener(new ICacheListener(){

            public void cacheDisposed(ICache cache) {
                ResourceCompareInputChangeNotifier.this.dispose();
            }
        });
        super.initialize();
    }

    public void dispose() {
        super.dispose();
        this.context.getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        this.labelProvider.dispose();
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        HashSet<ICompareInput> changedInputs = new HashSet<ICompareInput>();
        IDiff[] added = event.getAdditions();
        int i = 0;
        while (i < added.length) {
            IDiff diff = added[i];
            ICompareInput input = this.findInput(ResourceDiffTree.getResourceFor((IDiff)diff));
            if (input != null) {
                changedInputs.add(input);
            }
            ++i;
        }
        IDiff[] changed = event.getChanges();
        int i2 = 0;
        while (i2 < changed.length) {
            IDiff diff = changed[i2];
            ICompareInput input = this.findInput(ResourceDiffTree.getResourceFor((IDiff)diff));
            if (input != null) {
                changedInputs.add(input);
            }
            ++i2;
        }
        IPath[] paths = event.getRemovals();
        int i3 = 0;
        while (i3 < paths.length) {
            IPath path = paths[i3];
            ICompareInput input = this.findInput(path);
            if (input != null) {
                changedInputs.add(input);
            }
            ++i3;
        }
        if (!changedInputs.isEmpty()) {
            this.handleInputChanges(changedInputs.toArray(new ICompareInput[changedInputs.size()]), false);
        }
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    protected IResource[] getResources(ICompareInput input) {
        IResource resource = this.getResource(input);
        if (resource == null) {
            return new IResource[0];
        }
        return new IResource[]{resource};
    }

    private IResource getResource(ICompareInput input) {
        if (input instanceof IResourceProvider) {
            IResourceProvider rp = (IResourceProvider)input;
            return rp.getResource();
        }
        return Utils.getResource(input);
    }

    private ICompareInput findInput(IPath path) {
        ICompareInput[] inputs = this.getConnectedInputs();
        int i = 0;
        while (i < inputs.length) {
            ICompareInput input = inputs[i];
            IResource inputResource = this.getResource(input);
            if (inputResource != null && inputResource.getFullPath().equals((Object)path)) {
                return input;
            }
            ++i;
        }
        return null;
    }

    private ICompareInput findInput(IResource resource) {
        ICompareInput[] inputs = this.getConnectedInputs();
        int i = 0;
        while (i < inputs.length) {
            ICompareInput input = inputs[i];
            IResource inputResource = this.getResource(input);
            if (inputResource != null && inputResource.equals((Object)resource)) {
                return input;
            }
            ++i;
        }
        return null;
    }

    protected void prepareInput(ICompareInput input, IProgressMonitor monitor) {
        if (input instanceof ResourceDiffCompareInput) {
            ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)input;
            IResource resource = rdci.getResource();
            IDiff diff = this.getContext().getDiffTree().getDiff(resource);
            try {
                ResourceDiffCompareInput.ensureContentsCached(diff, monitor);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        super.prepareInput(input, monitor);
    }

    public ICompareInputLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void fetchAuthors(final Object input) {
        this.runInBackground(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ResourceCompareInputChangeNotifier.this.fetchAuthors(input, monitor);
            }
        });
    }

    protected void fetchAuthors(Object input, IProgressMonitor monitor) throws CoreException {
        ResourceDiffCompareInput rdci;
        if (input instanceof ResourceDiffCompareInput && (rdci = (ResourceDiffCompareInput)input).updateAuthorInfo(monitor)) {
            this.fireLabelProviderChange(input);
        }
    }

    private void fireLabelProviderChange(Object input) {
        this.labelProvider.fireChangeEvent(input);
    }

    public final ISynchronizationContext getContext() {
        return this.context;
    }

    protected boolean belongsTo(Object family) {
        return family == this.getContext();
    }

    private class CompareInputLabelProvider
    extends BaseLabelProvider
    implements ICompareInputLabelProvider {
        private CompareInputLabelProvider() {
        }

        public Image getAncestorImage(Object input) {
            return null;
        }

        public String getAncestorLabel(Object input) {
            ResourceDiffCompareInput rdci;
            ITypedElement element;
            if (input instanceof ResourceDiffCompareInput && (element = (rdci = (ResourceDiffCompareInput)input).getAncestor()) != null) {
                IFileRevision revision = ((FileRevisionTypedElement)element).getFileRevision();
                if (revision != null) {
                    if (TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.show_author_in_compare_editor")) {
                        String author = ((FileRevisionTypedElement)element).getAuthor();
                        if (author != null) {
                            return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_baseLabelAuthorExists, (Object[])new String[]{revision.getContentIdentifier(), author});
                        }
                        if (revision.isPropertyMissing()) {
                            ResourceCompareInputChangeNotifier.this.fetchAuthors(input);
                        }
                    }
                    return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_baseLabelExists, (Object[])new String[]{revision.getContentIdentifier()});
                }
                return TeamUIMessages.SyncInfoCompareInput_baseLabel;
            }
            return null;
        }

        public Image getLeftImage(Object input) {
            return null;
        }

        public String getLeftLabel(Object input) {
            if (input instanceof ResourceDiffCompareInput) {
                ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)input;
                String localContentId = rdci.getLocalContentId();
                if (localContentId != null) {
                    return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_localLabelExists, (Object[])new String[]{localContentId});
                }
                return TeamUIMessages.SyncInfoCompareInput_localLabel;
            }
            return null;
        }

        public Image getRightImage(Object input) {
            return null;
        }

        public String getRightLabel(Object input) {
            ResourceDiffCompareInput rdci;
            ITypedElement element;
            if (input instanceof ResourceDiffCompareInput && (element = (rdci = (ResourceDiffCompareInput)input).getRight()) != null) {
                IFileRevision revision = ((FileRevisionTypedElement)element).getFileRevision();
                if (revision != null) {
                    if (TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.show_author_in_compare_editor")) {
                        String author = ((FileRevisionTypedElement)element).getAuthor();
                        if (author != null) {
                            return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_remoteLabelAuthorExists, (Object[])new String[]{revision.getContentIdentifier(), author});
                        }
                        if (revision.isPropertyMissing()) {
                            ResourceCompareInputChangeNotifier.this.fetchAuthors(input);
                        }
                    }
                    return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_remoteLabelExists, (Object[])new String[]{revision.getContentIdentifier()});
                }
                return TeamUIMessages.SyncInfoCompareInput_remoteLabel;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                return ci.getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                return ci.getName();
            }
            return null;
        }

        public void fireChangeEvent(Object element) {
            Display.getDefault().asyncExec(new Runnable(this, element){
                final /* synthetic */ CompareInputLabelProvider this$1;
                private final /* synthetic */ Object val$element;
                {
                    this.this$1 = compareInputLabelProvider;
                    this.val$element = object;
                }

                public void run() {
                    CompareInputLabelProvider.access$1(this.this$1, new LabelProviderChangedEvent((IBaseLabelProvider)this.this$1, this.val$element));
                }
            });
        }

        static /* synthetic */ void access$1(CompareInputLabelProvider compareInputLabelProvider, LabelProviderChangedEvent labelProviderChangedEvent) {
            compareInputLabelProvider.fireLabelProviderChanged(labelProviderChangedEvent);
        }
    }
}

