/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LaunchUIPlugin
extends AbstractUIPlugin
implements ILaunchesListener2 {
    public static final String PLUGIN_ID = "org.eclipse.cdt.launch";
    private static LaunchUIPlugin fgPlugin;
    private static Shell debugDialogShell;

    public LaunchUIPlugin() {
        LaunchUIPlugin.setDefault(this);
    }

    private static void setDefault(LaunchUIPlugin plugin) {
        fgPlugin = plugin;
    }

    public static LaunchUIPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getShell() {
        if (LaunchUIPlugin.getActiveWorkbenchShell() != null) {
            return LaunchUIPlugin.getActiveWorkbenchShell();
        }
        if (debugDialogShell != null) {
            if (!debugDialogShell.isDisposed()) {
                return debugDialogShell;
            }
            debugDialogShell = null;
        }
        IWorkbenchWindow[] windows = LaunchUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }

    public static void setDialogShell(Shell shell) {
        debugDialogShell = shell;
    }

    public static String getUniqueIdentifier() {
        if (LaunchUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return LaunchUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        LaunchUIPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LaunchUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void errorDialog(String message, IStatus status) {
        LaunchUIPlugin.log(status);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString("LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        LaunchUIPlugin.log(t);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString("LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LaunchUIPlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_FILTERED_DEBUGGERS);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        super.stop(context);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            if (l instanceof AbstractCLaunchDelegate.CLaunch) {
                ((AbstractCLaunchDelegate.CLaunch)l).refresh();
            }
            ++n2;
        }
    }
}

