/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.refactoring;

import org.eclipse.cdt.launch.internal.refactoring.AbstractLaunchConfigChange;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

class ProjectRenameChange
extends AbstractLaunchConfigChange {
    private String changeName;
    private String oldName;
    private String newName;

    public ProjectRenameChange(ILaunchConfiguration launchConfig, String oldName, String newName) {
        super(launchConfig);
        this.oldName = oldName;
        this.newName = newName;
    }

    public String getName() {
        if (this.changeName == null) {
            this.changeName = NLS.bind((String)LaunchMessages.getString("ProjectRenameChange.name"), (Object)this.getLaunchConfiguration().getName());
        }
        return this.changeName;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ILaunchConfiguration launchConfig = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = launchConfig.getWorkingCopy();
        IResource[] mapped = launchConfig.getMappedResources();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject oldProject = root.getProject(this.oldName);
        IProject newProject = root.getProject(this.newName);
        if (oldProject != null && newProject != null && mapped != null && mapped.length > 0) {
            int i = 0;
            while (i < mapped.length) {
                if (oldProject.equals((Object)mapped[i])) {
                    mapped[i] = newProject;
                }
                ++i;
            }
            copy.setMappedResources(mapped);
        }
        copy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.newName);
        try {
            copy.doSave();
        }
        catch (CoreException e) {
            LaunchUIPlugin.log((IStatus)new MultiStatus("org.eclipse.cdt.launch", 0, new IStatus[]{e.getStatus()}, NLS.bind((String)LaunchMessages.getString("ProjectRenameChange.saveFailed"), (Object)launchConfig.getName()), null));
            return null;
        }
        return new ProjectRenameChange(this.getLaunchConfiguration(), this.newName, this.oldName);
    }
}

