/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchUtils {
    public static String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.parseArguments(LaunchUtils.getProgramArguments(config));
    }

    public static String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = LaunchUtils.getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    public static IBinaryParser.IBinaryObject getBinary(IProject project, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return exe;
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
            return exe;
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public static IBinaryParser.IBinaryObject getBinary(String programName, String projectName) throws CoreException {
        if (programName != null) {
            Path exePath = new Path(programName);
            IProject project = null;
            if (projectName != null && !projectName.equals("")) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null || project.getLocation() == null) {
                    return null;
                }
                if (!exePath.isAbsolute()) {
                    exePath = project.getLocation().append((IPath)exePath);
                }
            }
            return LaunchUtils.getBinary(project, (IPath)exePath);
        }
        return null;
    }

    public static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    private static String[] parseArguments(String args) {
        return CommandLineUtil.argumentsToArray((String)args);
    }
}

