/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;

public class PathComparator
implements Comparator {
    public static PathComparator INSTANCE = new PathComparator();

    private PathComparator() {
    }

    public int compare(Object arg0, Object arg1) {
        if (arg0 == arg1) {
            return 0;
        }
        IPath path1 = (IPath)arg0;
        IPath path2 = (IPath)arg1;
        int length1 = path1.segmentCount();
        int length2 = path2.segmentCount();
        int i = 0;
        while (i < length1) {
            if (i >= length2) {
                return 1;
            }
            int comparison = path1.segment(i).compareTo(path2.segment(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        if (length1 == length2) {
            return 0;
        }
        return -1;
    }

    public static IPath getNext(IPath path) {
        if (path.segmentCount() == 0) {
            return null;
        }
        String newLast = String.valueOf(path.lastSegment()) + '\u0000';
        return path.removeLastSegments(1).append(newLast);
    }

    public static IPath getFirstChild(IPath path) {
        return path.append("\u0000");
    }

    public static SortedMap getChildPathMap(SortedMap map, IPath path, boolean includeThis, boolean copy) {
        SortedMap result;
        IPath start = includeThis ? path : PathComparator.getFirstChild(path);
        IPath next = PathComparator.getNext(path);
        SortedMap sortedMap = result = next != null ? map.subMap(start, next) : map.tailMap(start);
        if (copy) {
            result = new TreeMap(result);
        }
        return result;
    }

    public static SortedSet getChildPathSet(SortedSet set, IPath path, boolean includeThis, boolean copy) {
        SortedSet<IPath> result;
        IPath start = includeThis ? path : PathComparator.getFirstChild(path);
        IPath next = PathComparator.getNext(path);
        SortedSet<IPath> sortedSet = result = next != null ? set.subSet(start, next) : set.tailSet(start);
        if (copy) {
            result = new TreeSet<IPath>(result);
        }
        return result;
    }

    public static SortedSet getDirectChildPathSet(SortedSet set, IPath path) {
        SortedSet<IPath> children = PathComparator.getChildPathSet(set, path, false, false);
        TreeSet<IPath> result = new TreeSet<IPath>(INSTANCE);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IPath childPath = (IPath)iter.next();
            result.add(childPath);
            children = children.tailSet(PathComparator.getNext(childPath));
            iter = children.iterator();
        }
        return result;
    }

    public static SortedMap getDirectChildPathMap(SortedMap map, IPath path) {
        SortedMap children = PathComparator.getChildPathMap(map, path, false, false);
        TreeMap result = new TreeMap(INSTANCE);
        Iterator iter = children.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IPath childPath = (IPath)entry.getKey();
            result.put(childPath, entry.getValue());
            children = children.tailMap(PathComparator.getNext(childPath));
            iter = children.entrySet().iterator();
        }
        return result;
    }
}

