/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.envvar.EnvVarCollector;
import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentBuildPathsChangeListener;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.cdt.managedbuilder.internal.envvar.StoredBuildPathEnvironmentContainer;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;

public class EnvironmentVariableProvider
implements IEnvironmentVariableProvider {
    private static EnvironmentVariableProvider fInstance = null;
    private List fListeners = null;
    private IEnvironmentVariableManager fMngr;
    private boolean fBuildPathVarCheckAllowed;
    private StoredBuildPathEnvironmentContainer fIncludeStoredBuildPathVariables;
    private StoredBuildPathEnvironmentContainer fLibraryStoredBuildPathVariables;

    protected EnvironmentVariableProvider(IEnvironmentVariableManager mngr) {
        this.fMngr = mngr;
    }

    public static EnvironmentVariableProvider getDefault() {
        if (fInstance == null) {
            fInstance = new EnvironmentVariableProvider(CCorePlugin.getDefault().getBuildEnvironmentManager());
            EnvironmentVariableProvider.fInstance.fBuildPathVarCheckAllowed = true;
        }
        return fInstance;
    }

    public IBuildEnvironmentVariable getVariable(String variableName, Object level, boolean includeParentLevels, boolean resolveMacros) {
        if (variableName == null || "".equals(variableName)) {
            return null;
        }
        if (level instanceof IConfiguration) {
            return EnvironmentVariableProvider.wrap(this.getVariable(variableName, (IConfiguration)level, resolveMacros));
        }
        return null;
    }

    public IEnvironmentVariable getVariable(String variableName, IConfiguration cfg, boolean resolveMacros) {
        return this.getVariable(variableName, cfg, resolveMacros, true);
    }

    public IEnvironmentVariable getVariable(String variableName, IConfiguration cfg, boolean resolveMacros, boolean checkBuildPaths) {
        ICConfigurationDescription des = ManagedBuildManager.getDescriptionForConfiguration(cfg);
        if (des != null) {
            IEnvironmentVariable variable = this.fMngr.getVariable(variableName, des, resolveMacros);
            if (checkBuildPaths && resolveMacros && this.fBuildPathVarCheckAllowed) {
                this.checkBuildPathVariable(cfg, variableName, variable);
            }
            return variable;
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables(IConfiguration cfg, boolean resolveMacros) {
        return this.getVariables(cfg, resolveMacros, true);
    }

    public IEnvironmentVariable[] getVariables(IConfiguration cfg, boolean resolveMacros, boolean checkBuildPaths) {
        ICConfigurationDescription des = ManagedBuildManager.getDescriptionForConfiguration(cfg);
        if (des != null) {
            IEnvironmentVariable[] vars = this.fMngr.getVariables(des, resolveMacros);
            if (checkBuildPaths && resolveMacros && this.fBuildPathVarCheckAllowed) {
                this.checkBuildPathVariables(cfg, vars);
            }
            return vars;
        }
        return new IBuildEnvironmentVariable[0];
    }

    public static IBuildEnvironmentVariable wrap(IEnvironmentVariable var) {
        if (var == null) {
            return null;
        }
        if (var instanceof IBuildEnvironmentVariable) {
            return (IBuildEnvironmentVariable)var;
        }
        return new BuildEnvVar(var);
    }

    public static IBuildEnvironmentVariable[] wrap(IEnvironmentVariable[] vars) {
        if (vars == null) {
            return null;
        }
        if (vars instanceof IBuildEnvironmentVariable[]) {
            return (IBuildEnvironmentVariable[])vars;
        }
        IBuildEnvironmentVariable[] buildVars = new IBuildEnvironmentVariable[vars.length];
        int i = 0;
        while (i < vars.length) {
            buildVars[i] = EnvironmentVariableProvider.wrap(vars[i]);
            ++i;
        }
        return buildVars;
    }

    public IBuildEnvironmentVariable[] getVariables(Object level, boolean includeParentLevels, boolean resolveMacros) {
        if (level instanceof IConfiguration) {
            return EnvironmentVariableProvider.wrap(this.getVariables((IConfiguration)level, resolveMacros));
        }
        return new IBuildEnvironmentVariable[0];
    }

    public String getDefaultDelimiter() {
        return this.fMngr.getDefaultDelimiter();
    }

    public boolean isVariableCaseSensitive() {
        return this.fMngr.isVariableCaseSensitive();
    }

    public IEnvironmentVariableSupplier[] getSuppliers(Object level) {
        return null;
    }

    public String[] getBuildPaths(IConfiguration configuration, int buildPathType) {
        ITool[] tools = configuration.getFilteredTools();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < tools.length) {
            IEnvVarBuildPath[] pathDescriptors = tools[i].getEnvVarBuildPaths();
            if (pathDescriptors != null && pathDescriptors.length != 0) {
                int j = 0;
                while (j < pathDescriptors.length) {
                    String[] vars;
                    IEnvVarBuildPath curPathDes = pathDescriptors[j];
                    if (curPathDes.getType() == buildPathType && (vars = curPathDes.getVariableNames()) != null && vars.length != 0) {
                        IBuildPathResolver pathResolver = curPathDes.getBuildPathResolver();
                        if (pathResolver == null) {
                            String delimiter = curPathDes.getPathDelimiter();
                            if (delimiter == null) {
                                delimiter = this.getDefaultDelimiter();
                            }
                            pathResolver = new DefaultBuildPathResolver(delimiter);
                        }
                        int k = 0;
                        while (k < vars.length) {
                            String varValue;
                            String[] paths;
                            String varName = vars[k];
                            IEnvironmentVariable var = this.getVariable(varName, configuration, true, false);
                            if (var != null && (paths = pathResolver.resolveBuildPaths(buildPathType, varName, varValue = var.getValue(), configuration)) != null && paths.length != 0) {
                                list.addAll(Arrays.asList(paths));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private List getListeners() {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        return this.fListeners;
    }

    private void notifyListeners(IConfiguration configuration, int buildPathType) {
        List listeners = this.getListeners();
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ((IEnvironmentBuildPathsChangeListener)iterator.next()).buildPathsChanged(configuration, buildPathType);
        }
    }

    public synchronized void subscribe(IEnvironmentBuildPathsChangeListener listener) {
        if (listener == null) {
            return;
        }
        List listeners = this.getListeners();
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public synchronized void unsubscribe(IEnvironmentBuildPathsChangeListener listener) {
        if (listener == null) {
            return;
        }
        List listeners = this.getListeners();
        listeners.remove(listener);
    }

    public void checkBuildPathVariables(IConfiguration configuration) {
        this.checkBuildPathVariables(configuration, this.getVariables(configuration, true, false));
    }

    public void checkBuildPathVariables(IConfiguration configuration, int buildPathType) {
        EnvVarCollector cr = new EnvVarCollector();
        cr.add(this.getVariables(configuration, true, false));
        this.checkBuildPathVariables(configuration, buildPathType, cr);
    }

    protected void checkBuildPathVariables(IConfiguration configuration, IEnvironmentVariable[] vars) {
        EnvVarCollector cr = new EnvVarCollector();
        cr.add(vars);
        this.checkBuildPathVariables(configuration, 1, cr);
        this.checkBuildPathVariables(configuration, 2, cr);
    }

    protected void checkBuildPathVariable(IConfiguration configuration, String varName, IEnvironmentVariable var) {
        this.checkBuildPathVariable(configuration, 1, varName, var);
        this.checkBuildPathVariable(configuration, 2, varName, var);
    }

    protected void checkBuildPathVariable(IConfiguration configuration, int buildPathType, String varName, IEnvironmentVariable var) {
        StoredBuildPathEnvironmentContainer buildPathVars = this.getStoredBuildPathVariables(buildPathType);
        if (buildPathVars == null) {
            return;
        }
        if (buildPathVars.isVariableChanged(varName, var, configuration)) {
            EnvVarCollector cr = new EnvVarCollector();
            cr.add(this.getVariables(configuration, true, false));
            buildPathVars.synchronize(cr, configuration);
            this.notifyListeners(configuration, buildPathType);
        }
    }

    protected void checkBuildPathVariables(IConfiguration configuration, int buildPathType, EnvVarCollector varSet) {
        StoredBuildPathEnvironmentContainer buildPathVars = this.getStoredBuildPathVariables(buildPathType);
        if (buildPathVars == null) {
            return;
        }
        if (buildPathVars.checkBuildPathChange(varSet, configuration)) {
            this.notifyListeners(configuration, buildPathType);
        }
    }

    protected StoredBuildPathEnvironmentContainer getStoredBuildPathVariables(int buildPathType) {
        return buildPathType == 2 ? this.getStoredLibraryBuildPathVariables() : this.getStoredIncludeBuildPathVariables();
    }

    protected StoredBuildPathEnvironmentContainer getStoredIncludeBuildPathVariables() {
        if (this.fIncludeStoredBuildPathVariables == null) {
            this.fIncludeStoredBuildPathVariables = new StoredBuildPathEnvironmentContainer(1);
        }
        return this.fIncludeStoredBuildPathVariables;
    }

    protected StoredBuildPathEnvironmentContainer getStoredLibraryBuildPathVariables() {
        if (this.fLibraryStoredBuildPathVariables == null) {
            this.fLibraryStoredBuildPathVariables = new StoredBuildPathEnvironmentContainer(2);
        }
        return this.fLibraryStoredBuildPathVariables;
    }

    public static class DefaultBuildPathResolver
    implements IBuildPathResolver {
        private String fDelimiter;

        public DefaultBuildPathResolver(String delimiter) {
            this.fDelimiter = delimiter;
        }

        public String[] resolveBuildPaths(int pathType, String variableName, String variableValue, IConfiguration configuration) {
            if (this.fDelimiter == null || "".equals(this.fDelimiter)) {
                return new String[]{variableValue};
            }
            List list = EnvVarOperationProcessor.convertToList((String)variableValue, (String)this.fDelimiter);
            return list.toArray(new String[list.size()]);
        }
    }
}

