/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.util.ResourceChangeHandlerBase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;

class ResourcePropertyHolder
extends ResourceChangeHandlerBase {
    private Map fRcMap = new HashMap();
    private boolean fProjectOnly;

    public ResourcePropertyHolder(boolean projectOnly) {
        this.fProjectOnly = projectOnly;
    }

    private boolean isValidResource(IResource rc) {
        return !this.fProjectOnly || rc.getType() == 4;
    }

    protected ResourceChangeHandlerBase.IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent event) {
        return new ResourceMoveHandler();
    }

    protected Object keyForResource(IResource rc) {
        return rc.getFullPath().toString();
    }

    public synchronized Object getProperty(IResource rc, Object propKey) throws IllegalArgumentException {
        if (!this.isValidResource(rc)) {
            throw new IllegalArgumentException();
        }
        Map map = this.getResourcePropertyMap(rc, false);
        if (map == null) {
            return null;
        }
        return map.get(propKey);
    }

    private Map getResourcePropertyMap(IResource rc, boolean create) {
        Object key = this.keyForResource(rc);
        HashMap map = (HashMap)this.fRcMap.get(key);
        if (map == null && create) {
            map = new HashMap();
            this.fRcMap.put(key, map);
        }
        return map;
    }

    private synchronized void removeResourcePropertyMap(IResource rc) {
        Object key = this.keyForResource(rc);
        this.fRcMap.remove(key);
    }

    private synchronized void moveResourcePropertyMap(IResource fromRc, IResource toRc) {
        Object fromKey = this.keyForResource(fromRc);
        Object toKey = this.keyForResource(toRc);
        Map fromMap = (Map)this.fRcMap.remove(fromKey);
        if (fromMap != null) {
            this.fRcMap.put(toKey, fromMap);
        } else {
            this.fRcMap.remove(toKey);
        }
    }

    public synchronized Object setProperty(IResource rc, Object propKey, Object value) throws IllegalArgumentException {
        if (!this.isValidResource(rc)) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            return this.removeProperty(rc, propKey);
        }
        Map map = this.getResourcePropertyMap(rc, true);
        return map.put(propKey, value);
    }

    private synchronized Object removeProperty(IResource rc, Object propKey) {
        Map map = this.getResourcePropertyMap(rc, false);
        if (map == null) {
            return null;
        }
        Object old = map.remove(propKey);
        if (map.size() == 0) {
            this.removeResourcePropertyMap(rc);
        }
        return old;
    }

    private class ResourceMoveHandler
    implements ResourceChangeHandlerBase.IResourceMoveHandler {
        private ResourceMoveHandler() {
        }

        public void done() {
        }

        public void handleProjectClose(IProject project) {
            ResourcePropertyHolder.this.removeResourcePropertyMap((IResource)project);
        }

        public boolean handleResourceMove(IResource fromRc, IResource toRc) {
            if (ResourcePropertyHolder.this.isValidResource(fromRc)) {
                ResourcePropertyHolder.this.moveResourcePropertyMap(fromRc, toRc);
                return !ResourcePropertyHolder.this.fProjectOnly;
            }
            return false;
        }

        public boolean handleResourceRemove(IResource rc) {
            if (ResourcePropertyHolder.this.isValidResource(rc)) {
                ResourcePropertyHolder.this.removeResourcePropertyMap(rc);
                return !ResourcePropertyHolder.this.fProjectOnly;
            }
            return false;
        }
    }
}

