/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.CommonBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.MapStorageElement;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BuilderFactory {
    private static final String PREFIX = "org.eclipse.cdt.make.core";
    static final String BUILD_COMMAND = "org.eclipse.cdt.make.core.buildCommand";
    static final String BUILD_LOCATION = "org.eclipse.cdt.make.core.buildLocation";
    static final String STOP_ON_ERROR = "org.eclipse.cdt.make.core.stopOnError";
    static final String USE_DEFAULT_BUILD_CMD = "org.eclipse.cdt.make.core.useDefaultBuildCmd";
    static final String BUILD_TARGET_AUTO = "org.eclipse.cdt.make.core.autoBuildTarget";
    static final String BUILD_TARGET_INCREMENTAL = "org.eclipse.cdt.make.core.incrementalBuildTarget";
    static final String BUILD_TARGET_FULL = "org.eclipse.cdt.make.core.fullBuildTarget";
    static final String BUILD_TARGET_CLEAN = "org.eclipse.cdt.make.core.cleanBuildTarget";
    static final String BUILD_FULL_ENABLED = "org.eclipse.cdt.make.core.enableFullBuild";
    static final String BUILD_CLEAN_ENABLED = "org.eclipse.cdt.make.core.enableCleanBuild";
    static final String BUILD_INCREMENTAL_ENABLED = "org.eclipse.cdt.make.core.enabledIncrementalBuild";
    static final String BUILD_AUTO_ENABLED = "org.eclipse.cdt.make.core.enableAutoBuild";
    static final String BUILD_ARGUMENTS = "org.eclipse.cdt.make.core.buildArguments";
    static final String ENVIRONMENT = "org.eclipse.cdt.make.core.environment";
    static final String BUILD_APPEND_ENVIRONMENT = "org.eclipse.cdt.make.core.append_environment";
    static final String CONTENTS = "org.eclipse.cdt.make.core.contents";
    static final String CONTENTS_BUILDER = "org.eclipse.cdt.make.core.builder";
    static final String CONTENTS_BUILDER_CUSTOMIZATION = "org.eclipse.cdt.make.core.builderCustomization";
    static final String CONTENTS_CONFIGURATION_IDS = "org.eclipse.cdt.make.core.configurationIds";
    static final String CONTENTS_ACTIVE_CFG_SETTINGS = "org.eclipse.cdt.make.core.activeConfigSettings";
    static final String CONFIGURATION_IDS = "org.eclipse.cdt.make.core.configurationIds";
    static final IBuilder[] EMPTY_BUILDERS_ARRAY = new IBuilder[0];
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final IConfiguration[] EMPTY_CFG_ARAY = new IConfiguration[0];
    public static final int CMD_UNDEFINED = -1;
    public static final int NO_CHANGES = 0;
    public static final int CMD_CHANGED = 1;

    public static Map createBuildArgs(IConfiguration[] cfgs, IBuilder builder) {
        Map map = BuilderFactory.builderToMap(builder);
        BuilderFactory.cfgsToMap(cfgs, map);
        map.put(CONTENTS, CONTENTS_BUILDER);
        return map;
    }

    public static Map createBuildArgs(IConfiguration[] cfgs) {
        HashMap<String, String> map = new HashMap<String, String>();
        BuilderFactory.cfgsToMap(cfgs, map);
        map.put(CONTENTS, "org.eclipse.cdt.make.core.configurationIds");
        return map;
    }

    private static Map cfgIdsToMap(String[] ids, Map map) {
        map.put("org.eclipse.cdt.make.core.configurationIds", MapStorageElement.encodeList(Arrays.asList(ids)));
        return map;
    }

    private static String[] cfgIdsFromMap(Map map) {
        String idsString = (String)map.get("org.eclipse.cdt.make.core.configurationIds");
        if (idsString != null) {
            List<String> list = MapStorageElement.decodeList(idsString);
            return list.toArray(new String[list.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    private static IConfiguration[] configsFromMap(Map map, IManagedBuildInfo info) {
        String[] ids = BuilderFactory.cfgIdsFromMap(map);
        if (ids.length == 0) {
            IConfiguration cfg = info.getDefaultConfiguration();
            if (cfg != null) {
                return new IConfiguration[]{cfg};
            }
            return EMPTY_CFG_ARAY;
        }
        IManagedProject mProj = info.getManagedProject();
        if (mProj != null) {
            return BuilderFactory.idsToConfigurations(ids, mProj.getConfigurations());
        }
        return EMPTY_CFG_ARAY;
    }

    private static IConfiguration[] idsToConfigurations(String[] ids, IConfiguration[] allCfgs) {
        ArrayList<IConfiguration> list = new ArrayList<IConfiguration>(ids.length);
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            int j = 0;
            while (j < allCfgs.length) {
                if (allCfgs[j].getId().equals(id)) {
                    list.add(allCfgs[j]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new IConfiguration[list.size()]);
    }

    private static Map cfgsToMap(IConfiguration[] cfgs, Map map) {
        String[] ids = BuilderFactory.getCfgIds(cfgs);
        return BuilderFactory.cfgIdsToMap(ids, map);
    }

    private static String[] getCfgIds(IConfiguration[] cfgs) {
        String[] ids = new String[cfgs.length];
        int i = 0;
        while (i < cfgs.length) {
            ids[i] = cfgs[i].getId();
            ++i;
        }
        return ids;
    }

    private static Map builderToMap(IBuilder builder) {
        MapStorageElement el = new MapStorageElement("", null);
        ((Builder)builder).serialize(el, false);
        return el.toStringMap();
    }

    private static Map builderBuildArgsMap(IBuilder builder) {
        BuildArgsStorageElement el = new BuildArgsStorageElement("", null);
        ((Builder)builder).serializeRawData(el);
        Boolean d = builder.isDefaultBuildCmd();
        ((MapStorageElement)el).setAttribute(USE_DEFAULT_BUILD_CMD, d.toString());
        Map<String, String> map = el.toStringMap();
        map.put(CONTENTS, CONTENTS_ACTIVE_CFG_SETTINGS);
        return map;
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, String builderId) throws CoreException {
        IBuilder builder = cfg.getBuilder();
        if (!builderId.equals(builder.getId())) {
            builder = ManagedBuildManager.getExtensionBuilder(builderId);
        }
        if (builder != null) {
            return BuilderFactory.createCustomBuilder(cfg, builder);
        }
        throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ManagedMakeMessages.getResourceString("BuilderFactory.1"), null));
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, IBuilder base) {
        String subName = base.getName();
        String subId = base.getSuperClass() != null ? ManagedBuildManager.calculateChildId(base.getSuperClass().getId(), null) : ManagedBuildManager.calculateChildId(base.getId(), null);
        return new Builder(cfg.getToolChain(), subId, subName, (Builder)base);
    }

    public static IBuilder createBuilderFromCommand(IConfiguration cfg, ICommand command) {
        Map args = command.getArguments();
        if (!args.containsKey("id")) {
            args.put("id", ManagedBuildManager.calculateChildId(command.getBuilderName(), null));
        }
        return BuilderFactory.createBuilder(cfg, args, cfg.getBuilder() != null);
    }

    public static IBuilder createBuilderForEclipseBuilder(IConfiguration cfg, String eclipseBuilderID) throws CoreException {
        IProject project = cfg.getOwner().getProject();
        ICommand command = BuilderFactory.getBuildSpec(project.getDescription(), eclipseBuilderID);
        if (command == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, String.valueOf(ManagedMakeMessages.getResourceString("BuildInfoFactory.Missing_Builder")) + eclipseBuilderID, null));
        }
        return BuilderFactory.createBuilderFromCommand(cfg, command);
    }

    public static ICommand getBuildSpec(IProjectDescription description, String builderID) {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    private static IBuilder createBuilder(IConfiguration cfg, Map args, boolean customization) {
        Builder builder;
        IToolChain tCh = cfg.getToolChain();
        IBuilder cfgBuilder = cfg.getEditableBuilder();
        if (customization) {
            builder = (Builder)BuilderFactory.createCustomBuilder(cfg, cfgBuilder);
            String tmp = (String)args.get("org.eclipse.cdt.core.errorOutputParser");
            if (tmp != null && tmp.length() == 0) {
                args.remove("org.eclipse.cdt.core.errorOutputParser");
            }
            if ((tmp = (String)args.get(USE_DEFAULT_BUILD_CMD)) != null) {
                if (Boolean.valueOf(tmp).equals(Boolean.TRUE)) {
                    args.remove(IMakeCommonBuildInfo.BUILD_COMMAND);
                    args.remove(IMakeCommonBuildInfo.BUILD_ARGUMENTS);
                } else {
                    args.put("ignoreErrCmd", "");
                    args.put("parallelBuildCmd", "");
                }
            }
            BuildArgsStorageElement el = new BuildArgsStorageElement(args, null);
            builder.loadFromProject(el);
        } else {
            if (args.get("id") == null) {
                args.put("id", ManagedBuildManager.calculateChildId(cfg.getId(), null));
            }
            BuildArgsStorageElement el = new BuildArgsStorageElement(args, null);
            builder = new Builder(tCh, el, ManagedBuildManager.getVersion().toString());
        }
        return builder;
    }

    public static IBuilder[] createBuilders(IProject project, Map args) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IBuilder[] builders = null;
        if (info != null) {
            if (args == null) {
                IConfiguration cfg = info.getDefaultConfiguration();
                IBuilder builder = cfg.getEditableBuilder();
                builders = new IBuilder[]{builder};
            } else {
                IConfiguration[] cfgs;
                String type = (String)args.get(CONTENTS);
                if (type == null || CONTENTS_BUILDER_CUSTOMIZATION.equals(type)) {
                    IConfiguration cfg = info.getDefaultConfiguration();
                    IBuilder builder = args.size() == 0 ? cfg.getEditableBuilder() : BuilderFactory.createBuilder(cfg, args, true);
                    builders = new IBuilder[]{builder};
                } else if (CONTENTS_ACTIVE_CFG_SETTINGS.equals(type)) {
                    IConfiguration cfg = info.getDefaultConfiguration();
                    IBuilder builder = cfg.getEditableBuilder();
                    builders = new IBuilder[]{builder};
                } else if (CONTENTS_BUILDER.equals(type)) {
                    IConfiguration[] cfgs2 = BuilderFactory.configsFromMap(args, info);
                    if (cfgs2.length != 0) {
                        ArrayList<IBuilder> list = new ArrayList<IBuilder>(cfgs2.length);
                        int i = 0;
                        while (i < cfgs2.length) {
                            IBuilder builder = BuilderFactory.createBuilder(cfgs2[i], args, false);
                            if (builder != null) {
                                list.add(builder);
                            }
                            ++i;
                        }
                        builders = list.toArray(new IBuilder[list.size()]);
                    }
                } else if ("org.eclipse.cdt.make.core.configurationIds".equals(type) && (cfgs = BuilderFactory.configsFromMap(args, info)).length != 0) {
                    ArrayList<IBuilder> list = new ArrayList<IBuilder>(cfgs.length);
                    int i = 0;
                    while (i < cfgs.length) {
                        list.add(cfgs[i].getEditableBuilder());
                        ++i;
                    }
                    builders = list.toArray(new IBuilder[list.size()]);
                }
            }
        }
        if (builders != null) {
            return builders;
        }
        return EMPTY_BUILDERS_ARRAY;
    }

    public static int applyBuilder(IProjectDescription eDes, IBuilder builder) {
        return BuilderFactory.applyBuilder(eDes, CommonBuilder.BUILDER_ID, builder);
    }

    public static int applyBuilder(IProjectDescription eDes, String eBuilderId, IBuilder builder) {
        ICommand cmd = ManagedCProjectNature.getBuildSpec(eDes, eBuilderId);
        if (cmd == null) {
            return -1;
        }
        if (BuilderFactory.applyBuilder(cmd, builder)) {
            ManagedCProjectNature.setBuildSpec(eDes, cmd);
            return 1;
        }
        return 0;
    }

    public static boolean applyBuilder(ICommand cmd, IBuilder builder) {
        Map map;
        Map oldMap = cmd.getArguments();
        if (oldMap.equals(map = BuilderFactory.builderBuildArgsMap(builder))) {
            return false;
        }
        cmd.setArguments(map);
        cmd.setBuilding(9, builder.isAutoBuildEnable());
        cmd.setBuilding(6, builder.isFullBuildEnabled());
        cmd.setBuilding(10, builder.isIncrementalBuildEnabled());
        cmd.setBuilding(15, builder.isCleanBuildEnabled());
        return true;
    }

    private static class BuildArgsStorageElement
    extends MapStorageElement {
        public BuildArgsStorageElement(Map map, MapStorageElement parent) {
            super(map, parent);
        }

        public BuildArgsStorageElement(String name, MapStorageElement parent) {
            super(name, parent);
        }

        public String getAttribute(String name) {
            String value = super.getAttribute(name);
            if (value == null) {
                String[] keys = Builder.toBuildAttributes(name);
                int i = 0;
                while (i < keys.length) {
                    value = super.getAttribute(keys[i]);
                    if (value != null) break;
                    ++i;
                }
            }
            return value;
        }

        public void setAttribute(String name, String value) {
            String attrName;
            String[] names = Builder.toBuildAttributes(name);
            String string = attrName = names.length != 0 ? names[names.length - 1] : null;
            if (attrName == null && BuilderFactory.USE_DEFAULT_BUILD_CMD.equals(name)) {
                attrName = BuilderFactory.USE_DEFAULT_BUILD_CMD;
            }
            if (attrName != null) {
                super.setAttribute(attrName, value);
            }
        }

        protected MapStorageElement createChildElement(Map childMap) {
            return new BuildArgsStorageElement(childMap, (MapStorageElement)this);
        }

        protected MapStorageElement createChildElement(String name) {
            return new BuildArgsStorageElement(name, (MapStorageElement)this);
        }
    }
}

