/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildProperties;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.IBuildPropertyChangeListener;
import org.eclipse.core.runtime.CoreException;

public class BuildObjectProperties
extends BuildProperties
implements IBuildObjectProperties {
    private IBuildPropertiesRestriction fRestriction;
    private IBuildPropertyChangeListener fListener;

    public BuildObjectProperties(IBuildPropertiesRestriction restriction, IBuildPropertyChangeListener listener) {
        this.fRestriction = restriction;
        this.fListener = listener;
    }

    public BuildObjectProperties(BuildObjectProperties properties, IBuildPropertiesRestriction restriction, IBuildPropertyChangeListener listener) {
        super(properties);
        this.fRestriction = restriction;
        this.fListener = listener;
    }

    public BuildObjectProperties(String properties, IBuildPropertiesRestriction restriction, IBuildPropertyChangeListener listener) {
        super(properties);
        this.fRestriction = restriction;
        this.fListener = listener;
    }

    public IBuildPropertyType[] getSupportedTypes() {
        IBuildPropertyType[] types = BuildPropertyManager.getInstance().getPropertyTypes();
        if (this.fRestriction != null && types.length != 0) {
            ArrayList<IBuildPropertyType> list = new ArrayList<IBuildPropertyType>(types.length);
            int i = 0;
            while (i < types.length) {
                if (this.fRestriction.supportsType(types[i].getId())) {
                    list.add(types[i]);
                }
                ++i;
            }
            types = list.toArray(new IBuildPropertyType[list.size()]);
        }
        return types;
    }

    public IBuildPropertyValue[] getSupportedValues(String typeId) {
        IBuildPropertyType type = BuildPropertyManager.getInstance().getPropertyType(typeId);
        if (type != null) {
            IBuildPropertyValue[] values = type.getSupportedValues();
            if (this.fRestriction != null && values.length != 0) {
                ArrayList<IBuildPropertyValue> list = new ArrayList<IBuildPropertyValue>(values.length);
                int i = 0;
                while (i < values.length) {
                    if (this.fRestriction.supportsValue(type.getId(), values[i].getId())) {
                        list.add(values[i]);
                    }
                    ++i;
                }
                return list.toArray(new IBuildPropertyValue[list.size()]);
            }
        }
        return new IBuildPropertyValue[0];
    }

    public boolean supportsType(String id) {
        return this.fRestriction.supportsType(id);
    }

    public boolean supportsValue(String typeId, String valueId) {
        return this.fRestriction.supportsValue(typeId, valueId);
    }

    public void clear() {
        super.clear();
        this.fListener.propertiesChanged();
    }

    public IBuildProperty removeProperty(String id) {
        IBuildProperty property = super.removeProperty(id);
        if (property != null) {
            this.fListener.propertiesChanged();
        }
        return property;
    }

    IBuildProperty internalSetProperty(String propertyId, String propertyValue) throws CoreException {
        return super.setProperty(propertyId, propertyValue);
    }

    public IBuildProperty setProperty(String propertyId, String propertyValue) throws CoreException {
        IBuildProperty property = super.setProperty(propertyId, propertyValue);
        this.fListener.propertiesChanged();
        return property;
    }

    public String[] getRequiredTypeIds() {
        return this.fRestriction.getRequiredTypeIds();
    }

    public boolean requiresType(String typeId) {
        return this.fRestriction.requiresType(typeId);
    }

    public String[] getSupportedTypeIds() {
        return this.fRestriction.getSupportedTypeIds();
    }

    public String[] getSupportedValueIds(String typeId) {
        return this.fRestriction.getSupportedValueIds(typeId);
    }
}

