/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class GenDirInfo {
    private IProject fProject;
    private IPath fProjPath;
    private Set fDirPathSet = new HashSet();

    public GenDirInfo(IProject proj) {
        this.fProject = proj;
        this.fProjPath = proj.getFullPath();
    }

    public GenDirInfo(IConfiguration cfg) {
        this(cfg.getOwner().getProject());
    }

    public void createDir(IBuildResource rc, IProgressMonitor monitor) {
        IPath path = rc.getFullPath();
        if (path != null && this.fProjPath.isPrefixOf(path)) {
            path = path.removeLastSegments(1).removeFirstSegments(1);
            this.createDir(path, monitor);
        }
    }

    public void createIfProjectDir(IPath fullPath, IProgressMonitor monitor) {
        if (fullPath.segmentCount() > this.fProjPath.segmentCount() && this.fProjPath.isPrefixOf(fullPath)) {
            this.createDir(fullPath.removeFirstSegments(this.fProjPath.segmentCount()), monitor);
        }
    }

    protected void createDir(IPath path, IProgressMonitor monitor) {
        block3: {
            IFolder folder;
            if (path.segmentCount() > 0 && this.fDirPathSet.add(path) && !(folder = this.fProject.getFolder(path)).exists()) {
                this.createDir(path.removeLastSegments(1), monitor);
                try {
                    folder.create(true, true, monitor);
                    folder.setDerived(true);
                }
                catch (CoreException e) {
                    if (!DbgUtil.DEBUG) break block3;
                    DbgUtil.trace("GenDirInfo: failed to create dir: " + e.getLocalizedMessage());
                }
            }
        }
    }
}

