/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.internal.launch;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.debug.DebugUtilities;
import com.atmel.avr32.debug.IUpdate;
import com.atmel.avr32.debug.ui.internal.FileDialog;
import com.atmel.avr32.debug.ui.internal.launch.AbstractCommonConfigurationTab;
import com.atmel.avr32.debug.ui.internal.launch.Messages;
import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.target.tool.model.Capability;
import com.atmel.avr32.target.tool.model.TargetInterfaceDescription;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class StandaloneMainTab
extends AbstractCommonConfigurationTab {
    private static final String BIN = "bin";
    private static final String CONTEXT_HELP_ID = "com.atmel.avr32.doc.guide.launch_standalone";
    private static final String ELF = "elf";
    protected static final String EMPTY_STRING = "";
    private static WorkbenchLabelProvider fLabelProvider;
    Button fEraseChip = null;
    Button fEraseNone = null;
    Button fEraseSectors = null;
    Text fFile = null;
    Button fFileSelect = null;
    Combo fInterfaceSelector = null;
    private final WidgetListener fListener = new WidgetListener();
    Text fOffset = null;
    Text fPostFuses = null;
    Button fPostFusesSelect = null;
    Text fPreFuses = null;
    Button fPreFusesSelect = null;
    public Text fProject = null;
    Button fProjectSelect = null;
    Button fReset = null;
    Button fRun = null;
    Button fRunFromResetVector = null;
    Button fSuppressProgramming = null;
    ITarget[] fTargets;
    Combo fTargetSelector = null;
    Composite fusesGroup = null;
    Button fVerify = null;
    private Button fEnableFlashVault;
    private Button fDisableSecuredDebugging;
    private Composite fFlashVaultGroup;

    protected void addLabel(Composite composite, String text) {
        Label fHostLabel = new Label(composite, 0);
        fHostLabel.setText(text);
        fHostLabel.setLayoutData((Object)new GridData(256));
    }

    protected IResource chooseFile(String root, String[] extensions) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(root);
        FileDialog dialog = new FileDialog(this.getShell(), 4, Messages.StandaloneMainTab_0, (IResource)project, true, extensions, null);
        if (dialog.open() == 0) {
            return dialog.getSingleResult();
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), CONTEXT_HELP_ID);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        Label fProjectLabel = new Label(comp, 0);
        fProjectLabel.setText(Messages.MainTab_Project);
        fProjectLabel.setLayoutData((Object)new GridData(256));
        this.fProject = new Text(comp, 2052);
        this.fProject.setLayoutData((Object)new GridData(768));
        this.fProject.addModifyListener((ModifyListener)this.fListener);
        this.fProjectSelect = new Button(comp, 8);
        this.fProjectSelect.setText(Messages.MainTab_Browse);
        this.fProjectSelect.setLayoutData((Object)new GridData(256));
        this.fProjectSelect.addSelectionListener((SelectionListener)this.fListener);
        Label fFileLabel = new Label(comp, 0);
        fFileLabel.setText(Messages.MainTab_File);
        fFileLabel.setLayoutData((Object)new GridData(256));
        this.fFile = new Text(comp, 2052);
        this.fFile.setLayoutData((Object)new GridData(768));
        this.fFile.addModifyListener((ModifyListener)this.fListener);
        this.fFileSelect = new Button(comp, 8);
        this.fFileSelect.setText(Messages.MainTab_Browse);
        this.fFileSelect.setLayoutData((Object)new GridData(256));
        this.fFileSelect.addSelectionListener((SelectionListener)this.fListener);
        Label fTargetLabel = new Label(comp, 0);
        fTargetLabel.setText(Messages.MainTab_Target);
        fTargetLabel.setLayoutData((Object)new GridData(256));
        this.fTargetSelector = new Combo(comp, 8);
        this.fTargetSelector.setLayoutData((Object)new GridData(768));
        this.fTargets = TargetPlugin.getTargetManager().getTargets();
        int i = 0;
        while (i < this.fTargets.length) {
            this.fTargetSelector.add(this.fTargets[i].getName());
            ++i;
        }
        this.fTargetSelector.addSelectionListener((SelectionListener)this.fListener);
        this.addLabel(comp, EMPTY_STRING);
        this.addLabel(comp, Messages.StandaloneMainTab_1);
        this.fInterfaceSelector = new Combo(comp, 12);
        this.fInterfaceSelector.setLayoutData((Object)new GridData(768));
        this.fInterfaceSelector.addSelectionListener((SelectionListener)this.fListener);
        Composite c2 = new Composite(comp, 0);
        GridLayout c2Layout = new GridLayout();
        c2Layout.numColumns = 2;
        c2.setLayout((Layout)c2Layout);
        c2.setLayoutData((Object)new GridData(4, 1, true, true, 3, 1));
        this.createEraseGroup(c2);
        this.createProgrammingGroup(c2);
        this.createRunGroup(c2);
        this.createFuseGroup(c2);
        this.createFlashVaultGroup(c2);
    }

    private GridData createEraseGroup(Composite comp) {
        Composite erase = this.createGroup(comp, 1, 1, Messages.StandaloneMainTab_EraseOptions);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 1;
        this.fEraseNone = this.createRadioButton(erase, Messages.StandaloneMainTab_NoErase);
        this.fEraseNone.setLayoutData((Object)gd);
        this.fEraseNone.addSelectionListener((SelectionListener)this.fListener);
        this.fEraseSectors = this.createRadioButton(erase, Messages.LaunchOptionErase);
        this.fEraseSectors.setLayoutData((Object)gd);
        this.fEraseSectors.addSelectionListener((SelectionListener)this.fListener);
        this.fEraseChip = this.createRadioButton(erase, Messages.StandaloneMainTab_JTAGErase);
        this.fEraseChip.setLayoutData((Object)gd);
        this.fEraseChip.addSelectionListener((SelectionListener)this.fListener);
        return gd;
    }

    private void createFuseGroup(Composite comp) {
        this.fusesGroup = this.createGroup(comp, 3, 1, Messages.StandaloneMainTab_4);
        Label fPreFusesLabel = new Label(this.fusesGroup, 0);
        fPreFusesLabel.setText(Messages.StandaloneMainTab_5);
        this.fPreFuses = new Text(this.fusesGroup, 2052);
        this.fPreFuses.setLayoutData((Object)new GridData(768));
        this.fPreFuses.addModifyListener((ModifyListener)this.fListener);
        this.fPreFusesSelect = this.createPushButton(this.fusesGroup, Messages.MainTab_Browse, null);
        this.fPreFusesSelect.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IResource fileName = StandaloneMainTab.this.chooseFile(StandaloneMainTab.this.fProject.getText(), new String[]{"fuses"});
                if (fileName == null) {
                    return;
                }
                StandaloneMainTab.this.fPreFuses.setText(fileName.getProjectRelativePath().toString());
            }
        });
        Label fPostFusesLabel = new Label(this.fusesGroup, 0);
        fPostFusesLabel.setText(Messages.StandaloneMainTab_6);
        this.fPostFuses = new Text(this.fusesGroup, 2052);
        this.fPostFuses.setLayoutData((Object)new GridData(768));
        this.fPostFuses.addModifyListener((ModifyListener)this.fListener);
        this.fPostFusesSelect = this.createPushButton(this.fusesGroup, Messages.MainTab_Browse, null);
        this.fPostFusesSelect.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IResource fileName = StandaloneMainTab.this.chooseFile(StandaloneMainTab.this.fProject.getText(), new String[]{"fuses"});
                if (fileName == null) {
                    return;
                }
                StandaloneMainTab.this.fPostFuses.setText(fileName.getProjectRelativePath().toString());
            }
        });
    }

    private Composite createGroup(Composite parent, int width, int span, String label) {
        Group composite = new Group(parent, 4);
        if (label != null) {
            composite.setText(label);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = width;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createProgrammingGroup(Composite comp) {
        Composite group = this.createGroup(comp, 1, 1, Messages.LaunchOptions);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 1;
        this.fSuppressProgramming = this.createCheckButton(group, Messages.StandaloneMainTab_SuppressProgramming);
        this.fSuppressProgramming.setLayoutData((Object)gd);
        this.fSuppressProgramming.addSelectionListener((SelectionListener)this.fListener);
        this.fVerify = this.createCheckButton(group, Messages.LaunchOptionVerify);
        this.fVerify.setLayoutData((Object)gd);
        this.fVerify.addSelectionListener((SelectionListener)this.fListener);
        this.fVerify.setLayoutData((Object)gd);
    }

    private void createFlashVaultGroup(Composite comp) {
        this.fFlashVaultGroup = this.createGroup(comp, 1, 1, "Secure code");
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 1;
        this.fEnableFlashVault = this.createCheckButton(this.fFlashVaultGroup, "Enable FlashVault after programming");
        this.fEnableFlashVault.setLayoutData((Object)gd);
        this.fEnableFlashVault.addSelectionListener((SelectionListener)this.fListener);
        this.fDisableSecuredDebugging = this.createCheckButton(this.fFlashVaultGroup, "Disable debugging in secured area");
        this.fDisableSecuredDebugging.setLayoutData((Object)gd);
        this.fDisableSecuredDebugging.addSelectionListener((SelectionListener)this.fListener);
        this.fDisableSecuredDebugging.setLayoutData((Object)gd);
    }

    private void createRunGroup(Composite comp) {
        Composite group = this.createGroup(comp, 2, 1, Messages.StandaloneMainTab_RunOptions);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 1;
        this.fRunFromResetVector = this.createCheckButton(group, Messages.StandaloneMainTab_2);
        this.fRunFromResetVector.addSelectionListener((SelectionListener)this.fListener);
        this.fOffset = new Text(group, 2052);
        this.fOffset.setLayoutData((Object)new GridData(768));
        this.fOffset.addModifyListener((ModifyListener)this.fListener);
        this.fOffset.setToolTipText(Messages.StandaloneMainTab_3);
        this.fReset = this.createCheckButton(group, Messages.LaunchOptionReset);
        this.fReset.addSelectionListener((SelectionListener)this.fListener);
        this.fRun = this.createCheckButton(group, Messages.LaunchOptionRun);
        this.fRun.setLayoutData((Object)gd);
        this.fRun.addSelectionListener((SelectionListener)this.fListener);
    }

    protected IBinary[] getBinaryFiles(final ICProject cproject) {
        if (cproject == null || !cproject.exists()) {
            return null;
        }
        Display display = this.getShell() == null ? LaunchUIPlugin.getShell().getDisplay() : this.getShell().getDisplay();
        final Object[] ret = new Object[1];
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = cproject.getBinaryContainer().getBinaries();
                }
                catch (CModelException e) {
                    LaunchUIPlugin.errorDialog((String)"Launch UI internal error", (Throwable)e);
                }
            }
        });
        return (IBinary[])ret[0];
    }

    public IResource getFile() {
        if (this.fProject.getText().length() > 0 && this.fFile.getText().length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProject.getText()).findMember(this.fFile.getText());
        }
        return null;
    }

    public String getId() {
        return "avr32.launch.main";
    }

    public String getName() {
        return Messages.MainTab_Title;
    }

    public ITarget getTarget() {
        int index = this.fTargetSelector.indexOf(this.fTargetSelector.getText());
        if (index != -1) {
            int serial = this.fTargets[index].getId();
            ITarget td = TargetPlugin.getTargetManager().getTarget(serial);
            return td;
        }
        return null;
    }

    public TargetInterfaceDescription getTargetInterface() {
        TargetInterfaceDescription ti = TargetPlugin.getDefault().getTargetInterfaceDescriptor(this.fInterfaceSelector.getText());
        return ti;
    }

    @Override
    protected ILabelProvider getWorkbenchLabelProvider() {
        if (fLabelProvider == null) {
            fLabelProvider = new WorkbenchLabelProvider();
        }
        return fLabelProvider;
    }

    private void handleFileButtonSelected() {
        IResource fileName = this.chooseFile(this.fProject.getText(), new String[]{BIN, ELF});
        if (fileName == null) {
            return;
        }
        this.fFile.setText(fileName.getProjectRelativePath().toString());
    }

    protected void handleProjectButtonSelected() {
        try {
            IProject project = this.chooseProject("avr32.managedbuild.target.gnu.exe");
            if (project == null) {
                return;
            }
            String projectName = project.getName();
            this.fProject.setText(projectName);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.updateProjectFromConfig(configuration);
            this.updateFileFromConfig(configuration);
            this.updateSTKFromConfig(configuration);
            this.updateFusesFromConfig(configuration);
            this.updateFlashVaultFromConfig(configuration);
            this.fOffset.setText(configuration.getAttribute("AVR32_ATTR_OFFSET", EMPTY_STRING));
            AVR32DebugPlugin.EraseMethod em = AVR32DebugPlugin.EraseMethod.valueOf((String)configuration.getAttribute("AVR32_ATTR_ERASEMETHOD", AVR32DebugPlugin.EraseMethod.ERASE_SECTORS.toString()));
            switch (em) {
                case ERASE_NONE: {
                    this.fEraseNone.setSelection(true);
                    break;
                }
                case ERASE_SECTORS: {
                    this.fEraseSectors.setSelection(true);
                    break;
                }
                case ERASE_CHIP: {
                    this.fEraseChip.setSelection(true);
                }
            }
            this.fReset.setSelection(configuration.getAttribute("AVR32_ATTR_FILE_RESET", false));
            this.fRun.setSelection(configuration.getAttribute("AVR32_ATTR_FILE_RUN", false));
            this.fVerify.setSelection(configuration.getAttribute("AVR32_ATTR_FILE_VERIFY", false));
            this.fSuppressProgramming.setSelection(configuration.getAttribute("AVR32_ATTR_SUPPRESS_PROGRAMMING", false));
            this.fRunFromResetVector.setSelection(configuration.getAttribute("AVR32_ATTR_RESETVECTOR", true));
            this.updateInterfacesList();
            String mode = this.getLaunchConfigurationDialog().getMode();
            String interfaceTypeAttribute = mode.equals("debug") ? "AVR32_ATTR_DEBUG_INTERFACE" : "AVR32_ATTR_RUN_INTERFACE";
            this.fInterfaceSelector.setText(configuration.getAttribute(interfaceTypeAttribute, "AVR32 Program/GDB-Proxy"));
            this.fOffset.setEnabled(!this.fRunFromResetVector.getSelection());
            this.updateFusesFields();
            this.updateFlashVaultFields();
            this.updatePartFields();
            this.updateButtons();
            this.updateDependingTabs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        block19: {
            Part part;
            ITarget td;
            block18: {
                IProject project;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                String projectName;
                                block13: {
                                    try {
                                        projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
                                        if (!projectName.equals(EMPTY_STRING) && ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) break block13;
                                        this.setErrorMessage(Messages.StandaloneMainTab_Error_InvalidProject);
                                        return false;
                                    }
                                    catch (CoreException e) {
                                        e.printStackTrace();
                                        return false;
                                    }
                                }
                                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                                String fileName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
                                if (!fileName.equals(EMPTY_STRING) && project.getFile(fileName).exists()) break block14;
                                this.setErrorMessage(Messages.StandaloneMainTab_Error_InvalidBinary);
                                return false;
                            }
                            int id = config.getAttribute("AVR32_ATTR_STK_ID", -1);
                            td = TargetPlugin.getTargetManager().getTarget(id);
                            if (td != null) break block15;
                            this.setErrorMessage(Messages.StandaloneMainTab_Error_MissingTarget);
                            return false;
                        }
                        if (td.isValid()) break block16;
                        this.setErrorMessage(Messages.StandaloneMainTab_Error_InvalidTarget);
                        return false;
                    }
                    if (!td.isWorking()) break block17;
                    this.setMessage(Messages.StandaloneMainTab_Warning_TargetBusy);
                    return false;
                }
                part = TargetPlugin.getDefault().getPart(project);
                if (part != null) break block18;
                this.setErrorMessage(Messages.StandaloneMainTab_Error_NoMCU);
                return false;
            }
            if (part != null) {
                String mcu = part.getName();
                if (!mcu.equals(td.getCpu())) {
                    this.setMessage(Messages.StandaloneMainTab_Warning_MCUMismatch);
                } else {
                    this.setMessage(null);
                }
            }
            if (TargetPlugin.getDefault().getTargetInterfaces(td, this.getLaunchConfigurationDialog().getMode()).length != 0) break block19;
            this.setErrorMessage(MessageFormat.format(Messages.StandaloneMainTab_Error_NoLauncher, this.getLaunchConfigurationDialog().getMode().equals("run") ? "programming" : "debugging", td.getBoardName(), td.getAdapterName()));
            return false;
        }
        String mode = this.getLaunchConfigurationDialog().getMode();
        String adapter = EMPTY_STRING;
        String interfaceTypeAttribute = mode.equals("debug") ? "AVR32_ATTR_DEBUG_INTERFACE" : "AVR32_ATTR_RUN_INTERFACE";
        adapter = config.getAttribute(interfaceTypeAttribute, EMPTY_STRING);
        if (adapter.length() == 0) {
            this.setErrorMessage(Messages.StandaloneMainTab_Error_NoLaunchProvider);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (configuration == null) {
            return;
        }
        configuration.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProject.getText());
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fFile.getText());
        if (this.getFile() != null) {
            configuration.setAttribute("AVR32_ATTR_EXEPATH", this.getFile().getLocation().toPortableString());
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(this.fProject.getText());
            configuration.setMappedResources((IResource[])new IProject[]{project});
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int index = this.fTargetSelector.indexOf(this.fTargetSelector.getText());
        if (index != -1) {
            int serial = this.fTargets[index].getId();
            configuration.setAttribute("AVR32_ATTR_STK_ID", serial);
        }
        if (this.fEraseNone.getSelection()) {
            configuration.setAttribute("AVR32_ATTR_ERASEMETHOD", AVR32DebugPlugin.EraseMethod.ERASE_NONE.toString());
        }
        if (this.fEraseSectors.getSelection()) {
            configuration.setAttribute("AVR32_ATTR_ERASEMETHOD", AVR32DebugPlugin.EraseMethod.ERASE_SECTORS.toString());
        }
        if (this.fEraseChip.getSelection()) {
            configuration.setAttribute("AVR32_ATTR_ERASEMETHOD", AVR32DebugPlugin.EraseMethod.ERASE_CHIP.toString());
        }
        configuration.setAttribute("AVR32_ATTR_FILE_RESET", this.fReset.getSelection());
        configuration.setAttribute("AVR32_ATTR_FILE_RUN", this.fRun.getSelection());
        configuration.setAttribute("AVR32_ATTR_FILE_VERIFY", this.fVerify.getSelection());
        configuration.setAttribute("AVR32_ATTR_SUPPRESS_PROGRAMMING", this.fSuppressProgramming.getSelection());
        configuration.setAttribute("AVR32_ATTR_RESETVECTOR", this.fRunFromResetVector.getSelection());
        configuration.setAttribute("AVR32_ATTR_OFFSET", this.fOffset.getText());
        configuration.setAttribute("AVR32_ATTR_PRE_FUSES", this.fPreFuses.getText());
        configuration.setAttribute("AVR32_ATTR_POST_FUSES", this.fPostFuses.getText());
        configuration.setAttribute("process_factory_id", "com.atmel.avr32.debug.ProcessFactory");
        String mode = this.getLaunchConfigurationDialog().getMode();
        String interfaceTypeAttribute = mode.equals("debug") ? "AVR32_ATTR_DEBUG_INTERFACE" : "AVR32_ATTR_RUN_INTERFACE";
        configuration.setAttribute(interfaceTypeAttribute, this.fInterfaceSelector.getText());
        configuration.setAttribute("AVR32_ATTR_FLASHVAULT", this.fEnableFlashVault.getSelection());
        configuration.setAttribute("AVR32_ATTR_DISABLE_DBG", this.fDisableSecuredDebugging.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ArrayList results = new ArrayList();
        DebugUtilities.findBinaries((IResource)DebugUITools.getSelectedResource(), results);
        if (results.size() > 0) {
            DebugUtilities.initStandaloneConfiguration((IBinary)((IBinary)results.get(0)), null, (ILaunchConfigurationWorkingCopy)configuration, (String)this.getLaunchConfigurationDialog().getMode());
        } else {
            DebugUtilities.initStandaloneConfiguration(null, null, (ILaunchConfigurationWorkingCopy)configuration, (String)this.getLaunchConfigurationDialog().getMode());
        }
    }

    private void setEnabled(Composite group, boolean enabled) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
        group.setEnabled(enabled);
    }

    private void updateButtons() {
        Capability capability;
        TargetInterfaceDescription tid = TargetPlugin.getDefault().getTargetInterfaceDescriptor(this.fInterfaceSelector.getText());
        if (tid != null && (capability = tid.getCapability(TargetPlugin.CapabilityId.debug)) != null) {
            ArrayList requires = capability.getRequires();
            for (Capability requireCap : requires) {
                if (requireCap.getId().equals(TargetPlugin.CapabilityId.simulator)) {
                    this.fEraseSectors.setEnabled(false);
                    this.fVerify.setEnabled(false);
                    this.fSuppressProgramming.setEnabled(false);
                    this.fReset.setEnabled(false);
                    this.fRun.setEnabled(false);
                    return;
                }
                this.fEraseSectors.setEnabled(true);
                this.fVerify.setEnabled(true);
                this.fSuppressProgramming.setEnabled(true);
                this.fReset.setEnabled(true);
                this.fRun.setEnabled(true);
            }
        }
        if (this.fSuppressProgramming.getSelection()) {
            this.fEraseNone.setSelection(true);
            this.fEraseChip.setSelection(false);
            this.fEraseSectors.setSelection(false);
            this.fEraseChip.setEnabled(false);
            this.fEraseSectors.setEnabled(false);
            this.setEnabled(this.fusesGroup, false);
            this.fVerify.setEnabled(false);
        } else {
            this.fEraseChip.setEnabled(true);
            this.fEraseSectors.setEnabled(true);
            this.setEnabled(this.fusesGroup, true);
            this.fVerify.setEnabled(true);
        }
        this.fOffset.setEnabled(!this.fRunFromResetVector.getSelection());
    }

    private void updateDependingTabs() {
        ILaunchConfigurationTab[] tabs;
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = this.getLaunchConfigurationDialog().getTabs();
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof IUpdate) {
                ((IUpdate)tab).update();
            }
            ++n2;
        }
    }

    protected void updateFileFromConfig(ILaunchConfiguration config) {
        String fileName = EMPTY_STRING;
        try {
            fileName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        this.fFile.setText(fileName);
    }

    private void updateFusesFields() {
        int index;
        TargetInterfaceDescription tid = TargetPlugin.getDefault().getTargetInterfaceDescriptor(this.fInterfaceSelector.getText());
        if (tid != null && (index = this.fTargetSelector.indexOf(this.fTargetSelector.getText())) != -1) {
            int serial = this.fTargets[index].getId();
            ITarget td = TargetPlugin.getTargetManager().getTarget(serial);
            this.setEnabled(this.fusesGroup, TargetPlugin.getDefault().supportsCapability(tid, td, TargetPlugin.CapabilityId.fuses));
            return;
        }
        this.setEnabled(this.fusesGroup, false);
    }

    private void updateFlashVaultFields() {
        int index;
        TargetInterfaceDescription tid = TargetPlugin.getDefault().getTargetInterfaceDescriptor(this.fInterfaceSelector.getText());
        if (tid != null && (index = this.fTargetSelector.indexOf(this.fTargetSelector.getText())) != -1) {
            int serial = this.fTargets[index].getId();
            ITarget td = TargetPlugin.getTargetManager().getTarget(serial);
            this.setEnabled(this.fFlashVaultGroup, TargetPlugin.getDefault().supportsCapability(tid, td, TargetPlugin.CapabilityId.flashvault));
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProject.getText());
            if (p != null && ManagedbuildPlugin.isSecured((IProject)p)) {
                this.fEnableFlashVault.setSelection(true);
                this.fEnableFlashVault.setEnabled(false);
            }
            return;
        }
        this.setEnabled(this.fFlashVaultGroup, false);
    }

    private void updateFusesFromConfig(ILaunchConfiguration configuration) {
        String preFuses = EMPTY_STRING;
        String postFuses = EMPTY_STRING;
        try {
            preFuses = configuration.getAttribute("AVR32_ATTR_PRE_FUSES", EMPTY_STRING);
            postFuses = configuration.getAttribute("AVR32_ATTR_POST_FUSES", EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        this.fPreFuses.setText(preFuses);
        this.fPostFuses.setText(postFuses);
    }

    private void updateInterfacesList() {
        int index = this.fTargetSelector.indexOf(this.fTargetSelector.getText());
        if (index != -1) {
            int serial = this.fTargets[index].getId();
            ITarget td = TargetPlugin.getTargetManager().getTarget(serial);
            if (td != null) {
                TargetInterfaceDescription[] interfaces;
                this.fInterfaceSelector.removeAll();
                TargetInterfaceDescription[] targetInterfaceDescriptionArray = interfaces = TargetPlugin.getDefault().getTargetInterfaces(td, this.getLaunchConfigurationDialog().getMode());
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    TargetInterfaceDescription i = targetInterfaceDescriptionArray[n2];
                    this.fInterfaceSelector.add(i.getId());
                    ++n2;
                }
                if (interfaces.length == 1) {
                    this.fInterfaceSelector.select(0);
                }
            }
        }
    }

    private void updatePartFields() {
        int index;
        TargetInterfaceDescription tid;
        if (this.fRunFromResetVector.getSelection() && (tid = TargetPlugin.getDefault().getTargetInterfaceDescriptor(this.fInterfaceSelector.getText())) != null && (index = this.fTargetSelector.indexOf(this.fTargetSelector.getText())) != -1) {
            Part part;
            int serial = this.fTargets[index].getId();
            ITarget td = TargetPlugin.getTargetManager().getTarget(serial);
            if (td != null && (part = td.getPart()) != null) {
                this.fOffset.setText(part.getResetVector());
                return;
            }
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        this.fProject.setText(projectName);
    }

    protected void updateFlashVaultFromConfig(ILaunchConfiguration config) {
        try {
            this.fEnableFlashVault.setSelection(config.getAttribute("AVR32_ATTR_FLASHVAULT", false));
            this.fDisableSecuredDebugging.setSelection(config.getAttribute("AVR32_ATTR_DISABLE_DBG", false));
            IResource[] x = config.getMappedResources();
            if (x != null && ManagedbuildPlugin.isSecured((IProject)x[0].getProject())) {
                this.fEnableFlashVault.setSelection(true);
                this.fEnableFlashVault.setEnabled(false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void updateSTKFromConfig(ILaunchConfiguration config) {
        String stkName = EMPTY_STRING;
        try {
            int id = config.getAttribute("AVR32_ATTR_STK_ID", 0);
            ITarget td = TargetPlugin.getTargetManager().getTarget(id);
            if (td != null) {
                stkName = td.getName();
            }
        }
        catch (CoreException coreException) {}
        this.fTargetSelector.setText(stkName);
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            StandaloneMainTab.this.setErrorMessage(null);
            StandaloneMainTab.this.updateLaunchConfigurationDialog();
            if (e.widget.equals(StandaloneMainTab.this.fProject) || e.widget.equals(StandaloneMainTab.this.fFile)) {
                StandaloneMainTab.this.updateDependingTabs();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            StandaloneMainTab.this.setErrorMessage(null);
            Object source = e.getSource();
            if (source.equals(StandaloneMainTab.this.fProjectSelect)) {
                StandaloneMainTab.this.handleProjectButtonSelected();
            } else if (source.equals(StandaloneMainTab.this.fFileSelect)) {
                StandaloneMainTab.this.handleFileButtonSelected();
            }
            if (source.equals(StandaloneMainTab.this.fTargetSelector)) {
                StandaloneMainTab.this.updateInterfacesList();
                StandaloneMainTab.this.updateFusesFields();
                StandaloneMainTab.this.updateFlashVaultFields();
                StandaloneMainTab.this.updatePartFields();
                StandaloneMainTab.this.updateDependingTabs();
            }
            if (source.equals(StandaloneMainTab.this.fInterfaceSelector)) {
                StandaloneMainTab.this.updateFusesFields();
                StandaloneMainTab.this.updateFlashVaultFields();
            }
            StandaloneMainTab.this.updateButtons();
            StandaloneMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

