/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.internal.launch;

import com.atmel.avr32.debug.ui.internal.launch.Messages;
import com.atmel.avr32.target.TargetPlugin;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class StandaloneDebugOptionsTab
extends AbstractLaunchConfigurationTab {
    private static final String CONTEXT_HELP_ID = "com.atmel.avr32.doc.guide.launch_standalone";
    private static final String DEBUGGER_ID = "org.eclipse.cdt.debug.mi.core.GDBServerCDebugger";
    private static final String DEFAULT_HOST = "localhost";
    Text fHostNameField = null;
    protected Button fLaunchProxy;
    private WidgetListener fListener = new WidgetListener();
    Text fPortNumberField = null;
    protected Text fProxy;
    protected Button fStopInMain;
    protected Text fStopInMainSymbol;
    Text fTracePortNumberField = null;
    protected Button fVerbose;

    protected void addLabel(Composite composite, String text) {
        Label fHostLabel = new Label(composite, 0);
        fHostLabel.setText(text);
        fHostLabel.setLayoutData((Object)new GridData(256));
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), CONTEXT_HELP_ID);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        this.createGDBProxyGroup(comp);
        this.fStopInMain = this.createCheckButton(comp, Messages.StandaloneDebugOptionsTab_4);
        this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandaloneDebugOptionsTab.this.fStopInMainSymbol.setEnabled(StandaloneDebugOptionsTab.this.fStopInMain.getSelection());
                StandaloneDebugOptionsTab.this.update();
            }
        });
        this.fStopInMainSymbol = new Text(comp, 2052);
        GridData gridData = new GridData(4, 2, false, false);
        gridData.widthHint = 100;
        this.fStopInMainSymbol.setLayoutData((Object)gridData);
        this.fStopInMainSymbol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                StandaloneDebugOptionsTab.this.update();
            }
        });
        this.fVerbose = this.createCheckButton(comp, Messages.StandaloneDebugOptionsTab_5);
        this.fVerbose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandaloneDebugOptionsTab.this.update();
            }
        });
    }

    private Group createGDBProxyGroup(Composite comp) {
        Group group = new Group(comp, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.StandaloneDebugOptionsTab_GDBProxyGroupLabel);
        this.fLaunchProxy = this.createCheckButton((Composite)group, Messages.StandaloneDebugOptionsTab_StartGDBProxy);
        this.fLaunchProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandaloneDebugOptionsTab.this.update();
            }
        });
        GridData span = new GridData(4, 2, true, false);
        span.horizontalSpan = 2;
        this.fLaunchProxy.setLayoutData((Object)span);
        this.addLabel((Composite)group, Messages.StandaloneDebugOptionsTab_0);
        this.fProxy = new Text((Composite)group, 2052);
        GridData gridData2 = new GridData(4, 2, false, false);
        gridData2.widthHint = 100;
        this.fProxy.setLayoutData((Object)gridData2);
        this.fProxy.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                StandaloneDebugOptionsTab.this.update();
            }
        });
        this.addLabel((Composite)group, Messages.StandaloneDebugOptionsTab_1);
        this.fHostNameField = new Text((Composite)group, 2052);
        this.fHostNameField.setLayoutData((Object)new GridData(768));
        this.fHostNameField.addModifyListener((ModifyListener)this.fListener);
        this.addLabel((Composite)group, Messages.StandaloneDebugOptionsTab_2);
        this.fPortNumberField = new Text((Composite)group, 2052);
        this.fPortNumberField.setLayoutData((Object)new GridData(768));
        this.fPortNumberField.addModifyListener((ModifyListener)this.fListener);
        this.addLabel((Composite)group, Messages.StandaloneDebugOptionsTab_3);
        this.fTracePortNumberField = new Text((Composite)group, 2052);
        this.fTracePortNumberField.setLayoutData((Object)new GridData(768));
        this.fTracePortNumberField.addModifyListener((ModifyListener)this.fListener);
        return group;
    }

    private String getGDBPort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_GDB_PORT");
    }

    private String getGDPProxy() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_GDBPROXY");
    }

    public String getId() {
        return "avr32.launch.debug";
    }

    public String getName() {
        return Messages.StandaloneDebugOptionsTab_6;
    }

    private String getTracePort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_TRACE_PORT");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeHostName(configuration);
        this.initializePortNumber(configuration);
        this.initializeTracePortNumber(configuration);
        try {
            this.fStopInMain.setSelection(configuration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false));
            this.fStopInMainSymbol.setText(configuration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main"));
            this.fStopInMainSymbol.setEnabled(this.fStopInMain.getSelection());
            this.fVerbose.setSelection(configuration.getAttribute("AVR32_ATTR_VERBOSE", false));
            this.fLaunchProxy.setSelection(configuration.getAttribute("AVR32_ATTR_START_PROXY", true));
            this.fProxy.setText(configuration.getAttribute("AVR32_ATTR_GDBPROXY", this.getGDPProxy()));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void initializeHostName(ILaunchConfiguration configuration) {
        if (this.fHostNameField != null) {
            try {
                this.fHostNameField.setText(configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, DEFAULT_HOST));
            }
            catch (CoreException coreException) {}
        }
    }

    private void initializePortNumber(ILaunchConfiguration configuration) {
        if (this.fPortNumberField != null) {
            try {
                this.fPortNumberField.setText(configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, String.valueOf(this.getGDBPort())));
            }
            catch (CoreException coreException) {}
        }
    }

    private void initializeTracePortNumber(ILaunchConfiguration configuration) {
        if (this.fTracePortNumberField != null) {
            try {
                this.fTracePortNumberField.setText(configuration.getAttribute("AVR32_ATTR_GDB_TRACE_PORT", String.valueOf(this.getTracePort())));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", DEBUGGER_ID);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "avr32-gdb");
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, this.fHostNameField.getText());
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", this.fStopInMainSymbol.getText());
        configuration.setAttribute("AVR32_ATTR_VERBOSE", this.fVerbose.getSelection());
        configuration.setAttribute("AVR32_ATTR_START_PROXY", this.fLaunchProxy.getSelection());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, this.fVerbose.getSelection());
        configuration.setAttribute("AVR32_ATTR_GDBPROXY", this.fProxy.getText());
        configuration.setAttribute("AVR32_ATTR_GDB_TRACE_PORT", this.fTracePortNumberField.getText());
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, this.fPortNumberField.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", DEBUGGER_ID);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "avr32-gdb");
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, this.getGDBPort());
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, DEFAULT_HOST);
        configuration.setAttribute("AVR32_ATTR_VERBOSE", false);
        configuration.setAttribute("AVR32_ATTR_START_PROXY", true);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
        configuration.setAttribute("AVR32_ATTR_GDBPROXY", this.getGDPProxy());
        configuration.setAttribute("AVR32_ATTR_GDB_TRACE_PORT", this.getTracePort());
        configuration.setAttribute("org.eclipse.debug.core.capture_output", false);
    }

    protected void update() {
        super.updateLaunchConfigurationDialog();
        this.fProxy.setEnabled(this.fLaunchProxy.getSelection());
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            StandaloneDebugOptionsTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            StandaloneDebugOptionsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

