/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.internal.launch;

import com.atmel.avr32.debug.PropertyTester;
import com.atmel.avr32.debug.ui.internal.launch.Messages;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractCommonConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static WorkbenchLabelProvider fLabelProvider;

    protected ILabelProvider getWorkbenchLabelProvider() {
        if (fLabelProvider == null) {
            fLabelProvider = new WorkbenchLabelProvider();
        }
        return fLabelProvider;
    }

    protected IProject chooseProject(String projectType) throws CoreException {
        IProject[] projects;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.getWorkbenchLabelProvider());
        dialog.setTitle(Messages.SelectProject_Label);
        dialog.setMessage(Messages.SelectProject_Desc);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ArrayList<IProject> filtered = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (PropertyTester.isProjectType((IResource)project, (String)projectType)) {
                filtered.add(project);
            }
            ++n2;
        }
        dialog.setElements(filtered.toArray());
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    protected void guessName(ILaunchConfigurationWorkingCopy configuration, IResource obj, String projectType) {
        String projectName = null;
        try {
            IManagedBuildInfo info;
            IProjectType type;
            IProject project = obj.getProject();
            if (project.getDescription().hasNature("com.atmel.avr32.core.nature") && ManagedBuildManager.canGetBuildInfo((IResource)project) && !(type = (info = ManagedBuildManager.getBuildInfo((IResource)project)).getManagedProject().getProjectType()).getId().equals(projectType)) {
                return;
            }
            projectName = obj.getProject().getName();
            String configName = this.getLaunchConfigurationDialog().generateName(projectName);
            configuration.rename(configName);
            configuration.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

