/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.internal.launch;

import com.atmel.avr32.debug.DebugUtilities;
import com.atmel.avr32.debug.ui.internal.launch.Messages;
import com.atmel.avr32.target.ITarget;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public abstract class AbstractAVR32LaunchShortcut
implements ILaunchShortcut {
    protected IResource executable;

    protected abstract ILaunchConfigurationType getAVRLaunchConfigType();

    protected abstract ILaunchConfiguration createConfiguration(IBinary var1, ITarget var2, String var3);

    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, ITarget target, String mode) {
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getAVRLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                IPath programPath = AbstractCLaunchDelegate.getProgramPath((ILaunchConfiguration)config);
                String projectName = AbstractCLaunchDelegate.getProjectName((ILaunchConfiguration)config);
                IPath name = bin.getResource().getProjectRelativePath();
                if (programPath != null && programPath.equals((Object)name) && projectName != null && projectName.equals(bin.getCProject().getProject().getName()) && (target == null || config.getAttribute("AVR32_ATTR_STK_ID", -1) == target.getId())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        configuration = candidateCount < 1 ? this.createConfiguration(bin, target, mode) : (candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : this.chooseConfiguration(candidateConfigs, mode));
        return configuration;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.AbstractAVR32LaunchShortcut_1);
        dialog.setMessage(Messages.AbstractAVR32LaunchShortcut_2);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return LaunchUIPlugin.getActiveWorkbenchShell();
    }

    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, null, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), null, mode);
        }
    }

    public void launch(IBinary bin, ITarget target, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(bin, target, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    public void launch(IProject project, ITarget target, String mode) {
        this.searchAndLaunch(new StructuredSelection((Object)project).toArray(), target, mode);
    }

    private void searchAndLaunch(final Object[] elements, ITarget target, String mode) {
        if (elements != null && elements.length > 0) {
            IBinary bin = null;
            if (elements.length == 1 && elements[0] instanceof IBinary) {
                bin = (IBinary)elements[0];
            } else {
                final ArrayList<IBinary> results = new ArrayList<IBinary>();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InterruptedException {
                        DebugUtilities.findBinaries((Object[])elements, (List)results, (IProgressMonitor)pm);
                    }
                };
                try {
                    dialog.run(true, true, runnable);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Application Launcher", (String)e.getMessage());
                    return;
                }
                int count = results.size();
                if (count == 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.AbstractAVR32LaunchShortcut_Application_Launcher, (String)Messages.AbstractAVR32LaunchShortcut_4);
                } else {
                    bin = count > 1 ? this.chooseBinary(results, mode) : (IBinary)results.get(0);
                }
            }
            if (bin != null) {
                this.launch(bin, target, mode);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AbstractAVR32LaunchShortcut_Application_Launcher, (String)Messages.AbstractAVR32LaunchShortcut_6);
        }
    }

    protected IBinary chooseBinary(List<IBinary> binList, String mode) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements(binList.toArray());
        dialog.setTitle(Messages.AbstractAVR32LaunchShortcut_7);
        dialog.setMessage(Messages.AbstractAVR32LaunchShortcut_8);
        dialog.setUpperListLabel("Binaries:");
        dialog.setLowerListLabel("Qualifier:");
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }
}

