/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.internal.launch;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.debug.ILaunchParticipant;
import com.atmel.avr32.debug.IRegisterWatch;
import com.atmel.avr32.debug.internal.AVR32GDBServerDebugger;
import com.atmel.avr32.debug.internal.RegisterWatch;
import com.atmel.avr32.debug.ui.AVR32DebugUIPlugin;
import com.atmel.avr32.debug.ui.internal.launch.Messages;
import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public class AVR32LaunchDelegate
extends AbstractCLaunchDelegate {
    private static final String CLASS = "class";
    private static final String EMPTY_STRING = "";

    private ILaunchParticipant[] getLaunchParticipants() {
        IConfigurationElement[] interfaces;
        ArrayList<ILaunchParticipant> participants = new ArrayList<ILaunchParticipant>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.atmel.avr32.debug.launchParticipants");
        IConfigurationElement[] iConfigurationElementArray = interfaces = extensionPoint.getConfigurationElements();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement interFace = iConfigurationElementArray[n2];
            try {
                ILaunchParticipant instance = (ILaunchParticipant)interFace.createExecutableExtension(CLASS);
                participants.add(instance);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return participants.toArray(new ILaunchParticipant[participants.size()]);
    }

    private FuseRegisterSettings getFuseFile(ILaunchConfiguration configuration, String identifier) {
        String filename;
        block4: {
            filename = configuration.getAttribute(identifier, EMPTY_STRING);
            if (!filename.equals(EMPTY_STRING)) break block4;
            return null;
        }
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING));
            return new FuseRegisterSettings(project.getFile(filename).getFullPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void pause() {
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchParticipant[] participants = this.getLaunchParticipants();
        IPath exePath = this.verifyProgramPath(configuration);
        ICProject project = this.verifyCProject(configuration);
        if (exePath != null) {
            this.verifyBinary(project, exePath);
        }
        int targetID = configuration.getAttribute("AVR32_ATTR_STK_ID", -1);
        ITarget target = TargetPlugin.getTargetManager().getTarget(targetID);
        AVR32DebugPlugin.getDefault().addLaunchListener(launch, target);
        String interfaceTypeAttribute = mode.equals("debug") ? "AVR32_ATTR_DEBUG_INTERFACE" : "AVR32_ATTR_RUN_INTERFACE";
        ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(configuration.getAttribute(interfaceTypeAttribute, "AVR32 Program/GDB-Proxy"));
        adapter.setTarget(target);
        target.setWorking(true);
        TargetPlugin.getTargetManager().updateTarget(target);
        MultiStatus status = new MultiStatus("com.atmel.avr32.debug", 0, "Launching " + configuration.getName() + " in " + mode + " mode.", null);
        FuseRegisterSettings pre = this.getFuseFile(configuration, "AVR32_ATTR_PRE_FUSES");
        FuseRegisterSettings post = this.getFuseFile(configuration, "AVR32_ATTR_POST_FUSES");
        int ticks = 10;
        if (post != null) {
            --ticks;
        }
        if (pre != null) {
            --ticks;
        }
        if (mode.equals("debug")) {
            --ticks;
        }
        monitor.beginTask("Launching...", ticks);
        if (pre != null) {
            status.add(adapter.applyFuseSettings(pre, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            this.pause();
        }
        if (status != null && status.getSeverity() == 4) {
            this.abort((IStatus)status);
        }
        status.add(adapter.launch(configuration, mode, launch, (IProgressMonitor)new SubProgressMonitor(monitor, ticks)));
        if (post != null && status.isOK()) {
            this.pause();
            status.add(adapter.applyFuseSettings(post, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        }
        if (mode.equals("debug") && status.isOK()) {
            ILaunchParticipant launchParticipant;
            ILaunchParticipant[] iLaunchParticipantArray = participants;
            int n = participants.length;
            int n2 = 0;
            while (n2 < n) {
                launchParticipant = iLaunchParticipantArray[n2];
                status.add(launchParticipant.preDebugger(launch));
                if (status.getSeverity() == 4) {
                    this.abort((IStatus)status);
                }
                ++n2;
            }
            status.add(this.launchGDB(configuration, launch, adapter, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            iLaunchParticipantArray = participants;
            n = participants.length;
            n2 = 0;
            while (n2 < n) {
                launchParticipant = iLaunchParticipantArray[n2];
                launchParticipant.postDebugger(launch);
                ++n2;
            }
        }
        if (status.getSeverity() == 8) {
            monitor.setCanceled(true);
        }
        if (status.getSeverity() == 4) {
            monitor.setCanceled(true);
            this.abort((IStatus)status);
        }
        monitor.done();
        AVR32DebugUIPlugin.messageDialog((IStatus)status);
    }

    public static IStatus getMostSevere(IStatus[] status) {
        IStatus max = null;
        int i = 0;
        while (i < status.length) {
            IStatus curr = status[i];
            if (curr.matches(4)) {
                return curr;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        return max;
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }

    protected void abort(IStatus status) throws CoreException {
        throw new DebugException(status);
    }

    private IStatus launchGDB(ILaunchConfiguration configuration, ILaunch launch, ITargetInterface adapter, IProgressMonitor monitor) {
        ICDISession dsession = null;
        try {
            IBinaryParser.IBinaryObject exeFile = null;
            IPath exePath = this.verifyProgramPath(configuration);
            ICProject project = this.verifyCProject(configuration);
            if (exePath != null) {
                exeFile = this.verifyBinary(project, exePath);
            }
            this.setDefaultSourceLocator(launch, configuration);
            AVR32GDBServerDebugger debugger = new AVR32GDBServerDebugger();
            dsession = debugger.createSession(launch, exePath.toFile(), (IProgressMonitor)new SubProgressMonitor(monitor, 8));
            AVR32DebugPlugin.getDefault().addRegisterWatch((IRegisterWatch)new RegisterWatch(launch, project.getProject(), dsession), launch);
            if (adapter instanceof ICDIEventListener) {
                dsession.getEventManager().addEventListener((ICDIEventListener)adapter);
            }
            String stopSymbol = null;
            boolean stopInMain = configuration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
            if (stopInMain) {
                stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
            }
            ICDITarget[] targets = dsession.getTargets();
            int i = 0;
            while (i < targets.length) {
                Process process = targets[i].getProcess();
                IProcess iprocess = null;
                if (process != null) {
                    iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                }
                boolean run = configuration.getAttribute("AVR32_ATTR_FILE_RUN", false);
                CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderProcessLabel("avr32gdbserver debugger"), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)stopSymbol, (boolean)run);
                ++i;
            }
            return new Status(0, "com.atmel.avr32.debug", 0, "GDB launched", null);
        }
        catch (CoreException e) {
            try {
                if (dsession != null) {
                    dsession.terminate();
                }
            }
            catch (CDIException cDIException) {}
            return new Status(4, "com.atmel.avr32.debug", 0, "Could not start GDB", (Throwable)e);
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!super.preLaunchCheck(configuration, mode, monitor)) {
            return false;
        }
        if (configuration.getMappedResources() == null) {
            AVR32DebugUIPlugin.errorMessage(Messages.AVR32LaunchDelegate_2, Messages.AVR32LaunchDelegate_Error_InvalidConfig);
            return false;
        }
        IProject iProject = configuration.getMappedResources()[0].getProject();
        String mcu = TargetPlugin.getDefault().getPart(iProject).getName();
        int targetID = configuration.getAttribute("AVR32_ATTR_STK_ID", -1);
        if (targetID == -1) {
            AVR32DebugUIPlugin.errorMessage(Messages.AVR32LaunchDelegate_2, Messages.AVR32LaunchDelegate_Error_NoTarget);
            return false;
        }
        ITarget fTarget = TargetPlugin.getTargetManager().getTarget(targetID);
        if (fTarget == null) {
            AVR32DebugUIPlugin.errorMessage(Messages.AVR32LaunchDelegate_2, Messages.AVR32LaunchDelegate_3);
            return false;
        }
        if (!fTarget.isValid()) {
            AVR32DebugUIPlugin.errorMessage(Messages.AVR32LaunchDelegate_2, Messages.AVR32LaunchDelegate_Error_InvalidTarget);
            return false;
        }
        if (fTarget.isWorking()) {
            AVR32DebugUIPlugin.errorMessage(Messages.AVR32LaunchDelegate_2, Messages.AVR32LaunchDelegate_Error_BusyTarget);
            return false;
        }
        if (mcu == null) {
            AVR32DebugUIPlugin.errorMessage(Messages.AVR32LaunchDelegate_2, Messages.AVR32LaunchDelegate_Error_NoMCU);
            return false;
        }
        if (!mcu.equals(fTarget.getCpu())) {
            AVR32DebugUIPlugin.warningMessage(Messages.AVR32LaunchDelegate_Warning, Messages.AVR32LaunchDelegate_Warning_MCUMismatch);
            return true;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }
}

