/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.internal;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.debug.IRegisterWatch;
import com.atmel.avr32.debug.IRegisterWatchListener;
import com.atmel.avr32.debug.ui.AVR32DebugUIPlugin;
import com.atmel.avr32.debug.ui.IRegisterView;
import com.atmel.avr32.debug.ui.internal.Messages;
import com.atmel.avr32.target.debug.IWatchable;
import com.atmel.avr32.target.part.model.Bitfield;
import com.atmel.avr32.target.part.model.BitfieldInstance;
import com.atmel.avr32.target.part.model.BitfieldValue;
import com.atmel.avr32.target.part.model.Core;
import com.atmel.avr32.target.part.model.IBitfield;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.Register;
import com.atmel.avr32.target.part.model.RegisterInstance;
import com.atmel.avr32.util.UtilPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class RegistersView
extends ViewPart
implements ISelectionListener,
ISelectionProvider,
IRegisterWatchListener,
IRegisterView {
    private static final String DELETE_COMMAND_ID = "org.eclipse.ui.edit.delete";
    private LaunchListener fLaunchListener;
    private static final String EMPTY_STRING = "";
    private static final String FIELD_SEPARATOR = "\\.";
    private static final String MEMENTO_LINK_WITH_EDITOR = "MEMENTO_LINK_WITH_EDITOR";
    private static final String MEMENTO_PROJECT = "MEMENTO_PROJECT";
    private static final String SEARCH_TERMS = "Search.Terms";
    private static final String SELECTED_WATCHABLES = "SelectedWatchables";
    private static final String SELECTION_SEPARATOR = ";";
    private final IRegisterWatch fDefaultRegisterWatch;
    private boolean fLinked;
    private IAction formatBinaryAction;
    private IAction formatDecimalAction;
    private IAction formatDescriptionAction;
    private IAction formatHexadecimalAction;
    private boolean fPinned;
    private IRegisterWatch fRegisterWatch;
    private IAction linkAction;
    ArrayList<Object> listeners = new ArrayList();
    private IAction pinAction;
    private IAction removeAllAction;
    private IAction removeWatchAction;
    private Combo searchField;
    private IAction showInTreeAction;
    private TableViewContentProvider tableProvider;
    private TableViewer tableView;
    ISelection theSelection = StructuredSelection.EMPTY;
    private TreeViewContentProvider treeProvider;
    private TreeViewer treeView;
    private UsedMap usedSearches;
    IProject fInitialProject = null;

    public RegistersView() {
        this.fDefaultRegisterWatch = AVR32DebugPlugin.getRegisterWatch();
    }

    private void addBottomSection(Composite parent) {
        this.tableView = new TableViewer(parent, 770);
        this.tableProvider = new TableViewContentProvider();
        this.tableView.setContentProvider((IContentProvider)this.tableProvider);
        Table table = this.tableView.getTable();
        table.setToolTipText(Messages.RegistersView_Tbl_Watched);
        TableColumn c = new TableColumn(table, 16384);
        c.setText(Messages.RegistersView_Tbl_Register);
        c.setWidth(120);
        c = new TableColumn(table, 16384);
        c.setText(Messages.RegistersView_Tbl_Address);
        c.setWidth(80);
        c = new TableColumn(table, 16384);
        c.setText(Messages.RegistersView_Tbl_Value);
        c.setWidth(120);
        c = new TableColumn(table, 16384);
        c.setText(Messages.RegistersView_Tbl_Previous);
        c.setWidth(120);
        c = new TableColumn(table, 16384);
        c.setText(Messages.RegistersView_Tbl_Description);
        c.setWidth(200);
        table.setHeaderVisible(true);
        this.tableView.setLabelProvider((IBaseLabelProvider)new TableViewLabelProvider());
        this.tableView.setInput((Object)this.getSite());
        this.tableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                if (event.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IWatchable) {
                    int format = ((IWatchable)o).getFormat();
                    switch (format) {
                        case 0: {
                            RegistersView.this.formatBinaryAction.setChecked(true);
                            RegistersView.this.formatDecimalAction.setChecked(false);
                            RegistersView.this.formatHexadecimalAction.setChecked(false);
                            RegistersView.this.formatDescriptionAction.setChecked(false);
                            break;
                        }
                        case 1: {
                            RegistersView.this.formatBinaryAction.setChecked(false);
                            RegistersView.this.formatDecimalAction.setChecked(true);
                            RegistersView.this.formatHexadecimalAction.setChecked(false);
                            RegistersView.this.formatDescriptionAction.setChecked(false);
                            break;
                        }
                        case 2: {
                            RegistersView.this.formatBinaryAction.setChecked(false);
                            RegistersView.this.formatDecimalAction.setChecked(false);
                            RegistersView.this.formatHexadecimalAction.setChecked(true);
                            RegistersView.this.formatDescriptionAction.setChecked(false);
                            break;
                        }
                        case 3: {
                            RegistersView.this.formatBinaryAction.setChecked(false);
                            RegistersView.this.formatDecimalAction.setChecked(false);
                            RegistersView.this.formatHexadecimalAction.setChecked(false);
                            RegistersView.this.formatDescriptionAction.setChecked(true);
                            break;
                        }
                    }
                }
            }
        });
        this.tableView.addDoubleClickListener((IDoubleClickListener)new TableEditListener());
        table.setToolTipText(EMPTY_STRING);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    private void addTopSection(Composite parent) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        Label searchFieldLabel = new Label(parent, 0);
        searchFieldLabel.setText(Messages.RegistersView_Find);
        FormData data4 = new FormData();
        data4.left = new FormAttachment(0, 4);
        data4.top = new FormAttachment(0, 6);
        searchFieldLabel.setLayoutData((Object)data4);
        this.searchField = new Combo(parent, 2048);
        this.searchField.setToolTipText(Messages.RegistersView_Find_Tooltip);
        FormData data1 = new FormData();
        data1.right = new FormAttachment(100, 0);
        data1.left = new FormAttachment((Control)searchFieldLabel);
        data1.top = new FormAttachment(0, 2);
        this.searchField.setLayoutData((Object)data1);
        this.treeView = new TreeViewer(parent, 768);
        this.treeProvider = new TreeViewContentProvider();
        this.treeView.setContentProvider((IContentProvider)this.treeProvider);
        this.treeView.setLabelProvider((IBaseLabelProvider)new TreeViewLabelProvider());
        this.treeView.setInput((Object)this.getViewSite());
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        data2.top = new FormAttachment((Control)this.searchField, 2);
        this.treeView.getTree().setLayoutData((Object)data2);
        this.treeView.setAutoExpandLevel(-1);
        this.treeView.addFilter((ViewerFilter)new AddressFilter());
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Runnable update = new Runnable(){

                    @Override
                    public void run() {
                        if (RegistersView.this.treeView != null) {
                            RegistersView.this.treeView.refresh();
                        }
                    }
                };
                Display.getDefault().syncExec(update);
            }
        });
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                block8: {
                    block0 : switch (e.type) {
                        case 31: {
                            switch (e.detail) {
                                case 4: {
                                    String value = RegistersView.this.searchField.getText();
                                    if (value.length() > 0) {
                                        RegistersView.this.usedSearches.put(value, value);
                                        RegistersView.this.updateUsedSearches();
                                        RegistersView.this.searchField.setText(value);
                                        RegistersView.this.searchField.setSelection(new Point(0, value.length()));
                                        RegistersView.this.treeView.expandAll();
                                        break block0;
                                    }
                                    break block8;
                                }
                                case 2: {
                                    RegistersView.this.searchField.setText(RegistersView.EMPTY_STRING);
                                }
                            }
                        }
                    }
                }
            }
        };
        this.searchField.addListener(31, textListener);
        Tree tree = this.treeView.getTree();
        TreeColumn c = new TreeColumn(tree, 16384);
        c.setText(Messages.RegistersView_Tbl_Register);
        c.setWidth(120);
        c = new TreeColumn(tree, 16384);
        c.setText(Messages.RegistersView_Tbl_Address);
        c.setWidth(80);
        c = new TreeColumn(tree, 16384);
        c.setText(Messages.RegistersView_Tbl_Description);
        c.setWidth(200);
        tree.setHeaderVisible(true);
        this.treeView.addDoubleClickListener((IDoubleClickListener)new TreeDoubleClickListener());
    }

    private void changeRegisterWatch(IProject newProject) {
        IProject oldProject = null;
        if (this.fRegisterWatch != null) {
            this.fRegisterWatch.removeRegisterWatchListener((IRegisterWatchListener)this);
            oldProject = this.fRegisterWatch.getProject();
        }
        if (this.fRegisterWatch == null || this.fRegisterWatch.equals(this.fDefaultRegisterWatch)) {
            if (oldProject == null || !newProject.equals((Object)oldProject)) {
                this.fRegisterWatch = this.fDefaultRegisterWatch;
                this.fRegisterWatch.addRegisterWatchListener((IRegisterWatchListener)this);
                if (oldProject != null) {
                    this.saveSelection(oldProject);
                }
                this.fRegisterWatch.setProject(newProject);
                this.updateSelection(newProject);
                this.setContentDescription(MessageFormat.format(Messages.RegistersView_ContentDescription, newProject.getName(), this.fRegisterWatch.getPart().getName()));
            }
        } else {
            this.fRegisterWatch = this.fDefaultRegisterWatch;
            this.fRegisterWatch.addRegisterWatchListener((IRegisterWatchListener)this);
            if (oldProject != null) {
                this.saveSelection(oldProject);
            }
            this.fRegisterWatch.setProject(newProject);
            this.updateSelection(newProject);
            this.setContentDescription(MessageFormat.format(Messages.RegistersView_ContentDescription, newProject.getName(), this.fRegisterWatch.getPart().getName()));
        }
    }

    void changeRegisterWatch(IRegisterWatch watch) {
        if (this.fRegisterWatch == watch) {
            return;
        }
        if (this.fRegisterWatch != null) {
            this.fRegisterWatch.removeRegisterWatchListener((IRegisterWatchListener)this);
            this.saveSelection(this.fRegisterWatch.getProject());
        }
        if (watch != null) {
            this.fRegisterWatch = watch;
            this.fRegisterWatch.addRegisterWatchListener((IRegisterWatchListener)this);
            this.updateSelection(this.fRegisterWatch.getProject());
            this.setContentDescription(MessageFormat.format(Messages.RegistersView_ContentDescription_Debugging, watch.getLaunch().getLaunchConfiguration().getName(), watch.getPart().getName()));
        }
    }

    private void clearSelection() {
        if (this.tableProvider.list == null) {
            return;
        }
        for (IWatchable item : this.tableProvider.list) {
            item.setWatched(false);
            this.fRegisterWatch.removeRegisterWatch(item);
            this.tableView.remove((Object)item);
        }
        this.tableProvider.list.clear();
    }

    private void createActions() {
        this.removeWatchAction = new RemoveWatchAction("Remove");
        IHandlerService handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        handlerService.activateHandler(DELETE_COMMAND_ID, (IHandler)new ActionHandler(this.removeWatchAction));
        this.removeAllAction = new Action(Messages.RegistersView_RemoveAll){

            public void run() {
                for (IWatchable watchable : ((RegistersView)RegistersView.this).tableProvider.list) {
                    watchable.setWatched(false);
                    RegistersView.this.fRegisterWatch.removeRegisterWatch(watchable);
                }
                RegistersView.this.tableProvider.update();
            }
        };
        this.showInTreeAction = new Action(Messages.RegistersView_ShowInTree){

            public void run() {
                if (RegistersView.this.tableView.getSelection() instanceof IStructuredSelection) {
                    Object o = ((IStructuredSelection)RegistersView.this.tableView.getSelection()).getFirstElement();
                    RegistersView.this.treeView.setSelection((ISelection)new StructuredSelection(o), true);
                }
            }
        };
        this.formatBinaryAction = new FormatAction(Messages.RegistersView_Binary, 0);
        this.formatDecimalAction = new FormatAction(Messages.RegistersView_Decimal, 1);
        this.formatHexadecimalAction = new FormatAction(Messages.RegistersView_Hexadecimal, 2);
        this.formatDescriptionAction = new FormatAction(Messages.RegistersView_Descriptive, 3);
        this.pinAction = new Action(Messages.RegistersView_Pin, 2){

            public void run() {
                RegistersView.this.fPinned = RegistersView.this.pinAction.isChecked();
            }
        };
        this.pinAction.setImageDescriptor(AVR32DebugUIPlugin.getViewImageDescriptor("clcl16/pin.gif"));
        this.linkAction = new Action(Messages.RegistersView_Link, 2){

            public void run() {
                RegistersView.this.fLinked = RegistersView.this.linkAction.isChecked();
            }
        };
        this.linkAction.setChecked(this.fLinked);
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.atmel.avr32.doc.guide.avr32register");
        SashForm sash = new SashForm(parent, 512);
        sash.setLayout((Layout)new FillLayout());
        Composite top = new Composite((Composite)sash, 0);
        top.setLayout((Layout)new FillLayout());
        this.addTopSection(top);
        this.addBottomSection((Composite)sash);
        this.createActions();
        this.hookContextMenu();
        this.usedSearches = new UsedMap(5, 1.0f, true);
        ISelectionService s = this.getSite().getWorkbenchWindow().getSelectionService();
        s.addPostSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add(this.pinAction);
        this.getViewSite().getActionBars().getMenuManager().add(this.linkAction);
        if (this.fInitialProject != null && this.fInitialProject.isAccessible()) {
            this.changeRegisterWatch(this.fInitialProject);
        }
        this.fLaunchListener = new LaunchListener();
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        this.fLaunchListener.launchesChanged(launches);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchListener);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        if (this.fRegisterWatch != null) {
            this.fRegisterWatch.removeRegisterWatchListener((IRegisterWatchListener)this);
        }
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchListener);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.tableView.getSelection() instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)this.tableView.getSelection()).getFirstElement();
            if (o instanceof IWatchable) {
                manager.add(this.removeWatchAction);
                manager.add(this.showInTreeAction);
                this.fillFormatMenu(manager);
            }
            if (this.tableProvider.list.size() > 0) {
                manager.add((IContributionItem)new Separator());
                manager.add(this.removeAllAction);
            }
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    private void fillFormatMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager(Messages.RegistersView_Format);
        manager.add((IContributionItem)menu);
        menu.add(this.formatBinaryAction);
        menu.add(this.formatDecimalAction);
        menu.add(this.formatHexadecimalAction);
        menu.add(this.formatDescriptionAction);
    }

    public ISelection getSelection() {
        return this.theSelection;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RegistersView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableView.getControl());
        this.tableView.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableView);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            IProject project;
            this.fLinked = memento.getString(MEMENTO_LINK_WITH_EDITOR) != null ? Boolean.parseBoolean(memento.getString(MEMENTO_LINK_WITH_EDITOR)) : false;
            if (memento.getString(MEMENTO_PROJECT) != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(memento.getString(MEMENTO_PROJECT))) != null && project.exists()) {
                this.fInitialProject = project;
            }
        } else {
            this.fLinked = false;
        }
    }

    private void loadSelection(IRegisterWatch watch) {
        String searchTerms;
        int n;
        if (watch.getProject() == null) {
            return;
        }
        this.clearSelection();
        this.usedSearches.clear();
        this.updateUsedSearches();
        ProjectScope projectScope = new ProjectScope(watch.getProject());
        IEclipsePreferences projectNode = projectScope.getNode("com.atmel.avr32.debug");
        String selection = projectNode.get(SELECTED_WATCHABLES, EMPTY_STRING);
        if (selection.length() > 0) {
            String[] watchables;
            String[] stringArray = watchables = selection.split(SELECTION_SEPARATOR);
            n = watchables.length;
            int n2 = 0;
            while (n2 < n) {
                String watchable = stringArray[n2];
                try {
                    long address = 0L;
                    int bit = -1;
                    if (watchable.indexOf(46) > -1) {
                        address = Long.parseLong(watchable.split(FIELD_SEPARATOR)[0]);
                        bit = Integer.parseInt(watchable.split(FIELD_SEPARATOR)[1]);
                    } else {
                        address = Long.parseLong(watchable);
                    }
                    IModelInfo node = null;
                    node = bit >= 0 ? watch.getPart().findNode((IModelInfo)watch.getPart(), address, bit) : watch.getPart().findNode((IModelInfo)watch.getPart(), address);
                    if (node instanceof IWatchable) {
                        ((IWatchable)node).setWatched(true);
                        watch.addRegisterWatch((IWatchable)node);
                    }
                }
                catch (Exception e) {
                    UtilPlugin.println((Object)e);
                    e.printStackTrace();
                }
                ++n2;
            }
            this.tableProvider.update();
        }
        if ((searchTerms = projectNode.get(SEARCH_TERMS, EMPTY_STRING)).length() > 0) {
            String[] terms;
            String[] stringArray = terms = searchTerms.split(SELECTION_SEPARATOR);
            int n3 = terms.length;
            n = 0;
            while (n < n3) {
                String string = stringArray[n];
                this.usedSearches.put(string, string);
                ++n;
            }
            this.updateUsedSearches();
        }
    }

    public void registerUpdated(final IWatchable register, IRegisterWatchListener.EventType type) {
        try {
            Runnable update = new Runnable(){

                @Override
                public void run() {
                    if (RegistersView.this.tableView != null) {
                        RegistersView.this.tableView.refresh((Object)register);
                    }
                }
            };
            Display.getDefault().asyncExec(update);
        }
        catch (Exception exception) {}
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void saveSelection(IProject project) {
        Object[] objs;
        if (project == null || !project.isAccessible()) {
            return;
        }
        StringBuffer selected = new StringBuffer();
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("com.atmel.avr32.debug");
        Object[] objectArray = objs = this.tableProvider.getElements(this.getSite());
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IWatchable) {
                selected.append(((IWatchable)object).getAddress());
                if (object instanceof IBitfield) {
                    selected.append('.');
                    selected.append(((IBitfield)object).getNumber());
                }
                selected.append(SELECTION_SEPARATOR);
            }
            ++n2;
        }
        StringBuffer searchTerms = new StringBuffer();
        for (String search : this.usedSearches.values()) {
            searchTerms.append(search);
            searchTerms.append(SELECTION_SEPARATOR);
        }
        if (projectNode != null) {
            projectNode.put(SELECTED_WATCHABLES, selected.toString());
            projectNode.put(SEARCH_TERMS, searchTerms.toString());
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void saveState(IMemento memento) {
        memento.putString(MEMENTO_LINK_WITH_EDITOR, Boolean.toString(this.fLinked));
        if (this.fRegisterWatch != null && this.fRegisterWatch.getProject() != null) {
            memento.putString(MEMENTO_PROJECT, this.fRegisterWatch.getProject().getName());
            this.saveSelection(this.fRegisterWatch.getProject());
        }
        super.saveState(memento);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorInput input;
        IResource r;
        Object o;
        if (this.fPinned) {
            return;
        }
        if (selection instanceof IStructuredSelection && this.changeFromContext(o = ((IStructuredSelection)selection).getFirstElement())) {
            return;
        }
        if (this.fLinked && part instanceof IEditorPart && (r = (IResource)(input = ((IEditorPart)part).getEditorInput()).getAdapter(IResource.class)) != null) {
            this.changeRegisterWatch(r.getProject());
        }
    }

    private boolean changeFromContext(Object o) {
        IRegisterWatch watch;
        if (o instanceof ILaunch) {
            IRegisterWatch watch2 = AVR32DebugPlugin.getDefault().getRegisterWatch((ILaunch)o);
            if (watch2 != null) {
                this.changeRegisterWatch(watch2);
                return true;
            }
        } else if (o instanceof CDebugTarget) {
            IRegisterWatch watch3 = AVR32DebugPlugin.getDefault().getRegisterWatch(((CDebugTarget)o).getLaunch());
            if (watch3 != null) {
                this.changeRegisterWatch(watch3);
                return true;
            }
        } else if (o instanceof CThread && (watch = AVR32DebugPlugin.getDefault().getRegisterWatch(((CThread)o).getLaunch())) != null) {
            this.changeRegisterWatch(watch);
            return true;
        }
        return false;
    }

    public void setFocus() {
        this.searchField.forceFocus();
    }

    public void setSelection(ISelection selection) {
    }

    private void updateSelection(final IProject newProject) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                RegistersView.this.loadSelection(RegistersView.this.fRegisterWatch);
                RegistersView.this.treeProvider.update();
                RegistersView.this.theSelection = newProject == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)newProject);
            }
        };
        Display.getDefault().syncExec(update);
    }

    private void updateUsedSearches() {
        if (this.searchField != null) {
            this.searchField.removeAll();
            for (String search : this.usedSearches.values()) {
                this.searchField.add(search);
            }
        }
    }

    @Override
    public IRegisterWatch getRegisterWatch() {
        return this.fRegisterWatch;
    }

    private class AddressFilter
    extends ViewerFilter {
        private static final String START_ADDRESS = "0X";
        private static final String START_PATH = "/";
        private static final char START_PATH_CHAR = '/';
        private static final String ZERO = "0";

        private AddressFilter() {
        }

        private boolean filterChildren(IModelInfo node, long query) {
            if (node.hasChildren()) {
                IModelInfo[] iModelInfoArray = node.getChildren();
                int n = iModelInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelInfo child = iModelInfoArray[n2];
                    long address = child.getAddress();
                    if (query == address) {
                        return true;
                    }
                    if (child.hasChildren()) {
                        return this.filterChildren(child, query);
                    }
                    ++n2;
                }
            }
            return false;
        }

        private boolean filterChildren(IModelInfo node, String term, boolean path) {
            if (node.hasChildren()) {
                IModelInfo[] iModelInfoArray = node.getChildren();
                int n = iModelInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelInfo child = iModelInfoArray[n2];
                    if (path && child.getPath().toUpperCase().startsWith(term)) {
                        return true;
                    }
                    if (!path && child.getName().toUpperCase().startsWith(term)) {
                        return true;
                    }
                    if (child.hasChildren() && this.filterChildren(child, term, path)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String term = RegistersView.this.searchField.getText().toUpperCase();
            boolean path = false;
            if (term.indexOf(47) > -1) {
                path = true;
            }
            if (term.startsWith(START_PATH)) {
                term = term.substring(1);
            }
            if (term != null && term.startsWith(ZERO)) {
                if (term.length() > 2) {
                    long address;
                    long query = Long.decode(term);
                    if (query == (address = ((IModelInfo)element).getAddress())) {
                        return true;
                    }
                    return this.filterChildren((IModelInfo)element, query);
                }
                return false;
            }
            if (term != null && !term.startsWith(START_ADDRESS) && term.length() > 0) {
                if (element instanceof IOModuleInstance || element instanceof Core) {
                    return this.filterChildren((IModelInfo)element, term, path);
                }
                if (element instanceof Register || element instanceof RegisterInstance) {
                    if (this.filterChildren((IModelInfo)element, term, path)) {
                        return true;
                    }
                    if (path && !((IModelInfo)element).getPath().toUpperCase().startsWith(term)) {
                        return false;
                    }
                    if (!path && !((IModelInfo)element).getName().toUpperCase().startsWith(term)) {
                        return false;
                    }
                }
                if (element instanceof Bitfield || element instanceof BitfieldInstance) {
                    if (path && ((IModelInfo)parentElement).getPath().toUpperCase().startsWith(term)) {
                        return true;
                    }
                    if (!path && ((IModelInfo)parentElement).getName().toUpperCase().startsWith(term)) {
                        return true;
                    }
                    if (path && !((IModelInfo)element).getPath().toUpperCase().startsWith(term)) {
                        return false;
                    }
                    if (!path && !((IModelInfo)element).getName().toUpperCase().startsWith(term)) {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private class FormatAction
    extends Action {
        private final int radix;

        public FormatAction(String name, int radix) {
            super(name, 8);
            this.radix = radix;
        }

        public void run() {
            Object o = ((IStructuredSelection)RegistersView.this.tableView.getSelection()).getFirstElement();
            if (o instanceof IWatchable) {
                ((IWatchable)o).setFormat(this.radix);
                RegistersView.this.tableView.refresh(o);
            }
        }
    }

    private class LaunchListener
    implements ILaunchesListener2 {
        private LaunchListener() {
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(final ILaunch[] launches) {
            if (RegistersView.this.fPinned) {
                return;
            }
            RegistersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        RegistersView.this.changeFromContext(launch);
                        ++n2;
                    }
                }
            });
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesTerminated(final ILaunch[] launches) {
            if (RegistersView.this.fRegisterWatch == null) {
                return;
            }
            RegistersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        if (RegistersView.this.fRegisterWatch.getLaunch() != null && RegistersView.this.fRegisterWatch.getLaunch().equals(launch)) {
                            if (((LaunchListener)LaunchListener.this).RegistersView.this.fInitialProject != null) {
                                RegistersView.this.changeRegisterWatch(((LaunchListener)LaunchListener.this).RegistersView.this.fInitialProject);
                            } else {
                                ((LaunchListener)LaunchListener.this).RegistersView.this.fInitialProject = RegistersView.this.fRegisterWatch.getProject();
                                RegistersView.this.fDefaultRegisterWatch.setProject(((LaunchListener)LaunchListener.this).RegistersView.this.fInitialProject);
                                RegistersView.this.changeRegisterWatch(((LaunchListener)LaunchListener.this).RegistersView.this.fInitialProject);
                            }
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    private class RemoveWatchAction
    extends Action {
        private static final String DELETE_ACTION_ID = "org.eclipse.ui.edit.delete";

        public RemoveWatchAction(String string) {
            super(string);
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        }

        public void run() {
            if (RegistersView.this.tableView.getSelection() instanceof IStructuredSelection) {
                Object[] objectArray = ((IStructuredSelection)RegistersView.this.tableView.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof IWatchable) {
                        ((IWatchable)o).setWatched(false);
                        RegistersView.this.fRegisterWatch.removeRegisterWatch((IWatchable)o);
                    }
                    ++n2;
                }
                RegistersView.this.tableProvider.update();
            }
        }
    }

    private class TableEditListener
    implements IDoubleClickListener {
        private TableEditListener() {
        }

        private long computeValue(Control newEditor, IWatchable field) {
            String text = this.getText(newEditor);
            if (newEditor instanceof CCombo) {
                int index = ((CCombo)newEditor).getSelectionIndex();
                if (field instanceof BitfieldInstance) {
                    return ((BitfieldValue)((BitfieldInstance)field).getBitfield().getBitfieldValues().get(index)).getValue();
                }
                if (field instanceof Bitfield) {
                    return ((BitfieldValue)((Bitfield)field).getBitfieldValues().get(index)).getValue();
                }
            }
            return Long.decode(text);
        }

        public void doubleClick(DoubleClickEvent event) {
            Object o;
            if (!RegistersView.this.fRegisterWatch.mayChangeValues()) {
                return;
            }
            if (event.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IWatchable) {
                if (((IWatchable)o).isReadonly()) {
                    return;
                }
                TableItem item = RegistersView.this.tableView.getTable().getSelection()[0];
                if (item.getData() instanceof Bitfield || item.getData() instanceof BitfieldInstance) {
                    Bitfield field = null;
                    field = item.getData() instanceof Bitfield ? (Bitfield)item.getData() : ((BitfieldInstance)item.getData()).getBitfield();
                    if (field.getBitfieldValues().size() > 0) {
                        int options = 0x80000C;
                        int position = 0;
                        int selection = 0;
                        CCombo newEditor = new CCombo((Composite)RegistersView.this.tableView.getTable(), options);
                        for (BitfieldValue value : field.getBitfieldValues()) {
                            newEditor.add(value.getDescription());
                            if ((long)value.getValue() == field.getValue()) {
                                selection = position;
                            }
                            ++position;
                        }
                        newEditor.setSize(newEditor.computeSize(-1, -1));
                        newEditor.select(selection);
                        this.editValue(item, (Control)newEditor, (IWatchable)item.getData());
                    } else {
                        this.editValue(item, (Control)new Text((Composite)RegistersView.this.tableView.getTable(), 0), (IWatchable)item.getData());
                    }
                } else {
                    this.editValue(item, (Control)new Text((Composite)RegistersView.this.tableView.getTable(), 0), (IWatchable)o);
                }
            }
        }

        private void editValue(final TableItem item, final Control control, final IWatchable field) {
            TableEditor editor = new TableEditor(RegistersView.this.tableView.getTable());
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            Listener textListener = new Listener(){

                private void acceptValue(TableItem item2, Control control2, IWatchable field2) {
                    if (field2 instanceof Bitfield || field2 instanceof BitfieldInstance) {
                        long value = TableEditListener.this.computeValue(control2, field2);
                        RegistersView.this.fRegisterWatch.setRegisterValue(field2, value);
                    } else {
                        long value = Long.decode(TableEditListener.this.getText(control2));
                        RegistersView.this.fRegisterWatch.setRegisterValue(field2, value);
                    }
                    item2.setText(2, field2.getFormattedValue());
                }

                public void handleEvent(Event e) {
                    block0 : switch (e.type) {
                        case 16: {
                            this.acceptValue(item, control, field);
                            control.dispose();
                            RegistersView.this.tableView.getTable().setFocus();
                            break;
                        }
                        case 31: {
                            switch (e.detail) {
                                case 4: {
                                    this.acceptValue(item, control, field);
                                    control.dispose();
                                    RegistersView.this.tableView.getTable().setFocus();
                                    break block0;
                                }
                                case 2: {
                                    control.dispose();
                                    RegistersView.this.tableView.getTable().setFocus();
                                    e.doit = false;
                                }
                            }
                        }
                    }
                }
            };
            control.addListener(16, textListener);
            control.addListener(31, textListener);
            if (control instanceof Text) {
                ((Text)control).setText(item.getText(2));
                ((Text)control).selectAll();
            }
            control.setFocus();
            editor.setEditor(control, item, 2);
        }

        private String getText(Control editor) {
            if (editor instanceof Text) {
                return ((Text)editor).getText();
            }
            if (editor instanceof CCombo) {
                return ((CCombo)editor).getItem(0);
            }
            return "<huh?>";
        }
    }

    private class TableViewContentProvider
    implements IStructuredContentProvider {
        ArrayList<IWatchable> list = new ArrayList();

        TableViewContentProvider() {
        }

        private ArrayList<IWatchable> addChildren(Object root) {
            if (root == null) {
                return this.list;
            }
            if (root instanceof IModelInfo) {
                IModelInfo[] iModelInfoArray = ((IModelInfo)root).getChildren();
                int n = iModelInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelInfo object = iModelInfoArray[n2];
                    if (object instanceof IWatchable && ((IWatchable)object).isWatched()) {
                        this.list.add((IWatchable)object);
                    }
                    if (object.hasChildren()) {
                        this.addChildren(object);
                    }
                    ++n2;
                }
            }
            return this.list;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            this.list.clear();
            if (inputElement.equals(RegistersView.this.getViewSite()) && RegistersView.this.fRegisterWatch != null) {
                this.addChildren(RegistersView.this.fRegisterWatch.getPart());
            }
            return this.list.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        void update() {
            Runnable update = new Runnable(){

                @Override
                public void run() {
                    if (RegistersView.this.tableView != null) {
                        RegistersView.this.tableView.refresh();
                    }
                }
            };
            Display.getDefault().syncExec(update);
        }
    }

    private class TableViewLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private static final String COLOR_REGISTERS_READ_ONLY = "com.atmel.avr32.debug.registers.color.readonly";
        private static final String COLOR_REGISTERS_NEW_VALUE = "com.atmel.avr32.debug.registers.color.changed";
        private ColorRegistry cr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();

        private TableViewLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IModelInfo) {
                IModelInfo info = (IModelInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return info.getPath();
                    }
                    case 1: {
                        return info.getLocation();
                    }
                    case 2: {
                        if (info instanceof IWatchable) {
                            return ((IWatchable)info).getFormattedValue();
                        }
                    }
                    case 3: {
                        if (info instanceof IWatchable) {
                            return ((IWatchable)info).getFormattedValue(((IWatchable)info).getPreviousValue());
                        }
                    }
                    case 4: {
                        return info.getDescription();
                    }
                }
            }
            return "Foo!";
        }

        public Color getForeground(Object element, int columnIndex) {
            IModelInfo info;
            if (element instanceof IModelInfo && (info = (IModelInfo)element) instanceof IWatchable) {
                if (((IWatchable)info).isReadonly()) {
                    return this.cr.get(COLOR_REGISTERS_READ_ONLY);
                }
                if (((IWatchable)info).hasChanged()) {
                    return this.cr.get(COLOR_REGISTERS_NEW_VALUE);
                }
            }
            Display display = Display.getCurrent();
            return display.getSystemColor(21);
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IModelInfo) {
                IModelInfo node = (IModelInfo)element;
                StringBuffer sb = new StringBuffer();
                sb.append(node.getName());
                while (node.getParent() != null) {
                    node = node.getParent();
                    sb.insert(0, '/');
                    sb.insert(0, node.getName());
                }
                return sb.toString();
            }
            return element.toString();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class TreeDoubleClickListener
    implements IDoubleClickListener {
        private TreeDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object o;
            if (event.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IWatchable) {
                this.setWatched((IWatchable)o, true);
                RegistersView.this.tableProvider.update();
            }
        }

        private void setWatched(IWatchable o, boolean state) {
            o.setWatched(state);
            if (state) {
                RegistersView.this.fRegisterWatch.addRegisterWatch(o);
            } else {
                RegistersView.this.fRegisterWatch.removeRegisterWatch(o);
            }
        }
    }

    private class TreeViewContentProvider
    implements ITreeContentProvider {
        private TreeViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof IModelInfo) {
                return ((IModelInfo)parent).getChildren();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            if (RegistersView.this.fRegisterWatch == null) {
                return new Object[0];
            }
            if (parent.equals(RegistersView.this.getViewSite())) {
                return RegistersView.this.fRegisterWatch.getPart().getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IModelInfo) {
                return ((IModelInfo)child).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof IModelInfo) {
                return ((IModelInfo)parent).hasChildren();
            }
            return false;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        void update() {
            if (RegistersView.this.fRegisterWatch.getPart() == null) {
                RegistersView.this.treeView.getTree().clearAll(true);
                RegistersView.this.treeView.refresh();
                return;
            }
            Runnable update = new Runnable(){

                @Override
                public void run() {
                    if (RegistersView.this.treeView != null) {
                        RegistersView.this.treeView.refresh();
                    }
                }
            };
            Display.getDefault().syncExec(update);
        }
    }

    private class TreeViewLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private TreeViewLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IModelInfo) {
                IModelInfo info = (IModelInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return info.getName();
                    }
                    case 1: {
                        return info.getLocation();
                    }
                    case 2: {
                        return info.getDescription();
                    }
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IModelInfo) {
                return ((IModelInfo)element).getName();
            }
            return element.toString();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class UsedMap
    extends LinkedHashMap<String, String> {
        private static final int MAX_ENTRIES = 5;
        private static final long serialVersionUID = 1L;

        public UsedMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    }
}

