/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui;

import com.atmel.avr32.debug.AVR32NM;
import com.atmel.avr32.debug.ui.Messages;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SymbolSelectionDialog
extends SelectionDialog {
    private final String fInput;
    private TableViewer fTableViewer;
    private boolean fAddCancelButton = true;
    private final int widthInChars = 70;
    private final int heightInChars = 20;
    private SymbolType fType;
    private final ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(30), new ColumnWeightData(120)};
    private final String[] columnTitles = new String[]{Messages.SymbolSelectionDialog_Address, Messages.SymbolSelectionDialog_Length, Messages.SymbolSelectionDialog_Name};

    public SymbolSelectionDialog(Shell parent, SymbolType type, String path) {
        super(parent);
        this.fInput = path;
        this.fType = type;
        switch (type) {
            case ALL: {
                this.setTitle(Messages.SymbolSelectionDialog_Title_Address);
                this.setMessage(Messages.SymbolSelectionDialog_Message_Address);
                break;
            }
            case BSS: {
                this.setTitle(Messages.SymbolSelectionDialog_Title_Address);
                this.setMessage(Messages.SymbolSelectionDialog_Message_Address);
                break;
            }
            case TEXT: {
                this.setTitle(Messages.SymbolSelectionDialog_Title_Function);
                this.setMessage(Messages.SymbolSelectionDialog_Message_Function);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.fAddCancelButton) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(parent);
        }
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.fTableViewer = new TableViewer(parent, 66048);
        TableLayout layout = new TableLayout();
        this.fTableViewer.getTable().setLayout((Layout)layout);
        this.fTableViewer.getTable().setHeaderVisible(true);
        int i = 0;
        while (i < this.columnLayouts.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.fTableViewer.getTable(), 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnTitles[i]);
            ++i;
        }
        this.fTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new SymbolLabelProvider());
        this.fTableViewer.setInput((Object)this.fInput);
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SymbolSelectionDialog.this.fAddCancelButton) {
                    SymbolSelectionDialog.this.okPressed();
                }
            }
        });
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        gd.widthHint = this.convertWidthInCharsToPixels(70);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        return parent;
    }

    private Object[] getAddresses(String filename) {
        try {
            AVR32NM nm = new AVR32NM(filename);
            return nm.getBSSSymbols();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object[] getAllAddresses(String filename) {
        try {
            AVR32NM nm = new AVR32NM(filename);
            return nm.getCombinedSymbols();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object[] getFunctions(String filename) {
        try {
            AVR32NM nm = new AVR32NM(filename);
            return nm.getTextSymbols();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            String location = (String)inputElement;
            switch (SymbolSelectionDialog.this.fType) {
                case ALL: {
                    return SymbolSelectionDialog.this.getAllAddresses(location);
                }
                case BSS: {
                    return SymbolSelectionDialog.this.getAddresses(location);
                }
                case TEXT: {
                    return SymbolSelectionDialog.this.getFunctions(location);
                }
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class SymbolLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String HEX_PREFIX = "0x";

        private SymbolLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof AVR32NM.AddressNamePair) {
                switch (index) {
                    case 0: {
                        return HEX_PREFIX + Long.toHexString(((AVR32NM.AddressNamePair)obj).address);
                    }
                    case 1: {
                        return Long.toString(((AVR32NM.AddressNamePair)obj).size);
                    }
                    case 2: {
                        return ((AVR32NM.AddressNamePair)obj).name;
                    }
                }
            }
            return "";
        }
    }

    public static enum SymbolType {
        TEXT,
        BSS,
        ALL;

    }
}

