/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui;

import com.atmel.avr32.debug.ui.IRegisterView;
import com.atmel.avr32.debug.ui.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AVR32DebugUIPlugin
extends AbstractUIPlugin {
    public static final String NEWLINE = "\n";
    private static AVR32DebugUIPlugin plugin;
    public static final String PLUGIN_ID = "com.atmel.avr32.debug.ui";
    public static final String REGISTERS_VIEW_ID = "com.atmel.avr32.views.RegistersView";
    public static final String TOOLCHAIN_VERSION = "2.0.1";

    private static void appendMessage(StringBuffer sb, IStatus status) {
        if (!status.isOK()) {
            sb.append(NEWLINE);
            sb.append(status.getMessage());
            if (status.getException() != null) {
                sb.append(NEWLINE);
                sb.append(status.getException().getMessage());
            }
        }
    }

    public static void errorMessage(final String title, final String message) {
        final Display d = PlatformUI.getWorkbench().getDisplay();
        d.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)d.getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public static AVR32DebugUIPlugin getDefault() {
        return plugin;
    }

    public static IRegisterView getRegisterView() {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(REGISTERS_VIEW_ID);
        if (view instanceof IRegisterView) {
            return (IRegisterView)view;
        }
        return null;
    }

    public static ImageDescriptor getViewImageDescriptor(String relativePath) {
        return AVR32DebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + relativePath));
    }

    public static void infoMessage(final String title, final String message) {
        final Display d = PlatformUI.getWorkbench().getDisplay();
        d.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)d.getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public static void messageDialog(final IStatus status) {
        if (status.isOK()) {
            return;
        }
        final Display d = PlatformUI.getWorkbench().getDisplay();
        d.syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                AVR32DebugUIPlugin.appendMessage(sb, status);
                AVR32DebugUIPlugin.nestedStatus(status, sb);
                switch (status.getSeverity()) {
                    case 4: {
                        if (status.getCode() != 0) {
                            MessageDialog.openError((Shell)d.getActiveShell(), (String)Messages.AVR32DebugUIPlugin_Error, (String)sb.toString());
                            break;
                        }
                        MessageDialog.openError((Shell)d.getActiveShell(), (String)Messages.AVR32DebugUIPlugin_Error, (String)sb.toString());
                        break;
                    }
                    case 2: {
                        MessageDialog.openWarning((Shell)d.getActiveShell(), (String)Messages.AVR32DebugUIPlugin_Warning, (String)sb.toString());
                        break;
                    }
                    case 1: {
                        MessageDialog.openInformation((Shell)d.getActiveShell(), (String)Messages.AVR32DebugUIPlugin_Information, (String)sb.toString());
                        break;
                    }
                }
            }
        });
    }

    private static void nestedStatus(IStatus parent, StringBuffer sb) {
        if (parent.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = ((MultiStatus)parent).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                AVR32DebugUIPlugin.appendMessage(sb, status);
                if (status.isMultiStatus()) {
                    AVR32DebugUIPlugin.nestedStatus(status, sb);
                }
                ++n2;
            }
        }
    }

    public static void warningMessage(final String title, final String message) {
        final Display d = PlatformUI.getWorkbench().getDisplay();
        d.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)d.getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public AVR32DebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

