/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public final class TaskHyperlink
implements IHyperlink {
    private final IRegion region;
    private final TaskRepository repository;
    private final String taskId;

    public TaskHyperlink(IRegion region, TaskRepository repository, String taskId) {
        this.region = region;
        this.repository = repository;
        this.taskId = taskId;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTypeLabel() {
        return null;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public String getHyperlinkText() {
        return MessageFormat.format(Messages.TaskHyperlink_Open_Task_X_in_X, this.taskId, this.repository.getRepositoryLabel());
    }

    public void open() {
        if (this.repository != null) {
            TasksUiUtil.openTask(this.repository, this.taskId);
        } else {
            MessageDialog.openError(null, (String)"Mylyn", (String)Messages.TaskHyperlink_Could_not_determine_repository_for_report);
        }
    }
}

