/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.Collator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryElement;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskComparator;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IMemento;

public class TaskListSorter
extends ViewerSorter {
    private static final String MEMENTO_KEY_SORTER = "sorter";
    private static final String MEMENTO_KEY_GROUP_BY = "groupBy";
    private static final GroupBy DEFAULT_GROUP_BY = GroupBy.NONE;
    private final TaskComparator taskComparator = new TaskComparator();
    private GroupBy groupBy = GroupBy.CATEGORY_QUERY;
    private final SortElement key1 = new SortElement();
    private final SortElement key2 = new SortElement();

    public int compare(Viewer compareViewer, Object o1, Object o2) {
        if (o1 instanceof AbstractTask && o2 instanceof AbstractTask) {
            ITask element1 = (ITask)o1;
            ITask element2 = (ITask)o2;
            return this.compareElements(element1, element2);
        }
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer dateRangeTaskContainer1 = (ScheduledTaskContainer)o1;
            ScheduledTaskContainer dateRangeTaskContainer2 = (ScheduledTaskContainer)o2;
            return dateRangeTaskContainer1.getDateRange().compareTo(dateRangeTaskContainer2.getDateRange());
        }
        this.updateKey(this.key1, o1);
        this.updateKey(this.key2, o2);
        if (this.key1.weight != this.key2.weight) {
            return this.key1.weight - this.key2.weight < 0 ? -1 : 1;
        }
        int result = this.compare(this.key1.values[0], this.key2.values[0]);
        if (result != 0) {
            return result;
        }
        result = this.compare(this.key1.values[1], this.key2.values[1]);
        return result != 0 ? result : this.compare(this.key1.values[2], this.key2.values[2]);
    }

    private int compare(String key1, String key2) {
        if (key1 == null) {
            return key2 != null ? 1 : 0;
        }
        if (key2 == null) {
            return -1;
        }
        return Collator.getInstance().compare(key1, key2);
    }

    private void updateKey(SortElement key, Object object) {
        int weight = object instanceof AbstractTask ? 0 : (object instanceof UncategorizedTaskContainer ? 1 : (object instanceof UnsubmittedTaskContainer ? 2 : (object instanceof TaskCategory ? 3 : (object instanceof RepositoryQuery ? 4 : (object instanceof TaskGroup ? 5 : (object instanceof UnmatchedTaskContainer ? 6 : 99))))));
        ((SortElement)key).values[0] = ((AbstractTaskContainer)object).getSummary();
        ((SortElement)key).values[1] = null;
        ((SortElement)key).values[2] = null;
        switch (this.groupBy) {
            case NONE: {
                weight = 1;
                break;
            }
            case CATEGORY_QUERY: {
                break;
            }
            case CATEGORY_REPOSITORY: {
                if (weight == 1) break;
                if (weight == 3) {
                    weight = 2;
                    break;
                }
                ((SortElement)key).values[0] = this.getRepositoryUrl(object);
                ((SortElement)key).values[1] = String.valueOf(weight);
                ((SortElement)key).values[2] = ((AbstractTaskContainer)object).getSummary();
                weight = 3;
            }
        }
        key.weight = weight;
    }

    private String getRepositoryUrl(Object object) {
        if (object instanceof ITaskRepositoryElement) {
            ITaskRepositoryElement repositoryElement = (ITaskRepositoryElement)object;
            String repositoryUrl = repositoryElement.getRepositoryUrl();
            TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(repositoryElement.getConnectorKind(), repositoryUrl);
            return taskRepository != null ? taskRepository.getRepositoryLabel() : null;
        }
        return null;
    }

    private int compareElements(ITask element1, ITask element2) {
        return this.taskComparator.compare(element1, element2);
    }

    public TaskComparator getComparator() {
        return this.taskComparator;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy sortByIndex) {
        Assert.isNotNull((Object)((Object)sortByIndex));
        this.groupBy = sortByIndex;
    }

    public void restoreState(IMemento memento) {
        IMemento child = memento.getChild(MEMENTO_KEY_SORTER);
        if (child != null) {
            this.getComparator().restoreState(child);
        }
        this.setGroupBy(this.getGroupBy(memento, MEMENTO_KEY_GROUP_BY, DEFAULT_GROUP_BY));
    }

    public void saveState(IMemento memento) {
        IMemento child = memento.createChild(MEMENTO_KEY_SORTER);
        if (child != null) {
            this.getComparator().saveState(child);
        }
        memento.putString(MEMENTO_KEY_GROUP_BY, this.getGroupBy().name());
    }

    private GroupBy getGroupBy(IMemento memento, String key, GroupBy defaultValue) {
        String value = memento.getString(key);
        if (value != null) {
            try {
                return GroupBy.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GroupBy {
        NONE,
        CATEGORY_QUERY,
        CATEGORY_REPOSITORY;


        public String getLabel() {
            switch (this) {
                case NONE: {
                    return Messages.TaskListSorter_No_Grouping;
                }
                case CATEGORY_QUERY: {
                    return Messages.TaskListSorter_Catagory_and_Query;
                }
                case CATEGORY_REPOSITORY: {
                    return Messages.TaskListSorter_Catagory_and_Repository;
                }
            }
            return null;
        }

        public static GroupBy valueOfLabel(String label) {
            GroupBy[] groupByArray = GroupBy.values();
            int n = groupByArray.length;
            int n2 = 0;
            while (n2 < n) {
                GroupBy value = groupByArray[n2];
                if (value.getLabel().equals(label)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }
    }

    private class SortElement {
        private int weight;
        private final String[] values = new String[3];

        private SortElement() {
        }
    }
}

