/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksUiExtensionReader {
    public static final String EXTENSION_REPOSITORIES = "org.eclipse.mylyn.tasks.ui.repositories";
    public static final String EXTENSION_REPOSITORY_LINKS_PROVIDERS = "org.eclipse.mylyn.tasks.ui.projectLinkProviders";
    public static final String EXTENSION_TEMPLATES = "org.eclipse.mylyn.tasks.core.templates";
    public static final String EXTENSION_TMPL_REPOSITORY = "repository";
    public static final String ELMNT_TMPL_LABEL = "label";
    public static final String ELMNT_TMPL_URLREPOSITORY = "urlRepository";
    public static final String ELMNT_TMPL_REPOSITORYKIND = "repositoryKind";
    public static final String ELMNT_TMPL_CHARACTERENCODING = "characterEncoding";
    public static final String ELMNT_TMPL_ANONYMOUS = "anonymous";
    public static final String ELMNT_TMPL_VERSION = "version";
    public static final String ELMNT_TMPL_URLNEWTASK = "urlNewTask";
    public static final String ELMNT_TMPL_URLTASK = "urlTask";
    public static final String ELMNT_TMPL_URLTASKQUERY = "urlTaskQuery";
    public static final String ELMNT_TMPL_NEWACCOUNTURL = "urlNewAccount";
    public static final String ELMNT_TMPL_ADDAUTO = "addAutomatically";
    public static final String ELMNT_REPOSITORY_CONNECTOR = "connectorCore";
    public static final String ELMNT_REPOSITORY_LINK_PROVIDER = "linkProvider";
    public static final String ELMNT_REPOSITORY_UI = "connectorUi";
    public static final String ELMNT_MIGRATOR = "taskListMigrator";
    public static final String ATTR_BRANDING_ICON = "brandingIcon";
    public static final String ATTR_OVERLAY_ICON = "overlayIcon";
    public static final String ELMNT_TYPE = "type";
    public static final String ELMNT_QUERY_PAGE = "queryPage";
    public static final String ELMNT_SETTINGS_PAGE = "settingsPage";
    public static final String EXTENSION_TASK_CONTRIBUTOR = "org.eclipse.mylyn.tasks.ui.actions";
    public static final String ATTR_ACTION_CONTRIBUTOR_CLASS = "taskHandlerClass";
    public static final String DYNAMIC_POPUP_ELEMENT = "dynamicPopupMenu";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_MENU_PATH = "menuPath";
    public static final String EXTENSION_EDITORS = "org.eclipse.mylyn.tasks.ui.editors";
    public static final String ELMNT_TASK_EDITOR_PAGE_FACTORY = "pageFactory";
    public static final String EXTENSION_DUPLICATE_DETECTORS = "org.eclipse.mylyn.tasks.ui.duplicateDetectors";
    public static final String ELMNT_DUPLICATE_DETECTOR = "detector";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_KIND = "kind";
    private static final String EXTENSION_PRESENTATIONS = "org.eclipse.mylyn.tasks.ui.presentations";
    public static final String ELMNT_PRESENTATION = "presentation";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_PRIMARY = "primary";
    public static final String ATTR_ID = "id";
    private static boolean coreExtensionsRead = false;

    public static void initStartupExtensions(TaskListExternalizer taskListExternalizer) {
        if (!coreExtensionsRead) {
            IExtension[] editors;
            IExtension[] presentations;
            IConfigurationElement templateExtensions;
            IConfigurationElement element22;
            IExtension[] repositoryExtensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            ArrayList<AbstractTaskListMigrator> migrators = new ArrayList<AbstractTaskListMigrator>();
            IExtensionPoint repositoriesExtensionPoint = registry.getExtensionPoint(EXTENSION_REPOSITORIES);
            IExtension[] iExtensionArray = repositoryExtensions = repositoriesExtensionPoint.getExtensions();
            int n = repositoryExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension repositoryExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = repositoryExtension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    element22 = iConfigurationElementArray[n4];
                    if (element22.getName().equals(ELMNT_REPOSITORY_CONNECTOR)) {
                        TasksUiExtensionReader.readRepositoryConnectorCore(element22);
                    } else if (element22.getName().equals(ELMNT_MIGRATOR)) {
                        TasksUiExtensionReader.readMigrator(element22, migrators);
                    }
                    ++n4;
                }
                ++n2;
            }
            taskListExternalizer.initialize(migrators);
            IExtensionPoint templatesExtensionPoint = registry.getExtensionPoint(EXTENSION_TEMPLATES);
            element22 = templateExtensions = templatesExtensionPoint.getExtensions();
            int elements = ((IExtension[])element22).length;
            int n5 = 0;
            while (n5 < elements) {
                IConfigurationElement[] elements2;
                IConfigurationElement templateExtension = element22[n5];
                IConfigurationElement[] iConfigurationElementArray = elements2 = templateExtension.getConfigurationElements();
                int n6 = elements2.length;
                int n7 = 0;
                while (n7 < n6) {
                    IConfigurationElement element = iConfigurationElementArray[n7];
                    if (element.getName().equals(EXTENSION_TMPL_REPOSITORY)) {
                        TasksUiExtensionReader.readRepositoryTemplate(element);
                    }
                    ++n7;
                }
                ++n5;
            }
            IExtensionPoint presentationsExtensionPoint = registry.getExtensionPoint(EXTENSION_PRESENTATIONS);
            IExtension[] iExtensionArray2 = presentations = presentationsExtensionPoint.getExtensions();
            int elements2 = presentations.length;
            int element22 = 0;
            while (element22 < elements2) {
                IConfigurationElement[] elements3;
                IExtension presentation = iExtensionArray2[element22];
                IConfigurationElement[] iConfigurationElementArray = elements3 = presentation.getConfigurationElements();
                int n8 = elements3.length;
                int n9 = 0;
                while (n9 < n8) {
                    IConfigurationElement element = iConfigurationElementArray[n9];
                    TasksUiExtensionReader.readPresentation(element);
                    ++n9;
                }
                ++element22;
            }
            IExtensionPoint editorsExtensionPoint = registry.getExtensionPoint(EXTENSION_EDITORS);
            IExtension[] iExtensionArray3 = editors = editorsExtensionPoint.getExtensions();
            int n10 = editors.length;
            int n11 = 0;
            while (n11 < n10) {
                IConfigurationElement[] elements4;
                IExtension editor = iExtensionArray3[n11];
                IConfigurationElement[] iConfigurationElementArray = elements4 = editor.getConfigurationElements();
                int n12 = elements4.length;
                int n13 = 0;
                while (n13 < n12) {
                    IConfigurationElement element = iConfigurationElementArray[n13];
                    if (element.getName().equals(ELMNT_TASK_EDITOR_PAGE_FACTORY)) {
                        TasksUiExtensionReader.readTaskEditorPageFactory(element);
                    }
                    ++n13;
                }
                ++n11;
            }
            coreExtensionsRead = true;
        }
    }

    public static void initWorkbenchUiExtensions() {
        IExtension[] extensions;
        IExtension[] dulicateDetectorsExtensions;
        IConfigurationElement linkProvidersExtensions;
        IConfigurationElement element22;
        IExtension[] repositoryExtensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint repositoriesExtensionPoint = registry.getExtensionPoint(EXTENSION_REPOSITORIES);
        IExtension[] iExtensionArray = repositoryExtensions = repositoriesExtensionPoint.getExtensions();
        int n = repositoryExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension repositoryExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = repositoryExtension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                element22 = iConfigurationElementArray[n4];
                if (element22.getName().equals(ELMNT_REPOSITORY_UI)) {
                    TasksUiExtensionReader.readRepositoryConnectorUi(element22);
                }
                ++n4;
            }
            ++n2;
        }
        IExtensionPoint linkProvidersExtensionPoint = registry.getExtensionPoint(EXTENSION_REPOSITORY_LINKS_PROVIDERS);
        element22 = linkProvidersExtensions = linkProvidersExtensionPoint.getExtensions();
        int elements = ((IExtension[])element22).length;
        int n5 = 0;
        while (n5 < elements) {
            IConfigurationElement[] elements2;
            IExtension linkProvidersExtension = element22[n5];
            IConfigurationElement[] iConfigurationElementArray = elements2 = linkProvidersExtension.getConfigurationElements();
            int n6 = elements2.length;
            int n7 = 0;
            while (n7 < n6) {
                IConfigurationElement element = iConfigurationElementArray[n7];
                if (element.getName().equals(ELMNT_REPOSITORY_LINK_PROVIDER)) {
                    TasksUiExtensionReader.readLinkProvider(element);
                }
                ++n7;
            }
            ++n5;
        }
        IExtensionPoint duplicateDetectorsExtensionPoint = registry.getExtensionPoint(EXTENSION_DUPLICATE_DETECTORS);
        IExtension[] iExtensionArray2 = dulicateDetectorsExtensions = duplicateDetectorsExtensionPoint.getExtensions();
        int elements2 = dulicateDetectorsExtensions.length;
        int element22 = 0;
        while (element22 < elements2) {
            IConfigurationElement[] elements3;
            IExtension dulicateDetectorsExtension = iExtensionArray2[element22];
            IConfigurationElement[] iConfigurationElementArray = elements3 = dulicateDetectorsExtension.getConfigurationElements();
            int n8 = elements3.length;
            int n9 = 0;
            while (n9 < n8) {
                IConfigurationElement element = iConfigurationElementArray[n9];
                if (element.getName().equals(ELMNT_DUPLICATE_DETECTOR)) {
                    TasksUiExtensionReader.readDuplicateDetector(element);
                }
                ++n9;
            }
            ++element22;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_TASK_CONTRIBUTOR);
        IExtension[] iExtensionArray3 = extensions = extensionPoint.getExtensions();
        int n10 = extensions.length;
        int n11 = 0;
        while (n11 < n10) {
            IConfigurationElement[] elements4;
            IExtension extension = iExtensionArray3[n11];
            IConfigurationElement[] iConfigurationElementArray = elements4 = extension.getConfigurationElements();
            int n12 = elements4.length;
            int n13 = 0;
            while (n13 < n12) {
                IConfigurationElement element = iConfigurationElementArray[n13];
                if (element.getName().equals(DYNAMIC_POPUP_ELEMENT)) {
                    TasksUiExtensionReader.readDynamicPopupContributor(element);
                }
                ++n13;
            }
            ++n11;
        }
    }

    private static void readPresentation(IConfigurationElement element) {
        try {
            String name = element.getAttribute(ATTR_NAME);
            String iconPath = element.getAttribute(ATTR_ICON);
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath);
            AbstractTaskListPresentation presentation = (AbstractTaskListPresentation)element.createExecutableExtension(ATTR_CLASS);
            presentation.setPluginId(element.getNamespaceIdentifier());
            presentation.setImageDescriptor(imageDescriptor);
            presentation.setName(name);
            String primary = element.getAttribute(ATTR_PRIMARY);
            if (primary != null && primary.equals("true")) {
                presentation.setPrimary(true);
            }
            TaskListView.addPresentation(presentation);
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load presentation extension", e));
        }
    }

    private static void readDuplicateDetector(IConfigurationElement element) {
        try {
            Object obj = element.createExecutableExtension(ATTR_CLASS);
            if (obj instanceof AbstractDuplicateDetector) {
                AbstractDuplicateDetector duplicateDetector = (AbstractDuplicateDetector)obj;
                duplicateDetector.setName(element.getAttribute(ATTR_NAME));
                duplicateDetector.setConnectorKind(element.getAttribute(ATTR_KIND));
                TasksUiPlugin.getDefault().addDuplicateDetector(duplicateDetector);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load duplicate detector " + obj.getClass().getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load duplicate detector", e));
        }
    }

    private static void readLinkProvider(IConfigurationElement element) {
        try {
            Object repositoryLinkProvider = element.createExecutableExtension(ATTR_CLASS);
            if (repositoryLinkProvider instanceof AbstractTaskRepositoryLinkProvider) {
                TasksUiPlugin.getDefault().addRepositoryLinkProvider((AbstractTaskRepositoryLinkProvider)repositoryLinkProvider);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository link provider " + repositoryLinkProvider.getClass().getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository link provider", e));
        }
    }

    private static void readTaskEditorPageFactory(IConfigurationElement element) {
        String id = element.getAttribute(ATTR_ID);
        if (id == null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Editor page factory must specify id"));
            return;
        }
        try {
            Object item = element.createExecutableExtension(ATTR_CLASS);
            if (item instanceof AbstractTaskEditorPageFactory) {
                AbstractTaskEditorPageFactory editorPageFactory = (AbstractTaskEditorPageFactory)item;
                editorPageFactory.setId(id);
                editorPageFactory.setPluginId(element.getNamespaceIdentifier());
                TasksUiPlugin.getDefault().addTaskEditorPageFactory(editorPageFactory);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load editor page factory " + item.getClass().getCanonicalName() + " must implement " + AbstractTaskEditorPageFactory.class.getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load page editor factory", e));
        }
    }

    private static void readRepositoryConnectorCore(IConfigurationElement element) {
        try {
            Object connectorCore = element.createExecutableExtension(ATTR_CLASS);
            if (connectorCore instanceof AbstractRepositoryConnector) {
                AbstractRepositoryConnector repositoryConnector = (AbstractRepositoryConnector)connectorCore;
                TasksUiPlugin.getRepositoryManager().addRepositoryConnector(repositoryConnector);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector core " + connectorCore.getClass().getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector core", e));
        }
    }

    private static void readRepositoryConnectorUi(IConfigurationElement element) {
        try {
            Object connectorUiObject = element.createExecutableExtension(ATTR_CLASS);
            if (connectorUiObject instanceof AbstractRepositoryConnectorUi) {
                ImageDescriptor descriptor;
                String overlayIconPath;
                ImageDescriptor descriptor2;
                AbstractRepositoryConnectorUi connectorUi = (AbstractRepositoryConnectorUi)connectorUiObject;
                TasksUiPlugin.getDefault().addRepositoryConnectorUi(connectorUi);
                String iconPath = element.getAttribute(ATTR_BRANDING_ICON);
                if (iconPath != null && (descriptor2 = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath)) != null) {
                    TasksUiPlugin.getDefault().addBrandingIcon(connectorUi.getConnectorKind(), CommonImages.getImage((ImageDescriptor)descriptor2));
                }
                if ((overlayIconPath = element.getAttribute(ATTR_OVERLAY_ICON)) != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)overlayIconPath)) != null) {
                    TasksUiPlugin.getDefault().addOverlayIcon(connectorUi.getConnectorKind(), descriptor);
                }
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector ui " + connectorUiObject.getClass().getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector ui", e));
        }
    }

    private static void readRepositoryTemplate(IConfigurationElement element) {
        boolean anonymous = false;
        boolean addAuto = false;
        String label = element.getAttribute(ELMNT_TMPL_LABEL);
        String serverUrl = element.getAttribute(ELMNT_TMPL_URLREPOSITORY);
        String repKind = element.getAttribute(ELMNT_TMPL_REPOSITORYKIND);
        String version = element.getAttribute(ELMNT_TMPL_VERSION);
        String newTaskUrl = element.getAttribute(ELMNT_TMPL_URLNEWTASK);
        String taskPrefix = element.getAttribute(ELMNT_TMPL_URLTASK);
        String taskQueryUrl = element.getAttribute(ELMNT_TMPL_URLTASKQUERY);
        String newAccountUrl = element.getAttribute(ELMNT_TMPL_NEWACCOUNTURL);
        String encoding = element.getAttribute(ELMNT_TMPL_CHARACTERENCODING);
        addAuto = Boolean.parseBoolean(element.getAttribute(ELMNT_TMPL_ADDAUTO));
        anonymous = Boolean.parseBoolean(element.getAttribute(ELMNT_TMPL_ANONYMOUS));
        if (serverUrl != null && label != null && repKind != null && TasksUi.getRepositoryManager().getRepositoryConnector(repKind) != null) {
            RepositoryTemplate template = new RepositoryTemplate(label, serverUrl, encoding, version, newTaskUrl, taskPrefix, taskQueryUrl, newAccountUrl, anonymous, addAuto);
            TasksUiPlugin.getRepositoryTemplateManager().addTemplate(repKind, template);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String name = configElement.getAttribute(ATTR_NAME);
                String value = configElement.getAttribute("value");
                if (name != null && !name.equals("") && value != null) {
                    template.addAttribute(name, value);
                }
                ++n2;
            }
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository template extension " + element.getName()));
        }
    }

    private static void readDynamicPopupContributor(IConfigurationElement element) {
        try {
            Object dynamicPopupContributor = element.createExecutableExtension(ATTR_CLASS);
            String menuPath = element.getAttribute(ATTR_MENU_PATH);
            if (dynamicPopupContributor instanceof IDynamicSubMenuContributor) {
                TasksUiPlugin.getDefault().addDynamicPopupContributor(menuPath, (IDynamicSubMenuContributor)dynamicPopupContributor);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load dynamic popup menu: " + dynamicPopupContributor.getClass().getCanonicalName() + " must implement " + IDynamicSubMenuContributor.class.getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load dynamic popup menu extension", e));
        }
    }

    private static void readMigrator(IConfigurationElement element, List<AbstractTaskListMigrator> migrators) {
        try {
            Object migratorObject = element.createExecutableExtension(ATTR_CLASS);
            if (migratorObject instanceof AbstractTaskListMigrator) {
                AbstractTaskListMigrator migrator = (AbstractTaskListMigrator)migratorObject;
                migrators.add(migrator);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load task list migrator migrator: " + migratorObject.getClass().getCanonicalName() + " must implement " + AbstractTaskListMigrator.class.getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load task list migrator extension", e));
        }
    }
}

