/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlink;

public class TaskUrlHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final Pattern URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]*[a-zA-Z0-9%_~!$&?#'(*+;:@/=-])");

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int offsetInLine = offset - lineInfo.getOffset();
        int regionLength = region.getLength();
        ArrayList<TaskUrlHyperlink> hyperlinks = null;
        Matcher matcher = URL_PATTERN.matcher(line);
        while (matcher.find()) {
            int urlOffsetInLine = matcher.start(1);
            int endUrlOffsetInLine = matcher.end(1);
            if ((regionLength != 0 || offsetInLine < urlOffsetInLine || offsetInLine > endUrlOffsetInLine) && (regionLength <= 0 || offsetInLine > urlOffsetInLine || offsetInLine + regionLength <= urlOffsetInLine)) continue;
            try {
                String urlString = matcher.group(1);
                new URL(urlString);
                if (hyperlinks == null) {
                    hyperlinks = new ArrayList<TaskUrlHyperlink>(5);
                }
                Region urlRegion = new Region(lineInfo.getOffset() + urlOffsetInLine, endUrlOffsetInLine - urlOffsetInLine);
                hyperlinks.add(new TaskUrlHyperlink((IRegion)urlRegion, urlString));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return hyperlinks == null ? null : hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }
}

