/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class QueryCloneAction
extends Action
implements IViewActionDelegate {
    protected ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run(this.getSelectedQuery(this.selection));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        RepositoryQuery selectedQuery = this.getSelectedQuery(selection);
        action.setEnabled(true);
        if (selectedQuery != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    protected RepositoryQuery getSelectedQuery(ISelection newSelection) {
        Object selectedObject;
        if (this.selection instanceof StructuredSelection && ((StructuredSelection)this.selection).size() == 1 && (selectedObject = ((StructuredSelection)this.selection).getFirstElement()) instanceof IRepositoryQuery) {
            return (RepositoryQuery)selectedObject;
        }
        return null;
    }

    public void run(RepositoryQuery selectedQuery) {
        if (selectedQuery == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.QueryCloneAction_Clone_Query, (String)Messages.QueryCloneAction_No_query_selected);
            return;
        }
        ArrayList<RepositoryQuery> queries = new ArrayList<RepositoryQuery>();
        queries.add(selectedQuery);
        ArrayList<RepositoryQuery> clonedQueries = new ArrayList<RepositoryQuery>(queries.size());
        for (RepositoryQuery query : queries) {
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
            RepositoryQuery clonedQuery = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(repository);
            clonedQuery.setSummary(NLS.bind((String)Messages.QueryCloneAction_Copy_of_X, (Object)query.getSummary()));
            clonedQuery.setUrl(query.getUrl());
            Map attributes = query.getAttributes();
            for (Map.Entry entry : attributes.entrySet()) {
                clonedQuery.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            clonedQueries.add(clonedQuery);
        }
        for (RepositoryQuery query : clonedQueries) {
            TasksUiPlugin.getTaskList().addQuery(query);
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(query.getConnectorKind());
            TasksUiInternal.openEditQueryDialog(connectorUi, (IRepositoryQuery)query);
        }
    }
}

