/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.cygwin;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.gnu.cygwin.CygwinPathResolver;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;

public class GnuCygwinConfigurationEnvironmentSupplier
implements IConfigurationEnvironmentVariableSupplier {
    static final String VARNAME = "PATH";
    static final String DELIMITER_UNIX = ":";
    static final String PROPERTY_DELIMITER = "path.separator";
    static final String PROPERTY_OSNAME = "os.name";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (!System.getProperty(PROPERTY_OSNAME).toLowerCase().startsWith("windows ")) {
            return null;
        }
        if (variableName == null) {
            return null;
        }
        if (!VARNAME.equalsIgnoreCase(variableName)) {
            return null;
        }
        String p = CygwinPathResolver.getBinPath();
        if (p != null) {
            return new BuildEnvVar(VARNAME, p.replace('/', '\\'), 3, System.getProperty(PROPERTY_DELIMITER, DELIMITER_UNIX));
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] tmp = new IBuildEnvironmentVariable[]{this.getVariable(VARNAME, configuration, provider)};
        if (tmp[0] != null) {
            return tmp;
        }
        return null;
    }
}

