/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.core;

import org.eclipse.equinox.internal.provisional.p2.core.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;
import org.eclipse.equinox.internal.provisional.p2.core.VersionParser;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.VersionVector;
import org.eclipse.osgi.util.NLS;

public class Version
extends VersionVector {
    private static final Integer[] cache = new Integer[100];
    private static final char[] allowedOSGiChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-".toCharArray();
    public static final Integer ZERO_INT = new Integer(0);
    public static final Integer MAX_INT_OBJ = new Integer(Integer.MAX_VALUE);
    public static final Version emptyVersion;
    public static final Version MAX_VERSION;
    public static final Version MIN_VERSION;
    private static final long serialVersionUID = 8202715438560849928L;
    private VersionFormat format;
    private String original;

    static {
        Version.cache[0] = ZERO_INT;
        int i = 1;
        while (i < cache.length) {
            Version.cache[i] = new Integer(i);
            ++i;
        }
        emptyVersion = new Version(0, 0, 0);
        MAX_VERSION = new Version("raw:MpM");
        MIN_VERSION = new Version("raw:-M");
    }

    static Integer valueOf(int i) {
        try {
            return cache[i];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return i == Integer.MAX_VALUE ? MAX_INT_OBJ : new Integer(i);
        }
    }

    public static Version createOSGi(int major, int minor, int micro) {
        return Version.createOSGi(major, minor, micro, null);
    }

    public static Version createOSGi(int major, int minor, int micro, String qualifier) {
        return new Version(major, minor, micro, qualifier);
    }

    public static Version fromOSGiVersion(org.osgi.framework.Version version) {
        if (version == null) {
            return null;
        }
        if (version.equals((Object)org.osgi.framework.Version.emptyVersion)) {
            return emptyVersion;
        }
        return new Version(version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    public static Version create(String version) {
        if (version != null) {
            Version v = new Version();
            if (VersionParser.parseInto(version, 0, version.length(), v)) {
                return v;
            }
        }
        return null;
    }

    public static Version parseVersion(String version) {
        if (version == null || version.length() == 0 || "0.0.0".equals(version)) {
            return emptyVersion;
        }
        Version v = Version.create(version);
        return v == null ? emptyVersion : v;
    }

    public static org.osgi.framework.Version toOSGiVersion(Version version) {
        if (version == null) {
            return null;
        }
        if (version.equals(emptyVersion)) {
            return org.osgi.framework.Version.emptyVersion;
        }
        return new org.osgi.framework.Version(version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    private static String getOSGiEntryName(int i) {
        String name = null;
        switch (i) {
            case 0: {
                name = "major";
                break;
            }
            case 1: {
                name = "minor";
                break;
            }
            case 2: {
                name = "micro";
                break;
            }
            case 3: {
                name = "qualifier";
            }
        }
        return name;
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        if (qualifier != null && qualifier.length() == 0) {
            qualifier = null;
        }
        Comparable[] vector = new Comparable[qualifier == null ? 3 : 4];
        vector[0] = Version.valueOf(major);
        vector[1] = Version.valueOf(minor);
        vector[2] = Version.valueOf(micro);
        if (qualifier != null) {
            vector[3] = qualifier;
        }
        this.init(vector, null, VersionFormat.OSGI_FORMAT, null);
        this.validateOSGI(true);
    }

    public Version(String version) {
        if (!VersionParser.parseInto(version, 0, version.length(), this)) {
            this.init(new Comparable[]{ZERO_INT, ZERO_INT, ZERO_INT}, null, VersionFormat.OSGI_FORMAT, null);
        }
    }

    Version() {
    }

    Version(Comparable[] array, Comparable padValue, VersionFormat format, String original) {
        this.init(array, padValue, format, original);
    }

    public VersionFormat getFormat() {
        return this.format;
    }

    public int getMajor() {
        return this.getIntElement(0);
    }

    public int getMicro() {
        return this.getIntElement(2);
    }

    public int getMinor() {
        return this.getIntElement(1);
    }

    public String getOriginal() {
        return this.original;
    }

    public String getQualifier() {
        Comparable[] vector = this.getVector();
        if (vector.length < 4) {
            return null;
        }
        if (!(vector[3] instanceof String)) {
            throw new UnsupportedOperationException();
        }
        return (String)((Object)vector[3]);
    }

    public boolean isOSGiCompatible() {
        return this.format == VersionFormat.OSGI_FORMAT || this.validateOSGI(false);
    }

    public void originalToString(StringBuffer sb, boolean rangeSafe) {
        if (this.original != null) {
            if (rangeSafe) {
                String s = this.original;
                int end = s.length();
                int idx = 0;
                while (idx < end) {
                    char c = s.charAt(idx);
                    if (c == '\\' || c == '[' || c == '(' || c == ']' || c == ')' || c == ',' || c <= ' ') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    ++idx;
                }
            } else {
                sb.append(this.original);
            }
        }
    }

    public void rawToString(StringBuffer sb, boolean rangeSafe) {
        super.toString(sb, rangeSafe);
    }

    public void toString(StringBuffer sb) {
        if (this.format == VersionFormat.OSGI_FORMAT) {
            Comparable[] vector = this.getVector();
            sb.append(vector[0]);
            sb.append('.');
            sb.append(vector[1]);
            sb.append('.');
            sb.append(vector[2]);
            if (vector.length > 3) {
                sb.append('.');
                sb.append(vector[3]);
            }
            return;
        }
        sb.append("raw:");
        super.toString(sb, false);
        if (this.format != null || this.original != null) {
            sb.append('/');
            if (this.format != null) {
                this.format.toString(sb);
            }
            if (this.original != null) {
                sb.append(':');
                this.originalToString(sb, false);
            }
        }
    }

    void init(Comparable[] vec, Comparable pad, VersionFormat fmt, String orig) {
        this.init(vec, pad);
        this.format = fmt;
        if (fmt != VersionFormat.OSGI_FORMAT) {
            this.original = orig;
        }
    }

    private int getIntElement(int i) {
        Comparable[] vector = this.getVector();
        if (vector.length <= i || !(vector[i] instanceof Integer)) {
            throw new UnsupportedOperationException();
        }
        return (Integer)vector[i];
    }

    private Object readResolve() {
        Version v = this;
        if (this.equals(MAX_VERSION)) {
            v = MAX_VERSION;
        } else if (this.equals(MIN_VERSION)) {
            v = MIN_VERSION;
        } else if (this.equals(emptyVersion)) {
            v = emptyVersion;
        } else if (this.equals(VersionRange.OSGi_versionMax)) {
            v = VersionRange.OSGi_versionMax;
        } else if (this.equals(VersionRange.OSGi_versionMin)) {
            v = VersionRange.OSGi_versionMin;
        }
        return v;
    }

    boolean validateOSGI(boolean throwDetailed) {
        Comparable[] vector = this.getVector();
        if (vector.length < 3 || vector.length > 4) {
            if (throwDetailed) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.illegal_number_of_entries_0_in_osgi_1, (Object)Version.valueOf(vector.length), (Object)this));
            }
            return false;
        }
        if (this.getPad() != null) {
            if (throwDetailed) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.pad_not_allowed_in_osgi_0, (Object)this));
            }
            return false;
        }
        int i = 0;
        while (i < 3) {
            Comparable e = vector[i];
            if (!(e instanceof Integer) || (Integer)e < 0) {
                if (throwDetailed) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages._0_is_not_a_positive_integer_in_osgi_1, (Object)Version.getOSGiEntryName(i), (Object)this));
                }
                return false;
            }
            ++i;
        }
        if (vector.length == 4) {
            Comparable e = vector[3];
            if (!(e instanceof String)) {
                if (throwDetailed) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages._0_is_not_a_string_in_osgi_1, (Object)Version.getOSGiEntryName(3), (Object)this));
                }
                return false;
            }
            String s = (String)((Object)e);
            int idx = s.length();
            char[] allowed = allowedOSGiChars;
            int ctop = allowed.length;
            block1: while (--idx >= 0) {
                char c = s.charAt(idx);
                int cdx = ctop;
                while (--cdx >= 0) {
                    if (c == allowed[cdx]) continue block1;
                }
                if (throwDetailed) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages._0_is_not_a_valid_qualifier_in_osgi_1, (Object)Version.getOSGiEntryName(3), (Object)this));
                }
                return false;
            }
        }
        return true;
    }
}

