/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.token;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class HyperlinkReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "\\[([^\\]]+)\\]";
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkReplacementTokenProcessor();
    }

    private static class HyperlinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkReplacementTokenProcessor() {
        }

        public void emit() {
            String tip;
            String href;
            String text;
            String linkComposite = this.group(1);
            String[] parts = linkComposite.split("\\s*\\|\\s*");
            String string = text = parts.length > 1 ? parts[0] : null;
            if (text != null) {
                text = text.trim();
            }
            String string2 = href = parts.length > 1 ? parts[1] : parts[0];
            if (href != null) {
                href = href.trim();
            }
            String string3 = tip = parts.length > 2 ? parts[2] : null;
            if (tip != null) {
                tip = tip.trim();
            }
            if ((text == null || text.length() == 0) && (text = href).length() > 0 && text.charAt(0) == '#') {
                text = text.substring(1);
            }
            LinkAttributes attributes = new LinkAttributes();
            attributes.setTitle(tip);
            this.getBuilder().link((Attributes)attributes, href, text);
        }
    }
}

