/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.phrase;

import org.eclipse.mylyn.internal.wikitext.confluence.core.util.Options;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class ImagePhraseModifier
extends PatternBasedElement {
    protected static final int CONTENT_GROUP = 1;
    private static final int OPTIONS_GROUP = 2;

    protected String getPattern(int groupOffset) {
        return "!([^\\|!\\s]+)(?:\\|([^!]*))?!";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ImagePhraseModifierProcessor();
    }

    private static class ImagePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private ImagePhraseModifierProcessor() {
        }

        public void emit() {
            String imageUrl = this.group(1);
            String imageOptions = this.group(2);
            final ImageAttributes attributes = new ImageAttributes();
            if (imageOptions != null) {
                Options.parseOptions(imageOptions, new Options.Handler(){

                    public void setOption(String key, String value) {
                        if ("alt".equalsIgnoreCase(key)) {
                            attributes.setAlt(value);
                        } else if ("align".equalsIgnoreCase(key)) {
                            if ("middle".equalsIgnoreCase(value)) {
                                attributes.setAlign(ImageAttributes.Align.Middle);
                            } else if ("left".equalsIgnoreCase(value)) {
                                attributes.setAlign(ImageAttributes.Align.Left);
                            } else if ("right".equalsIgnoreCase(value)) {
                                attributes.setAlign(ImageAttributes.Align.Right);
                            } else if ("center".equalsIgnoreCase(value)) {
                                attributes.setAlign(ImageAttributes.Align.Center);
                            }
                        } else {
                            try {
                                if ("border".equalsIgnoreCase(key)) {
                                    attributes.setBorder(Integer.parseInt(value));
                                } else if ("height".equalsIgnoreCase(key)) {
                                    attributes.setHeight(Integer.parseInt(value));
                                } else if ("width".equalsIgnoreCase(key)) {
                                    attributes.setWidth(Integer.parseInt(value));
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }

                    public void setOption(String option) {
                    }
                });
            }
            this.builder.image((Attributes)attributes, imageUrl);
        }
    }
}

