/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.views;

import com.atmel.avr32.debug.ui.disassembly.model.AddressRangePosition;
import com.atmel.avr32.debug.ui.disassembly.model.DisassemblyDocument;
import com.atmel.avr32.debug.ui.disassembly.model.DisassemblyPosition;
import com.atmel.avr32.debug.ui.disassembly.views.DisassemblyRulerColumn;
import org.eclipse.jface.text.BadLocationException;

public class OpcodeRulerColumn
extends DisassemblyRulerColumn {
    @Override
    protected String createDisplayString(int line) {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        try {
            int offset = doc.getLineOffset(line);
            AddressRangePosition pos = doc.getDisassemblyPosition(offset);
            if (pos instanceof DisassemblyPosition && pos.length > 0 && pos.offset == offset && pos.fValid) {
                DisassemblyPosition disassPos = (DisassemblyPosition)pos;
                return new String(disassPos.fOpcodes);
            }
            if (pos != null && !pos.fValid) {
                return "......................................................................".substring(0, doc.getMaxOpcodeLength());
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    @Override
    protected int computeNumberOfCharacters() {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        return doc.getMaxOpcodeLength();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }
}

