/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.views;

import com.atmel.avr32.debug.ui.disassembly.DisassemblyPlugin;
import com.atmel.avr32.debug.ui.disassembly.model.AddressRangePosition;
import com.atmel.avr32.debug.ui.disassembly.model.DisassemblyDocument;
import com.atmel.avr32.debug.ui.disassembly.model.DisassemblyPosition;
import com.atmel.avr32.debug.ui.disassembly.model.LabelPosition;
import com.atmel.avr32.debug.ui.disassembly.model.SourcePosition;
import com.atmel.avr32.debug.ui.disassembly.views.DisassemblyPart;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;

public class DisassemblyTextHover
implements ITextHover {
    private DisassemblyPart fPart;

    public DisassemblyTextHover(DisassemblyPart part) {
        this.fPart = part;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument doc = textViewer.getDocument();
        return CWordFinder.findWord((IDocument)doc, (int)offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block8: {
            DisassemblyDocument doc = (DisassemblyDocument)textViewer.getDocument();
            int offset = hoverRegion.getOffset();
            try {
                String ident = doc.get(offset, hoverRegion.getLength());
                String value = null;
                AddressRangePosition pos = doc.getModelPosition(offset);
                if (pos instanceof SourcePosition) {
                    value = this.evaluateExpression(ident);
                } else if (pos instanceof LabelPosition) {
                    value = this.evaluateExpression(ident);
                } else if (pos instanceof DisassemblyPosition && (value = this.evaluateRegister(ident)) == null) {
                    value = this.evaluateExpression(ident);
                }
                if (value != null) {
                    return String.valueOf(ident) + " = " + value;
                }
            }
            catch (BadLocationException e) {
                if (!DisassemblyPlugin.getDefault().isDebugging()) break block8;
                DisassemblyPlugin.logError("Internal Error", e);
            }
        }
        return null;
    }

    private String evaluateRegister(String register) {
        return null;
    }

    private String evaluateExpression(String expr) {
        return null;
    }
}

