/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.ui.disassembly.views;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DisassemblyRulerColumn
implements IVerticalRulerColumn {
    protected static final String DOTS = "......................................................................";
    protected static final String SPACES = "                                                                      ";
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private Font fFont;
    private int[] fIndentation;
    private boolean fSensitiveToTextChanges = false;
    private Color fForeground;
    private Color fBackground;
    private int fCachedNumberOfDigits = -1;
    private boolean fRelayoutRequired = false;
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DisassemblyRulerColumn.this.fRunnableLock;
            synchronized (object) {
                DisassemblyRulerColumn.this.fIsRunnablePosted = false;
            }
            DisassemblyRulerColumn.this.redraw();
        }
    };
    private boolean fAlignRight;
    private boolean fPaintStyleBackground;
    private boolean fPaintSelectionBackground;

    public DisassemblyRulerColumn() {
        this(16384);
    }

    public DisassemblyRulerColumn(int align) {
        this(align, true, false);
    }

    public DisassemblyRulerColumn(int align, boolean paintSelection, boolean paintStyle) {
        this.fAlignRight = (align & 0x20000) != 0;
        this.fPaintSelectionBackground = paintSelection;
        this.fPaintStyleBackground = paintStyle;
    }

    public void setForeground(Color foreground) {
        this.fForeground = foreground;
    }

    protected Color getForeground() {
        return this.fForeground;
    }

    public void setBackground(Color background) {
        this.fBackground = background;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.fBackground == null) {
            return display.getSystemColor(25);
        }
        return this.fBackground;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fIndentation[0];
    }

    protected boolean updateNumberOfDigits() {
        if (this.fCachedTextViewer == null) {
            return false;
        }
        int digits = this.computeNumberOfCharacters();
        if (this.fCachedNumberOfDigits != digits) {
            this.fCachedNumberOfDigits = digits;
            return true;
        }
        return false;
    }

    protected int computeNumberOfCharacters() {
        IDocument document = this.fCachedTextViewer.getDocument();
        int lines = document == null ? 0 : document.getNumberOfLines();
        int digits = 2;
        while ((double)lines > Math.pow(10.0, digits) - 1.0) {
            ++digits;
        }
        return digits;
    }

    protected void layout(boolean redraw) {
        ITextViewerExtension extension;
        Control control;
        if (!redraw) {
            this.fRelayoutRequired = true;
            return;
        }
        this.fRelayoutRequired = false;
        if (this.fCachedTextViewer instanceof ITextViewerExtension && (control = (extension = (ITextViewerExtension)this.fCachedTextViewer).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    protected void computeIndentations() {
        if (this.fCanvas == null) {
            return;
        }
        GC gc = new GC((Drawable)this.fCanvas);
        try {
            gc.setFont(this.fCanvas.getFont());
            this.fIndentation = new int[this.fCachedNumberOfDigits + 1];
            char[] digitStr = new char[this.fCachedNumberOfDigits + 1];
            Arrays.fill(digitStr, '9');
            Point p = gc.stringExtent(new String(digitStr, 0, this.fCachedNumberOfDigits + 1));
            this.fIndentation[0] = p.x;
            int i = 1;
            while (i <= this.fCachedNumberOfDigits) {
                p = gc.stringExtent(new String(digitStr, 0, i));
                this.fIndentation[i] = this.fIndentation[0] - p.x;
                ++i;
            }
        }
        finally {
            gc.dispose();
        }
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(parentControl, 0);
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.setForeground(this.fForeground);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (DisassemblyRulerColumn.this.fCachedTextViewer != null) {
                    DisassemblyRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DisassemblyRulerColumn.this.handleDispose();
                DisassemblyRulerColumn.this.fCachedTextViewer = null;
                DisassemblyRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseHandler());
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener((IViewportListener)this.fInternalListener);
            this.fCachedTextViewer.addTextListener((ITextListener)this.fInternalListener);
            this.fCachedTextViewer.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fInternalListener);
            if (this.fFont == null && this.fCachedTextWidget != null && !this.fCachedTextWidget.isDisposed()) {
                this.fFont = this.fCachedTextWidget.getFont();
            }
        }
        if (this.fFont != null) {
            this.fCanvas.setFont(this.fFont);
        }
        this.updateNumberOfDigits();
        this.computeIndentations();
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener((IViewportListener)this.fInternalListener);
            this.fCachedTextViewer.removeTextListener((ITextListener)this.fInternalListener);
            this.fCachedTextViewer.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        gc.setFont(this.fCanvas.getFont());
        if (this.fForeground != null) {
            gc.setForeground(this.fForeground);
        }
        try {
            gc.setBackground(this.getBackground(this.fCanvas.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            if (this.fCachedTextViewer instanceof ITextViewerExtension5) {
                this.doPaint1(gc);
            } else {
                this.doPaint(gc);
            }
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        Rectangle clArea = this.fCachedTextWidget.getClientArea();
        return clArea.height / this.fCachedTextWidget.getLineHeight();
    }

    private void doPaint(GC gc) {
        int bottomLine;
        if (this.fCachedTextViewer == null) {
            return;
        }
        if (this.fCachedTextWidget == null) {
            return;
        }
        int firstLine = 0;
        int topLine = this.fCachedTextWidget.getTopIndex();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        int partialLineHidden = this.fScrollPos % lineheight;
        if (partialLineHidden > 0 && topLine > 0) {
            --topLine;
        }
        try {
            IRegion region = this.fCachedTextViewer.getVisibleRegion();
            IDocument doc = this.fCachedTextViewer.getDocument();
            if (doc == null) {
                return;
            }
            firstLine = doc.getLineOfOffset(region.getOffset());
            if (firstLine > topLine) {
                topLine = firstLine;
            }
            bottomLine = doc.getLineOfOffset(region.getOffset() + region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.fSensitiveToTextChanges = bottomLine - topLine < this.getVisibleLinesInViewport();
        int baselineBias = this.getBaselineBias(gc);
        int topInset = this.fCachedTextViewer.getTopInset();
        int y = topInset - partialLineHidden;
        Point canvasSize = this.fCanvas.getSize();
        Point selection = this.fCachedTextWidget.getSelection();
        boolean selectedLine = false;
        Color defaultForeground = gc.getForeground();
        Color defaultBackground = gc.getBackground();
        int line = topLine;
        while (y < canvasSize.y && line <= bottomLine) {
            StyleRange style;
            int widgetOffset = this.fCachedTextWidget.getOffsetAtLine(line);
            if (this.fPaintSelectionBackground && widgetOffset >= selection.x && widgetOffset < selection.y) {
                if (!selectedLine) {
                    selectedLine = true;
                    gc.setForeground(this.fCachedTextWidget.getSelectionForeground());
                    gc.setBackground(this.fCachedTextWidget.getSelectionBackground());
                }
            } else if (selectedLine) {
                selectedLine = false;
                gc.setForeground(defaultForeground);
                gc.setBackground(defaultBackground);
            }
            if (selectedLine) {
                gc.fillRectangle(0, y, canvasSize.x, lineheight);
            } else if (this.fPaintStyleBackground && widgetOffset >= 0 && widgetOffset < this.fCachedTextWidget.getCharCount() && (style = this.fCachedTextWidget.getStyleRangeAtOffset(widgetOffset)) != null && style.background != null) {
                gc.setBackground(style.background);
                gc.fillRectangle(0, y + baselineBias, canvasSize.x, lineheight - baselineBias);
                gc.setBackground(defaultBackground);
            }
            this.paintLine(line, y, lineheight, gc, this.fCachedTextWidget.getDisplay());
            String s = this.createDisplayString(line);
            int indentation = this.fAlignRight ? this.fIndentation[s.length()] : 0;
            gc.drawString(s, indentation, y + baselineBias, true);
            ++line;
            y += lineheight;
        }
    }

    String createDisplayString(int line) {
        return Integer.toString(line + 1);
    }

    private void doPaint1(GC gc) {
        if (this.fCachedTextViewer == null) {
            return;
        }
        ITextViewerExtension5 extension = (ITextViewerExtension5)this.fCachedTextViewer;
        int widgetTopLine = this.fCachedTextWidget.getTopIndex();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        int partialLineHidden = this.fScrollPos % lineheight;
        if (partialLineHidden > 0 && widgetTopLine > 0) {
            --widgetTopLine;
        }
        int modelTopLine = extension.widgetLine2ModelLine(widgetTopLine);
        int modelBottomLine = this.fCachedTextViewer.getBottomIndex();
        if (modelBottomLine >= 0) {
            ++modelBottomLine;
        }
        try {
            int coverageBottomLine;
            IRegion region = extension.getModelCoverage();
            IDocument doc = this.fCachedTextViewer.getDocument();
            if (doc == null) {
                return;
            }
            int coverageTopLine = doc.getLineOfOffset(region.getOffset());
            if (coverageTopLine > modelTopLine || modelTopLine == -1) {
                modelTopLine = coverageTopLine;
            }
            if ((coverageBottomLine = doc.getLineOfOffset(region.getOffset() + region.getLength())) < modelBottomLine || modelBottomLine == -1) {
                modelBottomLine = coverageBottomLine;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.fSensitiveToTextChanges = modelBottomLine - modelTopLine < this.getVisibleLinesInViewport();
        int baselineBias = this.getBaselineBias(gc);
        int topInset = this.fCachedTextViewer.getTopInset();
        int y = topInset - partialLineHidden;
        Point canvasSize = this.fCanvas.getSize();
        Point selection = this.fCachedTextWidget.getSelection();
        boolean selectedLine = false;
        Color defaultForeground = gc.getForeground();
        Color defaultBackground = gc.getBackground();
        int modelLine = modelTopLine;
        while (y < canvasSize.y && modelLine <= modelBottomLine) {
            int widgetLine = extension.modelLine2WidgetLine(modelLine);
            if (widgetLine != -1) {
                StyleRange style;
                int widgetOffset = this.fCachedTextWidget.getOffsetAtLine(widgetLine);
                if (this.fPaintSelectionBackground && widgetOffset >= selection.x && widgetOffset < selection.y) {
                    if (!selectedLine) {
                        selectedLine = true;
                        gc.setForeground(this.fCachedTextWidget.getSelectionForeground());
                        gc.setBackground(this.fCachedTextWidget.getSelectionBackground());
                    }
                } else if (selectedLine) {
                    selectedLine = false;
                    gc.setForeground(defaultForeground);
                    gc.setBackground(defaultBackground);
                }
                if (selectedLine) {
                    gc.fillRectangle(0, y, canvasSize.x, lineheight);
                } else if (this.fPaintStyleBackground && widgetOffset >= 0 && widgetOffset < this.fCachedTextWidget.getCharCount() && (style = this.fCachedTextWidget.getStyleRangeAtOffset(widgetOffset)) != null && style.background != null) {
                    gc.setBackground(style.background);
                    gc.fillRectangle(0, y + baselineBias, canvasSize.x, lineheight - baselineBias);
                    gc.setBackground(defaultBackground);
                }
                this.paintLine(modelLine, y, lineheight, gc, this.fCachedTextWidget.getDisplay());
                String s = this.createDisplayString(modelLine);
                int indentation = this.fAlignRight ? this.fIndentation[s.length()] : 0;
                gc.drawString(s, indentation, y + baselineBias, true);
                y += lineheight;
            }
            ++modelLine;
        }
    }

    private int getBaselineBias(GC gc) {
        FontMetrics fm;
        int fontBaseline;
        int widgetBaseline = this.fCachedTextWidget.getBaseline();
        Assert.isTrue((widgetBaseline >= (fontBaseline = (fm = gc.getFontMetrics()).getAscent() + fm.getLeading()) ? 1 : 0) != 0);
        int baselineBias = widgetBaseline - fontBaseline;
        return baselineBias;
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postRedraw() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    public void redraw() {
        if (this.fRelayoutRequired) {
            this.layout(true);
            return;
        }
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setModel(IAnnotationModel model) {
    }

    public void setFont(Font font) {
        this.fFont = font;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFont(this.fFont);
            this.updateNumberOfDigits();
            this.computeIndentations();
        }
    }

    protected CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    class InternalListener
    implements IViewportListener,
    ITextListener,
    ISelectionChangedListener {
        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (verticalPosition != DisassemblyRulerColumn.this.fScrollPos) {
                DisassemblyRulerColumn.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            if (DisassemblyRulerColumn.this.updateNumberOfDigits()) {
                DisassemblyRulerColumn.this.computeIndentations();
                DisassemblyRulerColumn.this.layout(event.getViewerRedrawState());
                return;
            }
            if (!event.getViewerRedrawState()) {
                return;
            }
            if (DisassemblyRulerColumn.this.fSensitiveToTextChanges || event.getDocumentEvent() == null) {
                DisassemblyRulerColumn.this.postRedraw();
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DisassemblyRulerColumn.this.postRedraw();
        }
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private int fCachedViewportSize;
        private IRegion fStartLine;
        private int fStartLineNumber;
        private int fAutoScrollDirection;

        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 1) {
                this.stopSelecting();
                this.stopAutoScroll();
                DisassemblyRulerColumn.this.postRedraw();
            }
        }

        public void mouseDown(MouseEvent event) {
            DisassemblyRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            if (event.button == 1) {
                this.startSelecting();
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
            DisassemblyRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseMove(MouseEvent event) {
            if (!this.autoScroll(event)) {
                int newLine = DisassemblyRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y);
                this.expandSelection(newLine);
            }
        }

        public void mouseEnter(MouseEvent event) {
        }

        public void mouseExit(MouseEvent event) {
        }

        public void mouseHover(MouseEvent event) {
        }

        private void startSelecting() {
            try {
                IDocument document = DisassemblyRulerColumn.this.fCachedTextViewer.getDocument();
                this.fStartLineNumber = DisassemblyRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                this.fStartLine = document.getLineInformation(this.fStartLineNumber);
                DisassemblyRulerColumn.this.fCachedTextViewer.setSelectedRange(this.fStartLine.getOffset(), this.fStartLine.getLength());
                this.fCachedViewportSize = DisassemblyRulerColumn.this.getVisibleLinesInViewport();
                DisassemblyRulerColumn.this.fCanvas.addMouseMoveListener((MouseMoveListener)this);
                DisassemblyRulerColumn.this.fCanvas.addMouseTrackListener((MouseTrackListener)this);
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopSelecting() {
            DisassemblyRulerColumn.this.fCanvas.removeMouseMoveListener((MouseMoveListener)this);
            DisassemblyRulerColumn.this.fCanvas.removeMouseTrackListener((MouseTrackListener)this);
        }

        private void expandSelection(int lineNumber) {
            try {
                IDocument document = DisassemblyRulerColumn.this.fCachedTextViewer.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber);
                int start = Math.min(this.fStartLine.getOffset(), lineInfo.getOffset());
                int end = Math.max(this.fStartLine.getOffset() + this.fStartLine.getLength(), lineInfo.getOffset() + lineInfo.getLength());
                if (lineNumber < this.fStartLineNumber) {
                    DisassemblyRulerColumn.this.fCachedTextViewer.setSelectedRange(end, start - end);
                } else {
                    DisassemblyRulerColumn.this.fCachedTextViewer.setSelectedRange(start, end - start);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopAutoScroll() {
            this.fAutoScrollDirection = 0;
        }

        private boolean autoScroll(MouseEvent event) {
            Rectangle area = DisassemblyRulerColumn.this.fCanvas.getClientArea();
            if (event.y > area.height) {
                this.autoScroll(1024);
                return true;
            }
            if (event.y < 0) {
                this.autoScroll(128);
                return true;
            }
            this.stopAutoScroll();
            return false;
        }

        private void autoScroll(int direction) {
            if (this.fAutoScrollDirection == direction) {
                return;
            }
            final Display display = DisassemblyRulerColumn.this.fCanvas.getDisplay();
            Runnable timer = null;
            switch (direction) {
                case 128: {
                    timer = new Runnable(){

                        @Override
                        public void run() {
                            int top;
                            if (MouseHandler.this.fAutoScrollDirection == 128 && (top = MouseHandler.this.getInclusiveTopIndex()) > 0) {
                                DisassemblyRulerColumn.this.fCachedTextViewer.setTopIndex(top - 1);
                                MouseHandler.this.expandSelection(top - 1);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
                case 1024: {
                    timer = new Runnable(){

                        @Override
                        public void run() {
                            if (MouseHandler.this.fAutoScrollDirection == 1024) {
                                int top = MouseHandler.this.getInclusiveTopIndex();
                                DisassemblyRulerColumn.this.fCachedTextViewer.setTopIndex(top + 1);
                                MouseHandler.this.expandSelection(top + 1 + MouseHandler.this.fCachedViewportSize);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                }
            }
            if (timer != null) {
                this.fAutoScrollDirection = direction;
                display.timerExec(5, timer);
            }
        }

        private int getInclusiveTopIndex() {
            if (DisassemblyRulerColumn.this.fCachedTextWidget != null && !DisassemblyRulerColumn.this.fCachedTextWidget.isDisposed()) {
                int top = DisassemblyRulerColumn.this.fCachedTextViewer.getTopIndex();
                if (DisassemblyRulerColumn.this.fCachedTextWidget.getTopPixel() % DisassemblyRulerColumn.this.fCachedTextWidget.getLineHeight() != 0) {
                    --top;
                }
                return top;
            }
            return -1;
        }
    }
}

